/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.shared;

import java.util.ArrayList;
import org.eclipse.ui.internal.intro.shared.ExtensionData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GroupData {
    private String path;
    private ArrayList extensions = new ArrayList();

    public GroupData(Element element) {
        this.path = element.getNodeName().equals("hidden") ? "hidden" : element.getAttribute("path");
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals("extension")) {
                this.loadExtension((Element)child);
            }
            ++i;
        }
    }

    private void loadExtension(Element element) {
        String id = element.getAttribute("id");
        String importance = element.getAttribute("importance");
        ExtensionData ed = new ExtensionData(id, importance);
        this.extensions.add(ed);
    }

    public ExtensionData[] getExtensions() {
        return this.extensions.toArray(new ExtensionData[this.extensions.size()]);
    }

    public String getPath() {
        return this.path;
    }

    public boolean contains(String extensionId) {
        int i = 0;
        while (i < this.extensions.size()) {
            ExtensionData ed = (ExtensionData)this.extensions.get(i);
            if (ed.getId().equals(extensionId)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

