/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberResourceMappingContext;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceTraversalAction;
import org.eclipse.team.internal.ccvs.ui.wizards.CommitWizard;
import org.eclipse.ui.PlatformUI;

public class CommitAction
extends WorkspaceTraversalAction {
    public void execute(IAction action) throws InvocationTargetException, InterruptedException {
        final IResource[][] resources = new IResource[1][];
        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    resources[0] = CommitAction.this.getDeepResourcesToCommit(monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        });
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    CommitWizard.run(CommitAction.this.getShell(), resources[0]);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }, false, 2);
    }

    private IResource[] getDeepResourcesToCommit(IProgressMonitor monitor) throws CoreException {
        ResourceMapping[] mappings = this.getCVSResourceMappings();
        ArrayList<IResource> roots = new ArrayList<IResource>();
        int i = 0;
        while (i < mappings.length) {
            ResourceMapping mapping = mappings[i];
            ResourceTraversal[] traversals = mapping.getTraversals((ResourceMappingContext)SubscriberResourceMappingContext.createContext((Subscriber)CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber()), monitor);
            int j = 0;
            while (j < traversals.length) {
                ResourceTraversal traversal = traversals[j];
                IResource[] resources = traversal.getResources();
                if (traversal.getDepth() == 2) {
                    roots.addAll(Arrays.asList(resources));
                } else if (traversal.getDepth() == 0) {
                    this.collectShallowFiles(resources, roots);
                } else if (traversal.getDepth() == 1) {
                    this.collectShallowFiles(resources, roots);
                    int k = 0;
                    while (k < resources.length) {
                        IResource resource = resources[k];
                        if (resource.getType() != 1) {
                            this.collectShallowFiles(this.members(resource), roots);
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return roots.toArray(new IResource[roots.size()]);
    }

    private IResource[] members(IResource resource) throws CoreException {
        return CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().members(resource);
    }

    private void collectShallowFiles(IResource[] resources, List roots) {
        int k = 0;
        while (k < resources.length) {
            IResource resource = resources[k];
            if (resource.getType() == 1) {
                roots.add(resource);
            }
            ++k;
        }
    }

    protected String getErrorTitle() {
        return CVSUIMessages.CommitAction_commitFailed;
    }

    protected boolean isEnabledForUnmanagedResources() {
        return true;
    }

    protected boolean isEnabledForNonExistantResources() {
        return true;
    }

    public String getId() {
        return "org.eclipse.team.cvs.ui.commit";
    }
}

