/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.mappings;

import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.core.diff.FastDiffFilter;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffTree;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.mapping.IMergeContext;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.mappings.ModelUpdateOperation;
import org.eclipse.ui.IWorkbenchPart;

public class ModelReplaceOperation
extends ModelUpdateOperation {
    boolean hasPrompted = false;

    public ModelReplaceOperation(IWorkbenchPart part, ResourceMapping[] selectedMappings, boolean consultModels) {
        super(part, selectedMappings, consultModels);
    }

    protected String getJobName() {
        return CVSUIMessages.ReplaceOperation_taskName;
    }

    protected boolean isAttemptHeadlessMerge() {
        return true;
    }

    protected boolean hasChangesOfInterest() {
        IMergeContext context = (IMergeContext)this.getContext();
        return !context.getDiffTree().isEmpty();
    }

    protected int getMergeType() {
        return 2;
    }

    protected IStatus performMerge(IProgressMonitor monitor) throws CoreException {
        if (!this.hasLocalChanges() || this.promptForOverwrite()) {
            return super.performMerge(monitor);
        }
        return new Status(4, "org.eclipse.team.cvs.ui", 1024, "", null);
    }

    protected boolean promptForOverwrite() {
        if (this.hasPrompted) {
            return true;
        }
        final int[] result = new int[]{1};
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                MessageDialog dialog = new MessageDialog(ModelReplaceOperation.this.getShell(), CVSUIMessages.ModelReplaceOperation_0, null, CVSUIMessages.ModelReplaceOperation_1, 3, new String[]{CVSUIMessages.ModelReplaceOperation_2, CVSUIMessages.ModelReplaceOperation_3, IDialogConstants.CANCEL_LABEL}, result[0]);
                result[0] = dialog.open();
            }
        });
        if (result[0] == 2) {
            throw new OperationCanceledException();
        }
        this.hasPrompted = true;
        return result[0] == 0;
    }

    private boolean hasLocalChanges() {
        return this.hasChangesMatching((IDiffTree)this.getContext().getDiffTree(), new FastDiffFilter(){

            public boolean select(IDiff node) {
                if (node instanceof IThreeWayDiff) {
                    IThreeWayDiff twd = (IThreeWayDiff)node;
                    int direction = twd.getDirection();
                    return direction == 256 || direction == 768;
                }
                return true;
            }
        });
    }
}

