/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.IResourceDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.synchronize.SyncInfoFilter;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.CacheTreeContentsOperation;
import org.eclipse.ui.IWorkbenchPart;

public class CacheBaseContentsOperation
extends CacheTreeContentsOperation {
    private final boolean includeOutgoing;

    public CacheBaseContentsOperation(IWorkbenchPart part, ResourceMapping[] mappings, IResourceDiffTree tree, boolean includeOutgoing) {
        super(part, mappings, tree);
        this.includeOutgoing = includeOutgoing;
    }

    protected IFileRevision getRemoteFileState(IThreeWayDiff twd) {
        IResourceDiff diff = (IResourceDiff)twd.getRemoteChange();
        if (diff == null) {
            diff = (IResourceDiff)twd.getLocalChange();
        }
        IFileRevision base = diff.getBeforeState();
        return base;
    }

    protected boolean isEnabledForDirection(int direction) {
        return true;
    }

    protected ICVSRemoteResource buildTree(CVSTeamProvider provider) throws TeamException {
        return CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().buildBaseTree((IResource)provider.getProject(), true, (IProgressMonitor)new NullProgressMonitor());
    }

    protected void execute(CVSTeamProvider provider, IResource[] resources, boolean recurse, IProgressMonitor monitor) throws CVSException, InterruptedException {
        IResource[] localChanges = this.getFilesWithLocalChanges(resources, recurse);
        super.execute(provider, resources, recurse, monitor);
        if (localChanges.length > 0) {
            this.performCleanTimestamps(localChanges[0].getProject(), localChanges, monitor);
        }
    }

    private IResource[] getFilesWithLocalChanges(IResource[] resources, boolean recurse) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            IDiff[] nodes = this.getTree().getDiffs(resource, recurse ? 2 : 1);
            int j = 0;
            while (j < nodes.length) {
                IDiff node = nodes[j];
                if (this.isFileWithLocalChange(node)) {
                    result.add(this.getTree().getResource(node));
                }
                ++j;
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    private boolean isFileWithLocalChange(IDiff node) {
        if (node instanceof IThreeWayDiff) {
            IThreeWayDiff twd = (IThreeWayDiff)node;
            return (twd.getDirection() == 256 || twd.getDirection() == 768) && this.getTree().getResource(node).getType() == 1;
        }
        return false;
    }

    private void performCleanTimestamps(IProject project, final IResource[] resources, IProgressMonitor monitor) throws CVSException {
        ICVSFolder folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)project);
        final SyncInfoFilter.ContentComparisonSyncInfoFilter comparator = new SyncInfoFilter.ContentComparisonSyncInfoFilter(false);
        folder.run(new ICVSRunnable(){

            public void run(IProgressMonitor monitor) throws CVSException {
                monitor.beginTask(null, resources.length * 100);
                int i = 0;
                while (i < resources.length) {
                    IResourceVariant remoteResource;
                    IResource resource = resources[i];
                    if (resource.exists() && resource.getType() == 1 && (remoteResource = (IResourceVariant)CVSWorkspaceRoot.getRemoteResourceFor((IResource)resource)) != null && comparator.compareContents((IFile)resource, remoteResource, Policy.subMonitorFor(monitor, 100))) {
                        ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)((IFile)resource));
                        cvsFile.checkedIn(null, false);
                    }
                    ++i;
                }
                monitor.done();
            }
        }, Policy.subMonitorFor(monitor, 100));
    }
}

