/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.history;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileHistoryProvider;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.history.FileRevisionEditorInput;
import org.eclipse.team.internal.ui.history.GenericHistoryDropAdapter;
import org.eclipse.team.internal.ui.history.GenericHistoryViewDefaultPage;
import org.eclipse.team.internal.ui.history.LocalHistoryPage;
import org.eclipse.team.internal.ui.history.WorkbenchHistoryPageSite;
import org.eclipse.team.ui.history.IHistoryPage;
import org.eclipse.team.ui.history.IHistoryPageSource;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageSite;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ViewPart;

public class GenericHistoryView
extends ViewPart
implements IHistoryView {
    private PageBook book;
    private Action refreshAction;
    private Action linkWithEditorAction;
    private Action pinAction;
    private PageContainer defaultPageContainer;
    PageContainer currentPageContainer;
    DropTarget dropTarget;
    GenericHistoryDropAdapter dropAdapter;
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                GenericHistoryView.this.editorActivated((IEditorPart)part);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            if (part == GenericHistoryView.this) {
                GenericHistoryView.this.editorActivated(GenericHistoryView.this.getViewSite().getPage().getActiveEditor());
            }
        }

        public void partOpened(IWorkbenchPart part) {
            if (part == GenericHistoryView.this) {
                GenericHistoryView.this.editorActivated(GenericHistoryView.this.getViewSite().getPage().getActiveEditor());
            }
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }
    };
    private IPartListener2 partListener2 = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }

        public void partHidden(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            if (ref.getPart(true) == GenericHistoryView.this) {
                GenericHistoryView.this.editorActivated(GenericHistoryView.this.getViewSite().getPage().getActiveEditor());
            }
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
        }
    };
    private ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (!GenericHistoryView.this.isLinkingEnabled()) {
                return;
            }
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structSelection = (IStructuredSelection)selection;
                Object firstElement = structSelection.getFirstElement();
                GenericHistoryView.this.itemDropped(firstElement);
            }
        }
    };
    private IPropertyChangeListener actionBarPropListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("org.eclipse.ui.internal.actionHandlers") && GenericHistoryView.this.currentPageContainer.getPage() != null && event.getSource() == GenericHistoryView.this.currentPageContainer.getSubBars()) {
                GenericHistoryView.this.refreshGlobalActionHandlers();
            }
        }
    };
    private boolean linkingEnabled;
    private boolean viewPinned;
    public static final String viewId = "org.eclipse.team.ui.GenericHistoryView";
    static /* synthetic */ Class class$0;

    void refreshGlobalActionHandlers() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.clearGlobalActionHandlers();
        Map newActionHandlers = this.currentPageContainer.getSubBars().getGlobalActionHandlers();
        if (newActionHandlers != null) {
            Set keys = newActionHandlers.entrySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                bars.setGlobalActionHandler((String)entry.getKey(), (IAction)entry.getValue());
            }
        }
    }

    public void createPartControl(Composite parent) {
        this.book = new PageBook(parent, 0);
        this.linkingEnabled = TeamUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_generichistory_view_linking");
        this.defaultPageContainer = this.createDefaultPage(this.book);
        this.configureToolbars(this.getViewSite().getActionBars());
        this.initDragAndDrop();
        this.showPageRec(this.defaultPageContainer);
        this.getSite().getPage().addPartListener(this.partListener);
        this.getSite().getPage().addPartListener(this.partListener2);
        this.getSite().getPage().addSelectionListener(this.selectionListener);
    }

    private void configureToolbars(IActionBars actionBars) {
        this.pinAction = new Action(TeamUIMessages.GenericHistoryView_PinCurrentHistory, TeamUIPlugin.getImageDescriptor("elcl16/pin.gif")){

            public void run() {
                if (this.isChecked()) {
                    GenericHistoryView.this.linkWithEditorAction.setChecked(false);
                    GenericHistoryView.this.linkWithEditorAction.setEnabled(false);
                    GenericHistoryView.this.setLinkingEnabled(false);
                } else {
                    GenericHistoryView.this.linkWithEditorAction.setEnabled(true);
                }
                GenericHistoryView.this.setViewPinned(this.isChecked());
            }
        };
        this.pinAction.setChecked(this.isViewPinned());
        this.pinAction.setToolTipText(TeamUIMessages.GenericHistoryView_0);
        this.refreshAction = new Action(TeamUIMessages.GenericHistoryView_Refresh, TeamUIPlugin.getImageDescriptor("elcl16/refresh.gif")){

            public void run() {
                ((IHistoryPage)GenericHistoryView.this.currentPageContainer.getPage()).refresh();
            }
        };
        this.linkWithEditorAction = new Action(TeamUIMessages.GenericHistoryView_LinkWithEditor, TeamUIPlugin.getImageDescriptor("elcl16/synced.gif")){

            public void run() {
                GenericHistoryView.this.setLinkingEnabled(GenericHistoryView.this.isViewPinned() ? false : this.isChecked());
            }
        };
        this.linkWithEditorAction.setChecked(this.isLinkingEnabled());
        IToolBarManager tbm = actionBars.getToolBarManager();
        tbm.add((IAction)this.refreshAction);
        tbm.add((IAction)this.linkWithEditorAction);
        tbm.add((IAction)this.pinAction);
        tbm.update(false);
    }

    boolean isLinkingEnabled() {
        return this.linkingEnabled;
    }

    public void setLinkingEnabled(boolean enabled) {
        this.linkingEnabled = enabled;
        TeamUIPlugin.getPlugin().getPreferenceStore().setValue("pref_generichistory_view_linking", enabled);
        if (enabled) {
            this.editorActivated(this.getSite().getPage().getActiveEditor());
        }
    }

    void setViewPinned(boolean pinned) {
        this.viewPinned = pinned;
    }

    void initDragAndDrop() {
        int ops = 7;
        Transfer[] transfers = new Transfer[]{ResourceTransfer.getInstance(), PluginTransfer.getInstance()};
        this.dropTarget = new DropTarget((Control)this.book, ops);
        this.dropTarget.setTransfer(transfers);
        this.dropAdapter = new GenericHistoryDropAdapter(this);
        this.dropTarget.addDropListener((DropTargetListener)this.dropAdapter);
    }

    public void setFocus() {
    }

    private void preparePage(PageContainer pageContainer) {
        pageContainer.getSubBars().addPropertyChangeListener(this.actionBarPropListener);
        pageContainer.getPage().setActionBars((IActionBars)pageContainer.getSubBars());
    }

    protected void showPageRec(PageContainer pageContainer) {
        if (this.currentPageContainer == pageContainer) {
            return;
        }
        if (this.currentPageContainer != null && pageContainer != null && this.currentPageContainer == pageContainer) {
            this.currentPageContainer = pageContainer;
            return;
        }
        if (this.currentPageContainer != null) {
            this.currentPageContainer.getSubBars().deactivate();
        }
        this.currentPageContainer = pageContainer;
        Control pageControl = this.currentPageContainer.getPage().getControl();
        if (pageControl != null && !pageControl.isDisposed()) {
            this.book.showPage(pageControl);
            this.currentPageContainer.getSubBars().activate();
            this.getViewSite().getActionBars().updateActionBars();
        }
    }

    protected PageSite initPage(IPageBookViewPage page) {
        try {
            PageSite site = new PageSite(this.getViewSite());
            page.init((IPageSite)site);
            return site;
        }
        catch (PartInitException e) {
            TeamUIPlugin.log((CoreException)((Object)e));
            return null;
        }
    }

    public IHistoryPage itemDropped(Object object) {
        IResource resource = Utils.getResource(object);
        if (resource != null) {
            Object tempPageSource;
            IHistoryPage pinnedPage = this.checkForPinnedView(object, resource.getName());
            if (pinnedPage != null) {
                return pinnedPage;
            }
            RepositoryProvider teamProvider = RepositoryProvider.getProvider((IProject)resource.getProject());
            if (teamProvider == null) {
                return this.localItemDropped(resource);
            }
            IFileHistoryProvider fileHistory = teamProvider.getFileHistoryProvider();
            IAdapterManager iAdapterManager = Platform.getAdapterManager();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.team.ui.history.IHistoryPageSource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((tempPageSource = iAdapterManager.getAdapter((Object)fileHistory, (Class)clazz)) instanceof IHistoryPageSource) {
                IHistoryPageSource pageSource = (IHistoryPageSource)tempPageSource;
                if (this.currentPageContainer.getPage() instanceof IHistoryPage) {
                    PageContainer tempPageContainer = this.currentPageContainer;
                    if (!((IHistoryPage)tempPageContainer.getPage()).canShowHistoryFor(resource)) {
                        tempPageContainer = this.createPage(pageSource, resource);
                    }
                    if (tempPageContainer != null) {
                        if (((IHistoryPage)tempPageContainer.getPage()).showHistory(resource, true)) {
                            this.setContentDescription(resource.getName());
                            this.showPageRec(tempPageContainer);
                            return (IHistoryPage)tempPageContainer.getPage();
                        }
                    } else {
                        this.showPageRec(this.defaultPageContainer);
                    }
                }
            }
        } else if (object != null) {
            IHistoryPageSource historyPageSource;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.team.ui.history.IHistoryPageSource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((historyPageSource = (IHistoryPageSource)Utils.getAdapter(object, clazz)) == null) {
                return null;
            }
            if (this.currentPageContainer.getPage() instanceof IHistoryPage) {
                PageContainer tempPageContainer = this.currentPageContainer;
                if (!((IHistoryPage)tempPageContainer.getPage()).canShowHistoryFor(object)) {
                    tempPageContainer = this.createPage(historyPageSource, object);
                }
                if (tempPageContainer != null) {
                    IHistoryPage pinnedPage = this.checkForPinnedView(object, ((IHistoryPage)tempPageContainer.getPage()).getName());
                    if (pinnedPage != null) {
                        return pinnedPage;
                    }
                    if (((IHistoryPage)tempPageContainer.getPage()).showHistory(object, true)) {
                        this.setContentDescription(((IHistoryPage)tempPageContainer.getPage()).getName());
                        this.showPageRec(tempPageContainer);
                        return (IHistoryPage)tempPageContainer.getPage();
                    }
                } else {
                    this.showPageRec(this.defaultPageContainer);
                }
            }
        }
        return null;
    }

    private IHistoryPage checkForPinnedView(Object object, String objectName) {
        if (this.isViewPinned()) {
            try {
                IViewPart view = this.getSite().getPage().showView(viewId, viewId + objectName + System.currentTimeMillis(), 3);
                if (view instanceof GenericHistoryView) {
                    GenericHistoryView view2 = (GenericHistoryView)view;
                    return view2.itemDropped(object);
                }
            }
            catch (PartInitException partInitException) {}
        }
        return null;
    }

    boolean isViewPinned() {
        return this.viewPinned;
    }

    private PageContainer createPage(IHistoryPageSource participant, Object object) {
        Page page = participant.createPage(object);
        PageSite site = this.initPage((IPageBookViewPage)page);
        ((IHistoryPage)page).setSite(new WorkbenchHistoryPageSite((IWorkbenchPart)this, page.getSite()));
        page.createControl((Composite)this.book);
        PageContainer container = new PageContainer(page);
        container.setSubBars((SubActionBars)site.getActionBars());
        return container;
    }

    protected PageContainer createDefaultPage(PageBook book) {
        GenericHistoryViewDefaultPage page = new GenericHistoryViewDefaultPage();
        PageSite site = this.initPage((IPageBookViewPage)page);
        page.createControl((Composite)book);
        PageContainer container = new PageContainer(page);
        container.setSubBars((SubActionBars)site.getActionBars());
        return container;
    }

    protected PageContainer createLocalPage(PageBook book) {
        LocalHistoryPage page = new LocalHistoryPage();
        PageSite site = this.initPage((IPageBookViewPage)page);
        page.setSite(new WorkbenchHistoryPageSite((IWorkbenchPart)this, page.getSite()));
        page.createControl((Composite)book);
        PageContainer container = new PageContainer(page);
        container.setSubBars((SubActionBars)site.getActionBars());
        return container;
    }

    protected void editorActivated(IEditorPart editor) {
        if (editor == null || !this.isLinkingEnabled() || !this.checkIfPageIsVisible() || this.isViewPinned()) {
            return;
        }
        IEditorInput input = editor.getEditorInput();
        if (input instanceof FileRevisionEditorInput) {
            try {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(((FileRevisionEditorInput)input).getStorage().getFullPath());
                if (file != null) {
                    this.itemDropped(file);
                }
            }
            catch (CoreException coreException) {}
        } else {
            IFile file = ResourceUtil.getFile((IEditorInput)input);
            if (file != null) {
                this.itemDropped(file);
            }
        }
    }

    private boolean checkIfPageIsVisible() {
        return this.getViewSite().getPage().isPartVisible((IWorkbenchPart)this);
    }

    public void dispose() {
        super.dispose();
        if (this.dropTarget != null && !this.dropTarget.isDisposed()) {
            this.dropTarget.removeDropListener((DropTargetListener)this.dropAdapter);
        }
        this.currentPageContainer.getPage().dispose();
        this.defaultPageContainer.getPage().dispose();
        this.getSite().getPage().removePartListener(this.partListener);
        this.getSite().getPage().removePartListener(this.partListener2);
        this.getSite().getPage().removeSelectionListener(this.selectionListener);
    }

    public IHistoryPage localItemDropped(IResource resource) {
        PageContainer container = this.createLocalPage(this.book);
        IHistoryPage localPage = (IHistoryPage)container.getPage();
        if (localPage.showHistory(resource, true)) {
            this.setContentDescription(resource.getName());
            this.showPageRec(container);
            return localPage;
        }
        return null;
    }

    public IHistoryPage showHistoryFor(Object object) {
        return this.itemDropped(object);
    }

    public IHistoryPage getHistoryPage() {
        if (this.currentPageContainer != null && this.currentPageContainer.getPage() != null) {
            return (IHistoryPage)this.currentPageContainer.getPage();
        }
        return (IHistoryPage)this.defaultPageContainer.getPage();
    }

    class PageContainer {
        private Page page;
        private SubActionBars subBars;

        public PageContainer(Page page) {
            this.page = page;
        }

        public Page getPage() {
            return this.page;
        }

        public void setPage(Page page) {
            this.page = page;
        }

        public SubActionBars getSubBars() {
            return this.subBars;
        }

        public void setSubBars(SubActionBars subBars) {
            this.subBars = subBars;
        }
    }
}

