/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.history;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.history.LocalHistoryTableProvider;
import org.eclipse.team.internal.ui.history.OpenLocalFileAction;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.team.ui.history.IHistoryPageSite;
import org.eclipse.ui.IWorkbenchSite;

public class LocalHistoryPage
extends HistoryPage {
    Composite pgComp;
    TableViewer tableViewer;
    LocalHistoryTableProvider historyTableProvider;
    boolean shutdown = false;
    IFileState[] entries;
    protected FetchLocalHistoryJob fetchLocalHistoryJob;
    private IHistoryPageSite parentSite;
    private OpenLocalFileAction openAction;

    public boolean showHistory(Object object, boolean refetch) {
        if (object instanceof IFile) {
            IFile newfile = (IFile)object;
            if (!refetch || object == null) {
                return false;
            }
            this.tableViewer.setInput((Object)newfile);
            return true;
        }
        return false;
    }

    public boolean canShowHistoryFor(Object object) {
        return false;
    }

    public void refresh() {
    }

    public String getName() {
        return null;
    }

    public void setSite(IHistoryPageSite viewSite) {
        this.parentSite = viewSite;
    }

    public void createControl(Composite parent) {
        this.pgComp = new Composite(parent, 0);
        this.pgComp.setLayout((Layout)new FillLayout());
        this.tableViewer = this.createTable(this.pgComp);
        this.contributeActions();
    }

    private void contributeActions() {
        this.openAction = new OpenLocalFileAction(TeamUIMessages.LocalHistoryPage_openRevision);
        this.tableViewer.getTable().addListener(14, new Listener(){

            public void handleEvent(Event e) {
                LocalHistoryPage.this.openAction.selectionChanged((IStructuredSelection)LocalHistoryPage.this.tableViewer.getSelection());
                LocalHistoryPage.this.openAction.run();
            }
        });
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.tableViewer.getTable());
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuMgr) {
                LocalHistoryPage.this.fillTableMenu(menuMgr);
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        this.tableViewer.getTable().setMenu(menu);
        this.parentSite.getWorkbenchPartSite().registerContextMenu(menuMgr, (ISelectionProvider)this.tableViewer);
    }

    void fillTableMenu(IMenuManager menuMgr) {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        this.openAction.selectionChanged(selection);
        menuMgr.add((IAction)this.openAction);
        menuMgr.add((IContributionItem)new Separator("additions"));
    }

    private TableViewer createTable(Composite parent) {
        this.historyTableProvider = new LocalHistoryTableProvider();
        TableViewer viewer = this.historyTableProvider.createTable(parent);
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                IFile file;
                if (LocalHistoryPage.this.entries != null) {
                    return LocalHistoryPage.this.entries;
                }
                if (!(inputElement instanceof IResource)) {
                    return null;
                }
                IFile inputFile = (IFile)inputElement;
                if (LocalHistoryPage.this.fetchLocalHistoryJob == null) {
                    LocalHistoryPage.this.fetchLocalHistoryJob = new FetchLocalHistoryJob();
                }
                if ((file = LocalHistoryPage.this.fetchLocalHistoryJob.getFile()) == null || !file.equals((Object)inputFile)) {
                    if (LocalHistoryPage.this.fetchLocalHistoryJob.getState() != 0) {
                        LocalHistoryPage.this.fetchLocalHistoryJob.cancel();
                        try {
                            LocalHistoryPage.this.fetchLocalHistoryJob.join();
                        }
                        catch (InterruptedException e) {
                            TeamUIPlugin.log((CoreException)((Object)new TeamException(NLS.bind((String)TeamUIMessages.GenericHistoryView_ErrorFetchingEntries, (Object[])new String[]{""}), (Throwable)e)));
                        }
                    }
                    LocalHistoryPage.this.fetchLocalHistoryJob.setFile(inputFile);
                }
                Utils.schedule(LocalHistoryPage.this.fetchLocalHistoryJob, (IWorkbenchSite)LocalHistoryPage.this.parentSite.getWorkbenchPartSite());
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        return viewer;
    }

    public Control getControl() {
        return this.pgComp;
    }

    public void setFocus() {
        this.pgComp.setFocus();
    }

    public IHistoryPageSite getHistoryPageSite() {
        return this.parentSite;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    private class FetchLocalHistoryJob
    extends Job {
        public IFile localFile;

        public FetchLocalHistoryJob() {
            super(TeamUIMessages.LocalHistoryPage_fetchingLocalHistory);
        }

        public IFile getFile() {
            return this.localFile;
        }

        public void setFile(IFile file) {
            this.localFile = file;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                if (this.localFile != null && !LocalHistoryPage.this.shutdown) {
                    LocalHistoryPage.this.entries = this.localFile.getHistory(monitor);
                    LocalHistoryPage.this.getSite().getShell().getDisplay().asyncExec(new Runnable(this){
                        final /* synthetic */ FetchLocalHistoryJob this$1;
                        {
                            this.this$1 = fetchLocalHistoryJob;
                        }

                        public void run() {
                            if (FetchLocalHistoryJob.access$0((FetchLocalHistoryJob)this.this$1).entries != null && FetchLocalHistoryJob.access$0((FetchLocalHistoryJob)this.this$1).tableViewer != null && !FetchLocalHistoryJob.access$0((FetchLocalHistoryJob)this.this$1).tableViewer.getTable().isDisposed()) {
                                FetchLocalHistoryJob.access$0((FetchLocalHistoryJob)this.this$1).tableViewer.refresh();
                            }
                        }
                    });
                }
                return Status.OK_STATUS;
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }

        static /* synthetic */ LocalHistoryPage access$0(FetchLocalHistoryJob fetchLocalHistoryJob) {
            return fetchLocalHistoryJob.LocalHistoryPage.this;
        }
    }
}

