/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScope;
import org.eclipse.team.core.mapping.ISynchronizationScopeChangeListener;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.ShowModelProviderAction;
import org.eclipse.team.ui.mapping.ModelOperation;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;

public class ModelSelectionDropDownAction
extends Action
implements IMenuCreator,
ISynchronizationScopeChangeListener {
    private final ISynchronizePageConfiguration configuration;
    private MenuManager menuManager;
    private Action showAllAction;
    private IPropertyChangeListener listener;

    public ModelSelectionDropDownAction(ISynchronizePageConfiguration configuration) {
        Utils.initAction((IAction)this, "action.pickModels.");
        this.configuration = configuration;
        this.listener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty() == "org.eclipse.team.ui.activeModelProvider") {
                    ModelSelectionDropDownAction.this.update();
                }
            }
        };
        this.configuration.addPropertyChangeListener(this.listener);
        this.getSynchronizationContext().getScope().addScopeChangeListener((ISynchronizationScopeChangeListener)this);
        this.showAllAction = new Action("Show All"){

            public void run() {
                Viewer v = ModelSelectionDropDownAction.this.configuration.getPage().getViewer();
                v.setInput((Object)ModelSelectionDropDownAction.this.getSynchronizationContext());
                ModelSelectionDropDownAction.this.configuration.setProperty("org.eclipse.team.ui.activeModelProvider", "org.eclipse.team.ui.activeModelProvider");
                ModelSelectionDropDownAction.this.configuration.setProperty("org.eclipse.team.ui.P_PAGE_DESCRIPTION", ModelSelectionDropDownAction.this.configuration.getParticipant().getName());
            }
        };
        this.setMenuCreator(this);
        this.update();
    }

    private ISynchronizationContext getSynchronizationContext() {
        return (ISynchronizationContext)this.configuration.getProperty("org.eclipse.team.ui.synchronizationContext");
    }

    public void dispose() {
        if (this.menuManager != null) {
            this.menuManager.dispose();
            this.menuManager = null;
        }
        this.getSynchronizationContext().getScope().removeScopeChangeListener((ISynchronizationScopeChangeListener)this);
        this.configuration.removePropertyChangeListener(this.listener);
    }

    public Menu getMenu(Control parent) {
        Menu fMenu = null;
        if (this.menuManager == null) {
            this.menuManager = new MenuManager();
            fMenu = this.menuManager.createContextMenu(parent);
            this.menuManager.add((IAction)this.showAllAction);
            ModelProvider[] modelProviders = ((ModelSynchronizeParticipant)this.configuration.getParticipant()).getActiveModelProviders();
            if (modelProviders.length > 0) {
                this.menuManager.add((IContributionItem)new Separator());
            }
            this.addModelsToMenu(modelProviders);
            this.menuManager.update(true);
        } else {
            fMenu = this.menuManager.getMenu();
        }
        return fMenu;
    }

    private void addModelsToMenu(ModelProvider[] modelProviders) {
        String id = this.getActiveProviderId();
        int i = 0;
        while (i < modelProviders.length) {
            ModelProvider provider = modelProviders[i];
            ShowModelProviderAction action = new ShowModelProviderAction(this.configuration, provider);
            action.setChecked(provider.getDescriptor().getId().equals(id));
            this.menuManager.add((IAction)action);
            ++i;
        }
    }

    private String getActiveProviderId() {
        String id = (String)this.configuration.getProperty("org.eclipse.team.ui.activeModelProvider");
        if (id == null) {
            id = "org.eclipse.team.ui.activeModelProvider";
        }
        return id;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    private ModelProvider getNextProvider() {
        ModelProvider[] providers = this.getSynchronizationContext().getScope().getModelProviders();
        providers = ModelOperation.sortByExtension(providers);
        String id = this.getActiveProviderId();
        int index = 0;
        if (id != null) {
            int i = 0;
            while (i < providers.length) {
                ModelProvider provider = providers[i];
                if (provider.getDescriptor().getId().equals(id)) {
                    index = i + 1;
                    break;
                }
                ++i;
            }
            if (index == providers.length) {
                index = 0;
            }
        }
        return providers[index];
    }

    public void update() {
        ModelProvider next = this.getNextProvider();
        String text = NLS.bind((String)"Show {0}", (Object)next.getDescriptor().getLabel());
        this.setToolTipText(text);
        this.setText(text);
        if (this.menuManager != null) {
            IContributionItem[] items = this.menuManager.getItems();
            int i = 0;
            while (i < items.length) {
                ActionContributionItem aci;
                IAction a;
                IContributionItem item = items[i];
                if (item instanceof ActionContributionItem && (a = (aci = (ActionContributionItem)item).getAction()) instanceof ShowModelProviderAction) {
                    ShowModelProviderAction action = (ShowModelProviderAction)a;
                    action.setChecked(action.getProviderId().equals(this.getActiveProviderId()));
                }
                ++i;
            }
        }
    }

    public void run() {
        ModelProvider next = this.getNextProvider();
        ShowModelProviderAction action = new ShowModelProviderAction(this.configuration, next);
        action.run();
    }

    public void scopeChanged(ISynchronizationScope scope, ResourceMapping[] newMappings, ResourceTraversal[] newTraversals) {
        if (newMappings.length > 0) {
            Display display = TeamUIPlugin.getStandardDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    if (ModelSelectionDropDownAction.this.menuManager != null) {
                        ModelSelectionDropDownAction.this.menuManager.dispose();
                        ModelSelectionDropDownAction.this.menuManager = null;
                    }
                    ModelSelectionDropDownAction.this.update();
                }
            });
        }
    }
}

