/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.util.HashSet;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.ResourceMappingLabelProvider;
import org.eclipse.team.internal.ui.mapping.ResourceModelContentProvider;
import org.eclipse.team.ui.mapping.SynchronizationLabelProvider;
import org.eclipse.ui.navigator.IExtensionStateModel;

public class ResourceModelLabelProvider
extends SynchronizationLabelProvider
implements IFontProvider,
IResourceChangeListener {
    private ILabelProvider provider = new ResourceMappingLabelProvider();
    private ResourceModelContentProvider contentProvider;

    public void init(IExtensionStateModel aStateModel, ITreeContentProvider aContentProvider) {
        if (aContentProvider instanceof ResourceModelContentProvider) {
            this.contentProvider = (ResourceModelContentProvider)aContentProvider;
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }
        super.init(aStateModel, aContentProvider);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    protected ILabelProvider getDelegateLabelProvider() {
        return this.provider;
    }

    protected IDiff getDiff(Object element) {
        ISynchronizationContext context;
        IResource resource = this.getResource(element);
        if (resource != null && (context = this.getContext()) != null) {
            IDiff delta = context.getDiffTree().getDiff(resource.getFullPath());
            return delta;
        }
        return null;
    }

    private IResource getResource(Object element) {
        if (element instanceof IResource) {
            return (IResource)element;
        }
        return null;
    }

    protected boolean isIncludeOverlays() {
        return true;
    }

    protected boolean isBusy(Object element) {
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            ISynchronizationContext context = this.getContext();
            if (context != null) {
                return context.getDiffTree().getProperty(resource.getFullPath(), 1);
            }
        }
        return super.isBusy(element);
    }

    protected boolean hasDecendantConflicts(Object element) {
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            ISynchronizationContext context = this.getContext();
            if (context != null) {
                return context.getDiffTree().getProperty(resource.getFullPath(), 2);
            }
        }
        return super.hasDecendantConflicts(element);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        String[] markerTypes = new String[]{"org.eclipse.core.resources.problemmarker"};
        final HashSet<IResource> handledResources = new HashSet<IResource>();
        int idx = 0;
        while (idx < markerTypes.length) {
            IMarkerDelta[] markerDeltas = event.findMarkerDeltas(markerTypes[idx], true);
            int i = 0;
            while (i < markerDeltas.length) {
                IMarkerDelta delta = markerDeltas[i];
                IResource resource = delta.getResource();
                while (resource != null && resource.getType() != 8 && !handledResources.contains(resource)) {
                    handledResources.add(resource);
                    resource = resource.getParent();
                }
                ++i;
            }
            ++idx;
        }
        if (!handledResources.isEmpty()) {
            Utils.asyncExec(new Runnable(){

                public void run() {
                    ResourceModelLabelProvider.this.contentProvider.getStructuredViewer().update((Object[])handledResources.toArray(new IResource[handledResources.size()]), null);
                }
            }, this.contentProvider.getStructuredViewer());
        }
    }
}

