/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.mapping;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.internal.ui.mapping.CommonMenuManager;
import org.eclipse.team.ui.mapping.MergeActionHandler;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.CommonActionProviderConfig;
import org.eclipse.ui.navigator.IExtensionStateModel;

public class SynchronizationActionProvider
extends CommonActionProvider {
    public static final String MERGE_ACTION_ID = "org.eclipse.team.ui.mergeAction";
    public static final String OVERWRITE_ACTION_ID = "org.eclipse.team.ui.overwriteAction";
    public static final String MARK_AS_MERGE_ACTION_ID = "org.eclipse.team.ui.markAsMergeAction";
    private CommonActionProviderConfig config;
    private Map handlers = new HashMap();

    public final void init(CommonActionProviderConfig aConfig) {
        this.config = aConfig;
        this.initialize();
    }

    protected void initialize() {
    }

    public final CommonActionProviderConfig getCommonConfiguration() {
        return this.config;
    }

    protected final ISynchronizePageConfiguration getSynchronizePageConfiguration() {
        return (ISynchronizePageConfiguration)this.getExtensionStateModel().getProperty("org.eclipse.team.ui.synchronizationPageConfiguration");
    }

    protected final IExtensionStateModel getExtensionStateModel() {
        return this.config.getExtensionStateModel();
    }

    protected final ISynchronizationContext getSynchronizationContext() {
        return (ISynchronizationContext)this.getExtensionStateModel().getProperty("org.eclipse.team.ui.synchronizationContext");
    }

    protected void registerHandler(String actionId, IHandler handler) {
        this.handlers.put(actionId, handler);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (menu instanceof CommonMenuManager) {
            CommonMenuManager manager = (CommonMenuManager)menu;
            Iterator iter = this.handlers.keySet().iterator();
            while (iter.hasNext()) {
                String actionId = (String)iter.next();
                manager.registerHandler(actionId, (IHandler)this.handlers.get(actionId));
            }
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
    }

    public void dispose() {
        Iterator iter = this.handlers.values().iterator();
        while (iter.hasNext()) {
            IHandler handler = (IHandler)iter.next();
            if (!(handler instanceof MergeActionHandler)) continue;
            MergeActionHandler mah = (MergeActionHandler)handler;
            mah.dispose();
        }
        super.dispose();
    }
}

