/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DragUnderEffect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

class TableDragUnderEffect
extends DragUnderEffect {
    private Table table;
    private int scrollIndex = -1;
    private long scrollBeginTime;
    private static final int SCROLL_HYSTERESIS = 150;

    TableDragUnderEffect(Table table) {
        this.table = table;
    }

    private int checkEffect(int effect) {
        if ((effect & 1) != 0) {
            effect = effect & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((effect & 2) != 0) {
            effect &= 0xFFFFFFFB;
        }
        return effect;
    }

    Widget getItem(int x, int y) {
        Rectangle area;
        Point coordinates = new Point(x, y);
        TableItem item = this.table.getItem(coordinates = this.table.toControl(coordinates));
        if (item == null && (area = this.table.getClientArea()).contains(coordinates)) {
            int x1 = area.x;
            while (x1 < area.x + area.width) {
                Point pt = new Point(x1, coordinates.y);
                item = this.table.getItem(pt);
                if (item != null) break;
                ++x1;
            }
        }
        return item;
    }

    void show(int effect, int x, int y) {
        int indices;
        effect = this.checkEffect(effect);
        int handle = this.table.handle;
        Point coordinates = new Point(x, y);
        coordinates = this.table.toControl(coordinates);
        int[] path = new int[1];
        int clientX = coordinates.x - this.table.getBorderWidth();
        int clientY = coordinates.y - this.table.getHeaderHeight();
        OS.gtk_tree_view_get_path_at_pos(handle, clientX, clientY, path, null, null, null);
        int index = -1;
        if (path[0] != 0 && (indices = OS.gtk_tree_path_get_indices(path[0])) != 0) {
            int[] temp = new int[1];
            OS.memmove(temp, indices, 4);
            index = temp[0];
        }
        if ((effect & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollIndex = -1;
        } else if (index != -1 && this.scrollIndex == index && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                if (clientY < this.table.getItemHeight()) {
                    OS.gtk_tree_path_prev(path[0]);
                } else {
                    OS.gtk_tree_path_next(path[0]);
                }
                if (path[0] != 0) {
                    OS.gtk_tree_view_scroll_to_cell(handle, path[0], 0, false, 0.0f, 0.0f);
                    OS.gtk_tree_path_free(path[0]);
                    path[0] = 0;
                    OS.gtk_tree_view_get_path_at_pos(handle, clientX, clientY, path, null, null, null);
                }
                this.scrollBeginTime = 0L;
                this.scrollIndex = -1;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 150L;
            this.scrollIndex = index;
        }
        if (path[0] != 0) {
            int position = 0;
            if ((effect & 1) != 0) {
                position = 2;
            }
            if (position != 0) {
                OS.gtk_tree_view_set_drag_dest_row(handle, path[0], 2);
            } else {
                OS.gtk_tree_view_unset_rows_drag_dest(handle);
            }
        } else {
            OS.gtk_tree_view_unset_rows_drag_dest(handle);
        }
        if (path[0] != 0) {
            OS.gtk_tree_path_free(path[0]);
        }
    }
}

