/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DragUnderEffect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

class TreeDragUnderEffect
extends DragUnderEffect {
    private Tree tree;
    private int scrollIndex = -1;
    private long scrollBeginTime;
    private int expandIndex = -1;
    private long expandBeginTime;
    private static final int SCROLL_HYSTERESIS = 150;
    private static final int EXPAND_HYSTERESIS = 300;

    TreeDragUnderEffect(Tree tree) {
        this.tree = tree;
    }

    private int checkEffect(int effect) {
        if ((effect & 1) != 0) {
            effect = effect & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((effect & 2) != 0) {
            effect &= 0xFFFFFFFB;
        }
        return effect;
    }

    Widget getItem(int x, int y) {
        Rectangle area;
        Point coordinates = new Point(x, y);
        TreeItem item = this.tree.getItem(coordinates = this.tree.toControl(coordinates));
        if (item == null && (area = this.tree.getClientArea()).contains(coordinates)) {
            int x1 = area.x;
            while (x1 < area.x + area.width) {
                Point pt = new Point(x1, coordinates.y);
                item = this.tree.getItem(pt);
                if (item != null) break;
                ++x1;
            }
        }
        return item;
    }

    void show(int effect, int x, int y) {
        int indices;
        effect = this.checkEffect(effect);
        int handle = this.tree.handle;
        Point coordinates = new Point(x, y);
        coordinates = this.tree.toControl(coordinates);
        int[] path = new int[1];
        int clientX = coordinates.x - this.tree.getBorderWidth();
        int clientY = coordinates.y - this.tree.getHeaderHeight();
        OS.gtk_tree_view_get_path_at_pos(handle, clientX, clientY, path, null, null, null);
        int index = -1;
        if (path[0] != 0 && (indices = OS.gtk_tree_path_get_indices(path[0])) != 0) {
            int depth = OS.gtk_tree_path_get_depth(path[0]);
            int[] temp = new int[depth];
            OS.memmove(temp, indices, temp.length * 4);
            index = temp[temp.length - 1];
        }
        if ((effect & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollIndex = -1;
        } else if (index != -1 && this.scrollIndex == index && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                GdkRectangle cellRect = new GdkRectangle();
                OS.gtk_tree_view_get_cell_area(handle, path[0], 0, cellRect);
                if (cellRect.y < cellRect.height) {
                    int[] tx = new int[1];
                    int[] ty = new int[1];
                    OS.gtk_tree_view_widget_to_tree_coords(handle, cellRect.x, cellRect.y - cellRect.height, tx, ty);
                    OS.gtk_tree_view_scroll_to_point(handle, -1, ty[0]);
                } else {
                    OS.gtk_tree_view_get_path_at_pos(handle, clientX, clientY + cellRect.height, path, null, null, null);
                    if (path[0] != 0) {
                        OS.gtk_tree_view_scroll_to_cell(handle, path[0], 0, false, 0.0f, 0.0f);
                        OS.gtk_tree_path_free(path[0]);
                        path[0] = 0;
                    }
                    OS.gtk_tree_view_get_path_at_pos(handle, clientX, clientY, path, null, null, null);
                }
                this.scrollBeginTime = 0L;
                this.scrollIndex = -1;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 150L;
            this.scrollIndex = index;
        }
        if ((effect & 0x10) == 0) {
            this.expandBeginTime = 0L;
            this.expandIndex = -1;
        } else if (index != -1 && this.expandIndex == index && this.expandBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.expandBeginTime) {
                OS.gtk_tree_view_expand_row(handle, path[0], false);
                this.expandBeginTime = 0L;
                this.expandIndex = -1;
            }
        } else {
            this.expandBeginTime = System.currentTimeMillis() + 300L;
            this.expandIndex = index;
        }
        if (path[0] != 0) {
            int position = -1;
            if ((effect & 1) != 0) {
                position = 2;
            }
            if ((effect & 2) != 0) {
                position = 0;
            }
            if ((effect & 4) != 0) {
                position = 1;
            }
            if (position != -1) {
                OS.gtk_tree_view_set_drag_dest_row(handle, path[0], position);
            } else {
                OS.gtk_tree_view_unset_rows_drag_dest(handle);
            }
        } else {
            OS.gtk_tree_view_unset_rows_drag_dest(handle);
        }
        if (path[0] != 0) {
            OS.gtk_tree_path_free(path[0]);
        }
    }
}

