/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.Item;

public class ExpandItem
extends Item {
    ExpandBar parent;
    Control control;
    ImageList imageList;
    int clientHandle;
    int boxHandle;
    int labelHandle;
    int imageHandle;

    public ExpandItem(ExpandBar parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget(parent.getItemCount());
    }

    public ExpandItem(ExpandBar parent, int style, int index) {
        super(parent, style);
        this.parent = parent;
        int count = parent.getItemCount();
        if (index < 0 || index > count) {
            this.error(14);
        }
        this.createWidget(index);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandle(int index) {
        this.state |= 8;
        this.handle = OS.gtk_expander_new(null);
        if (this.handle == 0) {
            this.error(2);
        }
        this.clientHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.clientHandle == 0) {
            this.error(2);
        }
        OS.gtk_container_add(this.handle, this.clientHandle);
        this.boxHandle = OS.gtk_hbox_new(false, 4);
        if (this.boxHandle == 0) {
            this.error(2);
        }
        this.labelHandle = OS.gtk_label_new(null);
        if (this.labelHandle == 0) {
            this.error(2);
        }
        this.imageHandle = OS.gtk_image_new();
        if (this.imageHandle == 0) {
            this.error(2);
        }
        OS.gtk_container_add(this.boxHandle, this.imageHandle);
        OS.gtk_container_add(this.boxHandle, this.labelHandle);
        OS.gtk_expander_set_label_widget(this.handle, this.boxHandle);
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.showWidget(index);
        this.parent.relayout();
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.clientHandle);
        this.display.removeWidget(this.boxHandle);
        this.display.removeWidget(this.labelHandle);
        this.display.removeWidget(this.imageHandle);
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        ExpandBar parent = this.parent;
        super.dispose();
        parent.relayout();
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public boolean getExpanded() {
        this.checkWidget();
        return OS.gtk_expander_get_expanded(this.handle);
    }

    public int getHeight() {
        this.checkWidget();
        GtkRequisition requisition = new GtkRequisition();
        OS.gtk_widget_size_request(this.clientHandle, requisition);
        return requisition.height;
    }

    public ExpandBar getParent() {
        this.checkWidget();
        if (this.parent == null) {
            this.error(24);
        }
        return this.parent;
    }

    int gtk_activate(int widget) {
        Event event = new Event();
        event.item = this;
        int type = OS.gtk_expander_get_expanded(this.handle) ? 17 : 18;
        this.parent.sendEvent(type, event);
        return 0;
    }

    int gtk_size_allocate(int widget, int allocation) {
        this.parent.relayout();
        return 0;
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.activate, this.display.closures[1], false);
        OS.g_signal_connect_closure(this.handle, OS.activate, this.display.closures[59], true);
        OS.g_signal_connect_closure(this.clientHandle, OS.size_allocate, this.display.closures[46], true);
    }

    void register() {
        super.register();
        this.display.addWidget(this.clientHandle, this);
        this.display.addWidget(this.boxHandle, this);
        this.display.addWidget(this.labelHandle, this);
        this.display.addWidget(this.imageHandle, this);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.imageHandle = 0;
        this.labelHandle = 0;
        this.boxHandle = 0;
        this.clientHandle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        this.parent = null;
        this.control = null;
    }

    void resizeControl(int yScroll) {
        if (this.control != null && !this.control.isDisposed()) {
            boolean visible = OS.gtk_expander_get_expanded(this.handle);
            if (visible) {
                int x = OS.GTK_WIDGET_X(this.clientHandle);
                int y = OS.GTK_WIDGET_Y(this.clientHandle);
                if (x != -1 && y != -1) {
                    int width = OS.GTK_WIDGET_WIDTH(this.clientHandle);
                    int height = OS.GTK_WIDGET_HEIGHT(this.clientHandle);
                    this.control.setBounds(x, y - yScroll, width, height, true, true);
                }
            }
            this.control.setVisible(visible);
        }
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if (this.control == control) {
            return;
        }
        this.control = control;
        if (control != null) {
            control.setVisible(OS.gtk_expander_get_expanded(this.handle));
        }
        this.parent.relayout();
    }

    public void setExpanded(boolean expanded) {
        this.checkWidget();
        OS.gtk_expander_set_expanded(this.handle, expanded);
        this.parent.relayout();
    }

    public void setImage(Image image) {
        super.setImage(image);
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            this.imageList = new ImageList();
            int imageIndex = this.imageList.add(image);
            int pixbuf = this.imageList.getPixbuf(imageIndex);
            OS.gtk_image_set_from_pixbuf(this.imageHandle, pixbuf);
            if (this.text.length() == 0) {
                OS.gtk_widget_hide(this.labelHandle);
            }
            OS.gtk_widget_show(this.imageHandle);
        } else {
            OS.gtk_image_set_from_pixbuf(this.imageHandle, 0);
            OS.gtk_widget_show(this.labelHandle);
            OS.gtk_widget_hide(this.imageHandle);
        }
    }

    public void setHeight(int height) {
        this.checkWidget();
        if (height < 0) {
            return;
        }
        OS.gtk_widget_set_size_request(this.clientHandle, -1, height);
        this.parent.relayout();
    }

    public void setText(String string) {
        super.setText(string);
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        OS.gtk_label_set_text(this.labelHandle, buffer);
    }

    void showWidget(int index) {
        OS.gtk_widget_show(this.handle);
        OS.gtk_widget_show(this.clientHandle);
        OS.gtk_container_add(this.parent.handle, this.handle);
        OS.gtk_box_set_child_packing(this.parent.handle, this.handle, false, false, 0, 0);
        if (this.boxHandle != 0) {
            OS.gtk_widget_show(this.boxHandle);
        }
        if (this.labelHandle != 0) {
            OS.gtk_widget_show(this.labelHandle);
        }
    }

    int windowProc(int handle, int user_data) {
        switch (user_data) {
            case 59: {
                this.parent.relayout();
                return 0;
            }
        }
        return super.windowProc(handle, user_data);
    }
}

