/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.eclipse.pde.internal.build.IXMLConstants;
import org.eclipse.swt.tools.internal.IconExe;

public class BrandingIron
implements IXMLConstants {
    private String[] icons = null;
    private String root;
    private String name;
    private String os = "win32";
    private boolean brandIcons = true;

    public void setName(String value) {
        this.name = value;
    }

    public void setIcons(String value) {
        this.icons = value.split(", ");
    }

    public void setRoot(String value) {
        this.root = value;
    }

    public void brand() throws Exception {
        String testName;
        if (this.name.startsWith("${")) {
            return;
        }
        String string = testName = this.os.equals("win32") ? String.valueOf(this.name) + ".exe" : this.name;
        if (!new File(this.root).exists() || new File(this.root, testName).exists()) {
            return;
        }
        if (this.icons == null || this.icons[0].startsWith("${")) {
            this.brandIcons = false;
        }
        if ("win32".equals(this.os)) {
            this.brandWindows();
        }
        if ("linux".equals(this.os)) {
            this.brandLinux();
        }
        if ("solaris".equals(this.os)) {
            this.brandSolaris();
        }
        if ("macosx".equals(this.os)) {
            this.brandMac();
        }
        if ("aix".equals(this.os)) {
            this.brandAIX();
        }
        if ("hpux".equals(this.os)) {
            this.brandHPUX();
        }
    }

    private void brandAIX() {
        this.renameLauncher();
    }

    private void brandHPUX() {
        this.renameLauncher();
    }

    private void brandLinux() throws Exception {
        this.renameLauncher();
        if (this.brandIcons) {
            this.copy(new File(this.icons[0]), new File(this.root, "icon.xpm"));
        }
    }

    private void brandSolaris() throws Exception {
        this.renameLauncher();
        if (!this.brandIcons) {
            return;
        }
        int i = 0;
        while (i < this.icons.length) {
            String icon = this.icons[i];
            if (icon.endsWith(".l.pm")) {
                this.copy(new File(icon), new File(this.root, String.valueOf(this.name) + ".l.pm"));
            }
            if (icon.endsWith(".m.pm")) {
                this.copy(new File(icon), new File(this.root, String.valueOf(this.name) + ".m.pm"));
            }
            if (icon.endsWith(".s.pm")) {
                this.copy(new File(icon), new File(this.root, String.valueOf(this.name) + ".s.pm"));
            }
            if (icon.endsWith(".t.pm")) {
                this.copy(new File(icon), new File(this.root, String.valueOf(this.name) + ".t.pm"));
            }
            ++i;
        }
    }

    private void brandMac() throws Exception {
        String target = String.valueOf(this.root) + '/' + this.name + ".app/Contents";
        new File(target).mkdirs();
        new File(String.valueOf(target) + "/MacOS").mkdirs();
        new File(String.valueOf(target) + "/Resources").mkdirs();
        String initialRoot = String.valueOf(this.root) + "/Launcher.app/Contents";
        if (!new File(initialRoot).exists()) {
            initialRoot = String.valueOf(this.root) + "/Eclipse.app/Contents";
        }
        this.copyMacLauncher(initialRoot, target);
        String iconName = "";
        if (this.brandIcons) {
            File icon = new File(this.icons[0]);
            iconName = icon.getName();
            this.copy(icon, new File(String.valueOf(target) + "/Resources/" + icon.getName()));
            new File(String.valueOf(initialRoot) + "/Resources/Eclipse.icns").delete();
            new File(String.valueOf(initialRoot) + "/Resources/").delete();
        }
        this.modifyInfoPListFile(initialRoot, target, iconName);
        File rootFolder = new File(initialRoot);
        rootFolder.delete();
        rootFolder.getParentFile().delete();
    }

    private void brandWindows() throws Exception {
        File templateLauncher = new File(this.root, "launcher.exe");
        if (!templateLauncher.exists()) {
            templateLauncher = new File(this.root, "eclipse.exe");
        }
        if (this.brandIcons) {
            String[] args = new String[this.icons.length + 1];
            args[0] = templateLauncher.getAbsolutePath();
            System.arraycopy(this.icons, 0, args, 1, this.icons.length);
            IconExe.main(args);
        }
        templateLauncher.renameTo(new File(this.root, String.valueOf(this.name) + ".exe"));
    }

    private void renameLauncher() {
        if (!new File(this.root, "launcher").renameTo(new File(this.root, this.name))) {
            new File(this.root, "eclipse").renameTo(new File(this.root, this.name));
        }
    }

    private void copyMacLauncher(String initialRoot, String target) {
        String targetLauncher = String.valueOf(target) + "/MacOS/";
        File launcher = new File(String.valueOf(initialRoot) + "/MacOS/launcher");
        if (!launcher.exists()) {
            launcher = new File(String.valueOf(initialRoot) + "/MacOS/eclipse");
        }
        File targetFile = new File(targetLauncher, this.name);
        try {
            if (targetFile.getCanonicalFile().equals(launcher.getCanonicalFile())) {
                try {
                    Runtime.getRuntime().exec("chmod 755 " + targetFile.getAbsolutePath());
                }
                catch (IOException iOException) {}
                return;
            }
            this.copy(launcher, targetFile);
        }
        catch (IOException iOException) {
            System.out.println("Could not copy macosx launcher");
            return;
        }
        try {
            Runtime.getRuntime().exec("chmod 755 " + targetFile.getAbsolutePath());
        }
        catch (IOException iOException) {}
        launcher.delete();
        launcher.getParentFile().delete();
    }

    private void modifyInfoPListFile(String initialRoot, String targetRoot, String iconName) {
        int iconPos;
        int bundlePos;
        StringBuffer buffer;
        File infoPList = new File(initialRoot, "Info.plist");
        try {
            buffer = this.readFile(infoPList);
        }
        catch (IOException iOException) {
            System.out.println("Impossible to brand info.plist file");
            return;
        }
        int exePos = this.scan(buffer, 0, "%EXECUTABLE_NAME%");
        if (exePos != -1) {
            buffer.replace(exePos, exePos + "%EXECUTABLE_NAME%".length(), this.name);
        }
        if ((bundlePos = this.scan(buffer, 0, "%BUNDLE_NAME%")) != -1) {
            buffer.replace(bundlePos, bundlePos + "%BUNDLE_NAME%".length(), this.name);
        }
        if ((iconPos = this.scan(buffer, 0, "%ICON_NAME%")) != -1) {
            buffer.replace(iconPos, iconPos + "%ICON_NAME%".length(), iconName);
        }
        File target = null;
        try {
            target = new File(targetRoot, "Info.plist");
            this.transferStreams(new ByteArrayInputStream(buffer.toString().getBytes()), new FileOutputStream(target));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Impossible to brand info.plist file");
            return;
        }
        catch (IOException iOException) {
            System.out.println("Impossible to brand info.plist file");
            return;
        }
        try {
            if (!infoPList.getCanonicalFile().equals(target.getCanonicalFile())) {
                infoPList.delete();
            }
        }
        catch (IOException iOException) {}
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public void copy(File source, File destination) throws IOException {
        in = null;
        out = null;
        try {
            in = new FileInputStream(source);
            out = new FileOutputStream(destination);
            buffer = new byte[8192];
            while (true) {
                bytesRead = -1;
                bytesRead = in.read(buffer);
                if (bytesRead == -1) break;
                out.write(buffer, 0, bytesRead);
            }
            var7_9 = null;
        }
        catch (Throwable var8_7) {
            var7_8 = null;
            try {
                if (in != null) {
                    in.close();
                }
                v0 = null;
            }
            catch (Throwable var10_10) {
                v0 = null;
            }
            var9_12 = v0;
            if (out == null) throw var8_7;
            out.close();
            throw var8_7;
        }
        try {}
        catch (Throwable var10_11) {
            v1 = null;
lbl33:
            // 2 sources

            var9_13 = v1;
            if (out == null) return;
            out.close();
            return;
        }
        if (in != null) {
            in.close();
        }
        v1 = null;
        ** GOTO lbl33
    }

    private int scan(StringBuffer buf, int start, String targetName) {
        return this.scan(buf, start, new String[]{targetName});
    }

    private int scan(StringBuffer buf, int start, String[] targets) {
        int i = start;
        while (i < buf.length()) {
            int j = 0;
            while (j < targets.length) {
                String match;
                if (i < buf.length() - targets[j].length() && targets[j].equalsIgnoreCase(match = buf.substring(i, i + targets[j].length()))) {
                    return i;
                }
                ++j;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StringBuffer readFile(File targetName) throws IOException {
        InputStreamReader reader = new InputStreamReader(new BufferedInputStream(new FileInputStream(targetName)));
        StringBuffer result = new StringBuffer();
        char[] buf = new char[4096];
        try {
            int count = reader.read(buf, 0, buf.length);
            while (count != -1) {
                result.append(buf, 0, count);
                count = reader.read(buf, 0, buf.length);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (IOException iOException) {
            return result;
        }
        reader.close();
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void transferStreams(InputStream source, OutputStream destination) throws IOException {
        source = new BufferedInputStream(source);
        destination = new BufferedOutputStream(destination);
        try {
            byte[] buffer = new byte[8192];
            while (true) {
                int bytesRead = -1;
                bytesRead = source.read(buffer);
                if (bytesRead != -1) {
                    destination.write(buffer, 0, bytesRead);
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                source.close();
            }
            catch (IOException iOException) {}
            try {
                destination.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        try {}
        catch (IOException iOException) {}
        source.close();
        try {}
        catch (IOException iOException) {
            return;
        }
        destination.close();
    }

    public void setOS(String value) {
        this.os = value;
    }
}

