/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.site;

import java.util.Calendar;
import java.util.Properties;
import org.eclipse.pde.internal.build.IBuildPropertiesConstants;

public class QualifierReplacer
implements IBuildPropertiesConstants {
    private static final String DOT_QUALIFIER = ".qualifier";
    private static String globalQualifier = null;

    public static String replaceQualifierInVersion(String version, String id, String replaceTag, Properties newVersions) {
        if (!version.endsWith(DOT_QUALIFIER)) {
            return version;
        }
        String newQualifier = null;
        if (replaceTag == null || replaceTag.equalsIgnoreCase("context")) {
            if (globalQualifier != null) {
                newQualifier = globalQualifier;
            }
            if (newQualifier == null && newVersions != null && newVersions.size() != 0 && (newQualifier = (String)newVersions.get(id)) == null) {
                newQualifier = newVersions.getProperty("*");
            }
            if (newQualifier == null) {
                newQualifier = QualifierReplacer.getDate();
            }
            newQualifier = String.valueOf('.') + newQualifier;
        } else {
            newQualifier = replaceTag.equalsIgnoreCase("none") ? "" : String.valueOf('.') + replaceTag;
        }
        return version.replaceFirst(DOT_QUALIFIER, newQualifier);
    }

    private static String getDate() {
        int monthNbr = Calendar.getInstance().get(2) + 1;
        String month = String.valueOf(monthNbr < 10 ? "0" : "") + monthNbr;
        int dayNbr = Calendar.getInstance().get(5);
        String day = String.valueOf(dayNbr < 10 ? "0" : "") + dayNbr;
        int hourNbr = Calendar.getInstance().get(11);
        String hour = String.valueOf(hourNbr < 10 ? "0" : "") + hourNbr;
        int minuteNbr = Calendar.getInstance().get(12);
        String minute = String.valueOf(minuteNbr < 10 ? "0" : "") + minuteNbr;
        return Calendar.getInstance().get(1) + month + day + hour + minute;
    }

    public static void setGlobalQualifier(String globalQualifier) {
        if (globalQualifier.length() > 0 && globalQualifier.charAt(0) != '$') {
            QualifierReplacer.globalQualifier = globalQualifier;
        }
    }
}

