/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.filesystem.local;

import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;

public class LocalFileSystem
extends FileSystem {
    private static final boolean caseSensitive = "macosx".equals(Platform.getOS()) ? false : new File("a").compareTo(new File("A")) != 0;
    private static IFileSystem instance;

    public static IFileSystem getInstance() {
        return instance;
    }

    public LocalFileSystem() {
        instance = this;
    }

    public int attributes() {
        int attributes = 2;
        String os = Platform.getOS().intern();
        if (os == "win32") {
            attributes |= 0x18;
        } else if (os == "linux" || os == "macosx") {
            attributes |= 4;
        }
        return attributes;
    }

    public boolean canDelete() {
        return true;
    }

    public boolean canWrite() {
        return true;
    }

    public IFileStore getStore(IPath path) {
        return new LocalFile(path.toFile());
    }

    public IFileStore getStore(URI uri) {
        return new LocalFile(new File(uri.getSchemeSpecificPart()));
    }

    public boolean isCaseSensitive() {
        return caseSensitive;
    }
}

