/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core.mapping.provider;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IDiffVisitor;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.diff.ITwoWayDiff;
import org.eclipse.team.core.diff.provider.DiffTree;
import org.eclipse.team.core.mapping.IResourceDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.internal.core.TeamPlugin;

public class ResourceDiffTree
extends DiffTree
implements IResourceDiffTree {
    public static IResource getResourceFor(IDiff node) {
        if (node instanceof IResourceDiff) {
            IResourceDiff rd = (IResourceDiff)node;
            return rd.getResource();
        }
        if (node instanceof IThreeWayDiff) {
            IThreeWayDiff twd = (IThreeWayDiff)node;
            ITwoWayDiff child = twd.getLocalChange();
            if (child != null) {
                return ResourceDiffTree.getResourceFor(child);
            }
            child = twd.getRemoteChange();
            if (child != null) {
                return ResourceDiffTree.getResourceFor(child);
            }
        }
        Assert.isLegal((boolean)false);
        return null;
    }

    public IDiff getDiff(IResource resource) {
        return this.getDiff(resource.getFullPath());
    }

    public IResource getResource(IDiff diff) {
        if (diff instanceof IThreeWayDiff) {
            IThreeWayDiff twd = (IThreeWayDiff)diff;
            IResourceDiff localChange = (IResourceDiff)twd.getLocalChange();
            if (localChange != null) {
                return localChange.getResource();
            }
            return ((IResourceDiff)twd.getRemoteChange()).getResource();
        }
        return ((IResourceDiff)diff).getResource();
    }

    public void accept(IDiffVisitor visitor, ResourceTraversal[] traversals) throws CoreException {
        IDiff[] diffs = this.getDiffs(traversals);
        int i = 0;
        while (i < diffs.length) {
            IDiff node = diffs[i];
            visitor.visit(node);
            ++i;
        }
    }

    public IDiff[] getDiffs(final ResourceTraversal[] traversals) {
        final HashSet result = new HashSet();
        try {
            this.accept(ResourcesPlugin.getWorkspace().getRoot().getFullPath(), new IDiffVisitor(){

                public boolean visit(IDiff delta) throws CoreException {
                    int i = 0;
                    while (i < traversals.length) {
                        ResourceTraversal traversal = traversals[i];
                        if (traversal.contains(ResourceDiffTree.this.getResource(delta))) {
                            result.add(delta);
                        }
                        ++i;
                    }
                    return true;
                }
            }, 2);
        }
        catch (CoreException e) {
            TeamPlugin.log(e);
        }
        return result.toArray(new IDiff[result.size()]);
    }

    public IDiff[] getDiffs(IResource resource, int depth) {
        return this.getDiffs(new ResourceTraversal[]{new ResourceTraversal(new IResource[]{resource}, depth, 0)});
    }

    private IResource internalGetResource(IPath fullPath, boolean container) {
        if (container) {
            return ResourcesPlugin.getWorkspace().getRoot().getFolder(fullPath);
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile(fullPath);
    }

    public IResource[] members(IResource resource) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        IPath[] paths = this.getChildren(resource.getFullPath());
        int i = 0;
        while (i < paths.length) {
            IPath path = paths[i];
            IDiff node = this.getDiff(path);
            if (node == null) {
                result.add(this.internalGetResource(path, true));
            } else {
                result.add(this.getResource(node));
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public IResource[] getAffectedResources() {
        ArrayList<IResource> result = new ArrayList<IResource>();
        IDiff[] nodes = this.getDiffs();
        int i = 0;
        while (i < nodes.length) {
            IDiff node = nodes[i];
            result.add(this.getResource(node));
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public void add(IDiff delta) {
        Assert.isTrue((delta instanceof IResourceDiff || delta instanceof IThreeWayDiff ? 1 : 0) != 0);
        super.add(delta);
    }

    public void remove(IResource resource) {
        this.remove(resource.getFullPath());
    }
}

