/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.ITeamStatus;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.diff.ITwoWayDiff;
import org.eclipse.team.core.diff.provider.ThreeWayDiff;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileRevision;
import org.eclipse.team.core.mapping.IResourceDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.provider.ResourceDiff;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeEvent;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeListener;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.core.synchronize.SyncInfoTree;
import org.eclipse.team.core.variants.IResourceVariant;

public class SyncInfoToDiffConverter
implements ISyncInfoSetChangeListener {
    SyncInfoSet set;
    ResourceDiffTree tree;
    List errors = new ArrayList();

    public SyncInfoToDiffConverter(SyncInfoTree set, ResourceDiffTree tree) {
        this.set = set;
        this.tree = tree;
    }

    public void connect(IProgressMonitor monitor) {
        this.set.connect(this, monitor);
    }

    public void dispose() {
        this.set.removeSyncSetChangedListener(this);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void syncInfoSetReset(SyncInfoSet set, IProgressMonitor monitor) {
        try {
            this.tree.beginInput();
            this.tree.clear();
            SyncInfo[] infos = set.getSyncInfos();
            int i = 0;
            while (i < infos.length) {
                SyncInfo info = infos[i];
                IDiff delta = SyncInfoToDiffConverter.getDeltaFor(info);
                this.tree.add(delta);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.tree.endInput(monitor);
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        this.tree.endInput(monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void syncInfoChanged(ISyncInfoSetChangeEvent event, IProgressMonitor monitor) {
        try {
            int i;
            IResource[] removed;
            this.tree.beginInput();
            SyncInfo[] added = event.getAddedResources();
            int i2 = 0;
            while (true) {
                if (i2 >= added.length) break;
                SyncInfo info = added[i2];
                IDiff delta = SyncInfoToDiffConverter.getDeltaFor(info);
                this.tree.add(delta);
                ++i2;
            }
            SyncInfo[] changed = event.getChangedResources();
            int i3 = 0;
            while (true) {
                if (i3 >= changed.length) {
                    removed = event.getRemovedResources();
                    i = 0;
                    break;
                }
                SyncInfo info = changed[i3];
                IDiff delta = SyncInfoToDiffConverter.getDeltaFor(info);
                this.tree.add(delta);
                ++i3;
            }
            while (i < removed.length) {
                IResource resource = removed[i];
                this.tree.remove(resource.getFullPath());
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            this.tree.endInput(monitor);
            throw throwable;
        }
        {
            Object var8_14 = null;
        }
        this.tree.endInput(monitor);
    }

    public static int asDiffFlags(int syncInfoFlags) {
        if (syncInfoFlags == 0) {
            return 0;
        }
        int kind = SyncInfo.getChange(syncInfoFlags);
        int diffFlags = 0;
        switch (kind) {
            case 1: {
                diffFlags = 1;
                break;
            }
            case 2: {
                diffFlags = 2;
                break;
            }
            case 3: {
                diffFlags = 4;
            }
        }
        int direction = SyncInfo.getDirection(syncInfoFlags);
        switch (direction) {
            case 8: {
                diffFlags |= 0x200;
                break;
            }
            case 4: {
                diffFlags |= 0x100;
                break;
            }
            case 12: {
                diffFlags |= 0x300;
            }
        }
        return diffFlags;
    }

    public static IDiff getDeltaFor(SyncInfo info) {
        if (info.getComparator().isThreeWay()) {
            ITwoWayDiff local = SyncInfoToDiffConverter.getLocalDelta(info);
            ITwoWayDiff remote = SyncInfoToDiffConverter.getRemoteDelta(info);
            return new ThreeWayDiff(local, remote);
        }
        if (info.getKind() != 0) {
            IResourceVariant remote = info.getRemote();
            IResource local = info.getLocal();
            int kind = remote == null ? 2 : (!local.exists() ? 1 : 4);
            if (local.getType() == 1) {
                IFileRevision after = SyncInfoToDiffConverter.asFileState(remote);
                IFileRevision before = FileRevision.getFileRevisionFor((IFile)local);
                return new ResourceDiff(info.getLocal(), kind, 0, before, after);
            }
            return new ResourceDiff(info.getLocal(), kind);
        }
        return null;
    }

    private static ITwoWayDiff getRemoteDelta(SyncInfo info) {
        int direction = SyncInfo.getDirection(info.getKind());
        if (direction == 8 || direction == 12) {
            IResourceVariant ancestor = info.getBase();
            IResourceVariant remote = info.getRemote();
            int kind = ancestor == null ? 1 : (remote == null ? 2 : 4);
            if (info.getLocal().getType() == 1) {
                IFileRevision before = SyncInfoToDiffConverter.asFileState(ancestor);
                IFileRevision after = SyncInfoToDiffConverter.asFileState(remote);
                return new ResourceDiff(info.getLocal(), kind, 0, before, after);
            }
            return new ResourceDiff(info.getLocal(), kind);
        }
        return null;
    }

    private static IFileRevision asFileState(IResourceVariant variant) {
        if (variant == null) {
            return null;
        }
        return new ResourceVariantFileRevision(variant);
    }

    private static ITwoWayDiff getLocalDelta(SyncInfo info) {
        int direction = SyncInfo.getDirection(info.getKind());
        if (direction == 4 || direction == 12) {
            IResourceVariant ancestor = info.getBase();
            IResource local = info.getLocal();
            int kind = ancestor == null ? 1 : (!local.exists() ? 2 : 4);
            if (local.getType() == 1) {
                IFileRevision before = SyncInfoToDiffConverter.asFileState(ancestor);
                IFileRevision after = FileRevision.getFileRevisionFor((IFile)local);
                return new ResourceDiff(info.getLocal(), kind, 0, before, after);
            }
            return new ResourceDiff(info.getLocal(), kind);
        }
        return null;
    }

    public void syncInfoSetErrors(SyncInfoSet set, ITeamStatus[] errors, IProgressMonitor monitor) {
        this.errors.addAll(Arrays.asList(errors));
    }

    public IResourceDiffTree getTree() {
        return this.tree;
    }

    public static IResourceVariant getRemoteVariant(IThreeWayDiff twd) {
        IResourceDiff diff = (IResourceDiff)twd.getRemoteChange();
        if (diff != null) {
            return ((ResourceVariantFileRevision)diff.getAfterState()).getVariant();
        }
        diff = (IResourceDiff)twd.getLocalChange();
        if (diff != null) {
            return ((ResourceVariantFileRevision)diff.getBeforeState()).getVariant();
        }
        return null;
    }

    public static IResourceVariant getBaseVariant(IThreeWayDiff twd) {
        IResourceDiff diff = (IResourceDiff)twd.getRemoteChange();
        if (diff != null) {
            return ((ResourceVariantFileRevision)diff.getBeforeState()).getVariant();
        }
        diff = (IResourceDiff)twd.getLocalChange();
        if (diff != null) {
            return ((ResourceVariantFileRevision)diff.getBeforeState()).getVariant();
        }
        return null;
    }

    public static final class ResourceVariantFileRevision
    extends FileRevision {
        private final IResourceVariant variant;

        private ResourceVariantFileRevision(IResourceVariant variant) {
            this.variant = variant;
        }

        public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
            return this.variant.getStorage(monitor);
        }

        public String getName() {
            return this.variant.getName();
        }

        public String getContentIdentifier() {
            return this.variant.getContentIdentifier();
        }

        public IResourceVariant getVariant() {
            return this.variant;
        }
    }
}

