/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.model;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.cheatsheets.ICompositeCheatSheetTask;
import org.eclipse.ui.internal.cheatsheets.composite.model.CompositeCheatSheetModel;

public class CheatSheetTask
implements ICompositeCheatSheetTask {
    private CompositeCheatSheetModel model;
    private int state = 0;
    private String id;
    private String name;
    private String kind;
    private Dictionary parameters;
    private String description;
    private String completionMessage;
    private ArrayList subtasks;
    private ArrayList requiredTasks;
    private ArrayList successorTasks;
    private int percentageComplete;
    private static final ICompositeCheatSheetTask[] EMPTY = new ICompositeCheatSheetTask[0];

    public CheatSheetTask(CompositeCheatSheetModel model, String id, String name, String kind, Dictionary parameters, String description) {
        this.model = model;
        this.id = id;
        this.name = name;
        this.kind = kind;
        this.parameters = parameters;
        this.description = description;
        this.requiredTasks = new ArrayList();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getKind() {
        return this.kind;
    }

    public Dictionary getParameters() {
        return this.parameters;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ICompositeCheatSheetTask[] getSubtasks() {
        if (this.subtasks == null) {
            return EMPTY;
        }
        return this.subtasks.toArray(new ICompositeCheatSheetTask[this.subtasks.size()]);
    }

    public ICompositeCheatSheetTask[] getRequiredTasks() {
        if (this.requiredTasks == null) {
            return EMPTY;
        }
        return this.requiredTasks.toArray(new ICompositeCheatSheetTask[this.requiredTasks.size()]);
    }

    public ICompositeCheatSheetTask[] getSuccessorTasks() {
        if (this.successorTasks == null) {
            return EMPTY;
        }
        return this.successorTasks.toArray(new ICompositeCheatSheetTask[this.successorTasks.size()]);
    }

    public int getPercentageComplete() {
        return this.percentageComplete;
    }

    public void addSubtask(ICompositeCheatSheetTask task) {
        if (this.subtasks == null) {
            this.subtasks = new ArrayList();
        }
        this.subtasks.add(task);
    }

    public void addRequiredTask(ICompositeCheatSheetTask task) {
        if (this.requiredTasks == null) {
            this.requiredTasks = new ArrayList();
        }
        this.requiredTasks.add(task);
    }

    public void addSuccessorTask(ICompositeCheatSheetTask task) {
        if (this.successorTasks == null) {
            this.successorTasks = new ArrayList();
        }
        this.successorTasks.add(task);
    }

    public void setPercentageComplete(int percentageComplete) {
        if (percentageComplete >= 0 && percentageComplete <= 100) {
            this.percentageComplete = percentageComplete;
            this.model.notifyStateChanged(this);
        }
    }

    public int getState() {
        return this.state;
    }

    public void advanceState() {
        if (this.state == 0) {
            this.state = 1;
        } else if (this.state == 1) {
            this.completeTask();
        }
        this.model.notifyStateChanged(this);
    }

    private void completeTask() {
        ArrayList<ICompositeCheatSheetTask> blockedTasks = new ArrayList<ICompositeCheatSheetTask>();
        ICompositeCheatSheetTask[] successorTasks = this.getSuccessorTasks();
        int i = 0;
        while (i < successorTasks.length) {
            if (!successorTasks[i].isStartable()) {
                blockedTasks.add(successorTasks[i]);
            }
            ++i;
        }
        this.state = 2;
        Iterator iter = blockedTasks.iterator();
        while (iter.hasNext()) {
            ICompositeCheatSheetTask nextTask = (ICompositeCheatSheetTask)iter.next();
            if (!nextTask.isStartable()) continue;
            this.model.notifyStateChanged(nextTask);
        }
    }

    public void setCompletionMessage(String completionMessage) {
        this.completionMessage = completionMessage;
    }

    public String getCompletionMessage() {
        return this.completionMessage;
    }

    public boolean isStartable() {
        boolean startable = true;
        ICompositeCheatSheetTask[] requiredTasks = this.getRequiredTasks();
        int i = 0;
        while (i < requiredTasks.length) {
            if (requiredTasks[i].getState() != 2) {
                startable = false;
            }
            ++i;
        }
        return startable;
    }

    public void setState(int state) {
        this.state = state;
        this.model.notifyStateChanged(this);
    }

    public IPath getStateLocation() {
        if (this.model != null) {
            IPath statePath = this.model.getStateLocation().append(this.getId());
            File statePathAsFile = statePath.toFile();
            if (!statePathAsFile.exists()) {
                statePathAsFile.mkdirs();
            }
            if (statePathAsFile.exists()) {
                return statePath;
            }
        }
        return null;
    }

    public URL getInputUrl(String path) throws MalformedURLException {
        return new URL(this.model.getContentUrl(), path);
    }

    public CompositeCheatSheetModel getModel() {
        return this.model;
    }
}

