/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.model;

import org.eclipse.ui.cheatsheets.ICompositeCheatSheetTask;
import org.eclipse.ui.internal.cheatsheets.composite.model.CheatSheetTask;

public class SuccesorTaskFinder {
    private CheatSheetTask csTask;
    ICompositeCheatSheetTask bestSuccessor;
    ICompositeCheatSheetTask bestPredecessor;
    private boolean seenThisTask;

    public SuccesorTaskFinder(ICompositeCheatSheetTask task) {
        this.csTask = (CheatSheetTask)task;
    }

    public ICompositeCheatSheetTask[] getRecommendedSuccessors() {
        this.bestSuccessor = null;
        this.bestPredecessor = null;
        this.seenThisTask = false;
        this.searchRunnableChildren(this.csTask.getModel().getRootTask());
        if (this.bestSuccessor != null) {
            return new ICompositeCheatSheetTask[]{this.bestSuccessor};
        }
        if (this.bestPredecessor != null) {
            return new ICompositeCheatSheetTask[]{this.bestPredecessor};
        }
        return new ICompositeCheatSheetTask[0];
    }

    private void searchRunnableChildren(ICompositeCheatSheetTask task) {
        if (this.bestSuccessor != null) {
            return;
        }
        if (task == this.csTask) {
            this.seenThisTask = true;
        }
        if (task.getKind() != null && task.isStartable() && task.getState() != 2) {
            if (this.seenThisTask) {
                if (this.bestSuccessor == null) {
                    this.bestSuccessor = task;
                }
            } else if (this.bestPredecessor == null) {
                this.bestPredecessor = task;
            }
        }
        ICompositeCheatSheetTask[] subtasks = task.getSubtasks();
        int i = 0;
        while (i < subtasks.length) {
            this.searchRunnableChildren(subtasks[i]);
            ++i;
        }
    }
}

