/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.views;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.cheatsheets.ICompositeCheatSheetTask;
import org.eclipse.ui.cheatsheets.ITaskEditor;
import org.eclipse.ui.cheatsheets.ITaskExplorer;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.ScrolledFormText;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.composite.model.CheatSheetTask;
import org.eclipse.ui.internal.cheatsheets.composite.model.CompositeCheatSheetModel;
import org.eclipse.ui.internal.cheatsheets.composite.model.CompositeCheatSheetSaveHelper;
import org.eclipse.ui.internal.cheatsheets.composite.model.SuccesorTaskFinder;
import org.eclipse.ui.internal.cheatsheets.composite.views.TaskEditorManager;
import org.eclipse.ui.internal.cheatsheets.composite.views.TaskExplorerManager;
import org.eclipse.ui.internal.cheatsheets.views.Page;
import org.eclipse.ui.part.PageBook;

public class CompositeCheatSheetPage
extends Page
implements ISelectionChangedListener {
    private static final String TASK = "task";
    private static final String EDITOR = "editor";
    private static final String STARTED = "started";
    private static final String TRUE = "true";
    private static final String REVIEW_TAG = "Review:";
    private static final String NEXT_TASK_TAG = "Next:";
    private ManagedForm mform;
    private PageBook explorerContainer;
    private PageBook taskEditorContainer;
    private CompositeCheatSheetModel model;
    private ITaskExplorer currentExplorer;
    private ScrolledFormText descriptionPanel;
    private ScrolledFormText completePanel;
    private CompositeCheatSheetSaveHelper saveHelper;
    private static final String START_HREF = "__start__";
    private ICompositeCheatSheetTask selectedTask;

    public CompositeCheatSheetPage(CompositeCheatSheetModel model) {
        this.model = model;
        this.saveHelper = new CompositeCheatSheetSaveHelper();
    }

    public void createPart(Composite parent) {
        this.init(parent.getDisplay());
        this.form = this.toolkit.createScrolledForm(parent);
        this.form.setLayoutData((Object)new GridData(1808));
        FormColors colors = this.toolkit.getColors();
        colors.initializeSectionToolBarColors();
        Color gbg = colors.getColor("org.eclipse.ui.forms.TB_GBG");
        Color bg = colors.getBackground();
        this.form.getForm().setTextBackground(new Color[]{bg, gbg}, new int[]{100}, true);
        this.form.getForm().setSeparatorColor(colors.getColor("org.eclipse.ui.forms.TB_BORDER"));
        this.form.getForm().setSeparatorVisible(true);
        this.mform = new ManagedForm(this.toolkit, this.form);
        GridLayout glayout = new GridLayout();
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        this.form.getBody().setLayout((Layout)glayout);
        final SashForm sash = new SashForm(this.form.getBody(), 0);
        GridData gd = new GridData(1808);
        gd.widthHint = 10;
        gd.heightHint = 10;
        sash.setLayoutData((Object)gd);
        sash.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Point size = sash.getSize();
                if (size.x > size.y) {
                    sash.setOrientation(256);
                } else {
                    sash.setOrientation(512);
                }
                CompositeCheatSheetPage.this.updateSashPanelMargins(sash);
            }
        });
        sash.setBackground(colors.getColor("org.eclipse.ui.forms.TB_GBG"));
        Composite explorerPanel = new Composite((Composite)sash, 0);
        explorerPanel.setBackground(colors.getColor("org.eclipse.ui.forms.TB_BORDER"));
        GridLayout playout = new GridLayout();
        playout.marginWidth = 0;
        playout.marginHeight = 0;
        explorerPanel.setLayout((Layout)playout);
        this.explorerContainer = new PageBook(explorerPanel, 0);
        this.explorerContainer.setLayoutData((Object)new GridData(1808));
        Composite editorPanel = new Composite((Composite)sash, 0);
        playout = new GridLayout();
        playout.marginWidth = 0;
        playout.marginHeight = 0;
        editorPanel.setLayout((Layout)playout);
        editorPanel.setBackground(colors.getColor("org.eclipse.ui.forms.TB_BORDER"));
        this.taskEditorContainer = new PageBook(editorPanel, 0);
        this.toolkit.adapt((Composite)this.taskEditorContainer);
        this.taskEditorContainer.setLayoutData((Object)new GridData(1808));
    }

    private void updateSashPanelMargins(SashForm sash) {
        Control[] children = sash.getChildren();
        int orientation = sash.getOrientation();
        GridLayout layout = (GridLayout)((Composite)children[0]).getLayout();
        if (orientation == 256) {
            layout.marginBottom = 0;
            layout.marginRight = 1;
        } else {
            layout.marginBottom = 1;
            layout.marginRight = 0;
        }
        layout = (GridLayout)((Composite)children[1]).getLayout();
        if (orientation == 256) {
            layout.marginTop = 0;
            layout.marginLeft = 1;
        } else {
            layout.marginTop = 1;
            layout.marginLeft = 0;
        }
        ((Composite)children[0]).layout();
        ((Composite)children[1]).layout();
    }

    public void dispose() {
        this.mform.dispose();
        super.dispose();
    }

    private void setInputModel(CompositeCheatSheetModel model) {
        this.model = model;
        this.mform.getForm().setText(model.getName());
        String explorerId = model.getTaskExplorerId();
        ITaskExplorer explorer = this.getTaskExplorer(explorerId);
        if (explorer != null) {
            explorer.setCompositeCheatSheet(model);
            explorer.setFocus();
            this.setExplorerVisible(explorerId);
        }
        model.addObserver(new Observer(){

            public void update(Observable o, Object arg) {
                ICompositeCheatSheetTask task = (ICompositeCheatSheetTask)arg;
                if (CompositeCheatSheetPage.this.currentExplorer != null) {
                    CompositeCheatSheetPage.this.currentExplorer.taskUpdated(task);
                }
                CompositeCheatSheetPage.this.updateTask(task);
            }
        });
    }

    private void setExplorerVisible(String id) {
        Control[] excontrols = this.explorerContainer.getChildren();
        ITaskExplorer explorer = null;
        int i = 0;
        while (i < excontrols.length) {
            Control excontrol = excontrols[i];
            explorer = (ITaskExplorer)excontrol.getData("explorer");
            if (explorer.getId().equals(id)) {
                this.explorerContainer.showPage(excontrol);
                this.setCurrentExplorer(explorer);
                return;
            }
            ++i;
        }
    }

    private void setCurrentExplorer(ITaskExplorer explorer) {
        if (this.currentExplorer != null) {
            this.currentExplorer.getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.currentExplorer = explorer;
        this.currentExplorer.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        this.updateForSelection(this.currentExplorer.getSelectionProvider().getSelection());
    }

    private ITaskExplorer getTaskExplorer(String id) {
        Control[] excontrols = this.explorerContainer.getChildren();
        ITaskExplorer explorer = null;
        int i = 0;
        while (i < excontrols.length) {
            Control excontrol = excontrols[i];
            Object data = excontrol.getData("explorer");
            if (data instanceof ITaskExplorer && (explorer = (ITaskExplorer)data).getId().equals(id)) {
                return explorer;
            }
            ++i;
        }
        TaskExplorerManager explorerManager = TaskExplorerManager.getInstance();
        explorer = explorerManager.getExplorer(id);
        if (explorer != null) {
            explorer.createControl((Composite)this.explorerContainer, this.mform.getToolkit());
            explorer.getControl().setData("explorer", (Object)explorer);
        }
        return explorer;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateForSelection(event.getSelection());
    }

    private void updateForSelection(ISelection selection) {
        this.selectedTask = (ICompositeCheatSheetTask)((IStructuredSelection)selection).getFirstElement();
        this.updateTask(this.selectedTask);
    }

    private void updateTask(ICompositeCheatSheetTask task) {
        if (task == null) {
            return;
        }
        int state = task.getState();
        switch (state) {
            case 0: {
                this.showDescription(task);
                break;
            }
            case 1: {
                this.showTaskEditor(task);
                break;
            }
            case 2: {
                this.showComplete(task);
            }
        }
        this.saveGuideState();
    }

    private void showTaskEditor(ICompositeCheatSheetTask task) {
        this.startIfSelected(task);
        ITaskEditor editor = this.getTaskEditor(task);
        this.setCurrentEditor((Control)editor.getControl().getParent());
    }

    private void saveGuideState() {
        this.saveHelper.saveCompositeState(this.model);
    }

    private void showDescription(ICompositeCheatSheetTask task) {
        FormText text;
        if (this.descriptionPanel == null) {
            this.descriptionPanel = new ScrolledFormText((Composite)this.taskEditorContainer, false);
            this.mform.getToolkit().adapt((Control)this.descriptionPanel, false, false);
            text = this.mform.getToolkit().createFormText((Composite)this.descriptionPanel, true);
            text.marginWidth = 5;
            text.marginHeight = 5;
            text.setFont("header", JFaceResources.getHeaderFont());
            text.setColor("title", this.mform.getToolkit().getColors().getColor("org.eclipse.ui.forms.TITLE"));
            text.setImage("start", CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_START"));
            this.descriptionPanel.setFormText(text);
            text.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    if (e.getHref().equals(CompositeCheatSheetPage.START_HREF)) {
                        ICompositeCheatSheetTask task = (ICompositeCheatSheetTask)CompositeCheatSheetPage.this.descriptionPanel.getData(CompositeCheatSheetPage.TASK);
                        task.advanceState();
                        CompositeCheatSheetPage.this.startIfSelected(task);
                    }
                }
            });
        } else {
            text = this.descriptionPanel.getFormText();
        }
        String desc = task.getDescription().trim();
        StringBuffer buf = new StringBuffer();
        buf.append("<form>");
        buf.append("<p><span color=\"title\" font=\"header\">");
        buf.append(task.getName());
        buf.append("</span></p>");
        if (desc.charAt(0) != '<') {
            buf.append("<p>");
            buf.append(desc);
            buf.append("</p>");
        } else {
            buf.append(desc);
        }
        if (task.getKind() != null) {
            if (task.isStartable()) {
                buf.append("<p/>");
                buf.append("<p><a href=\"");
                buf.append(START_HREF);
                buf.append("\">");
                buf.append("<img href=\"start\"/> ");
                buf.append(Messages.COMPOSITE_PAGE_START_TASK);
                buf.append("</a></p>");
            } else {
                buf.append("<p/>");
                buf.append("<p>");
                buf.append("<b>");
                buf.append(Messages.COMPOSITE_PAGE_BLOCKED);
                buf.append("</b>");
                buf.append("</p>");
                ICompositeCheatSheetTask[] requiredTasks = task.getRequiredTasks();
                int i = 0;
                while (i < requiredTasks.length) {
                    this.addIfIncomplete(buf, requiredTasks[i]);
                    ++i;
                }
                buf.append("<p>");
                buf.append("</p>");
            }
        }
        buf.append("</form>");
        text.setText(buf.toString(), true, false);
        this.descriptionPanel.setData(TASK, (Object)task);
        this.descriptionPanel.reflow(true);
        this.setCurrentEditor((Control)this.descriptionPanel);
    }

    private void addIfIncomplete(StringBuffer buf, ICompositeCheatSheetTask task) {
        if (task.getState() != 2) {
            buf.append("<li>");
            String message = NLS.bind((String)Messages.COMPOSITE_PAGE_TASK_NOT_COMPLETE, (Object[])new Object[]{task.getName()});
            buf.append(message);
            buf.append("</li>");
        }
    }

    private void startIfSelected(ICompositeCheatSheetTask task) {
        ITaskEditor editor;
        if (task == this.selectedTask && (editor = this.getTaskEditor(task)) != null) {
            if (!TRUE.equals(editor.getControl().getData(STARTED))) {
                editor.start(task);
                editor.getControl().setData(STARTED, (Object)TRUE);
            }
            this.setCurrentEditor(editor.getControl());
        }
    }

    private void setCurrentEditor(Control c) {
        this.taskEditorContainer.showPage(c);
    }

    private void showComplete(ICompositeCheatSheetTask task) {
        if (this.completePanel == null) {
            this.completePanel = new ScrolledFormText((Composite)this.taskEditorContainer, false);
            this.mform.getToolkit().adapt((Control)this.completePanel, false, false);
            FormText text = this.mform.getToolkit().createFormText((Composite)this.completePanel, true);
            text.marginWidth = 5;
            text.marginHeight = 5;
            text.setFont("header", JFaceResources.getHeaderFont());
            text.setColor("title", this.mform.getToolkit().getColors().getColor("org.eclipse.ui.forms.TITLE"));
            this.completePanel.setFormText(text);
            text.addHyperlinkListener((IHyperlinkListener)new CompletionHyperlinkAdapter());
        }
        String desc = task.getCompletionMessage().trim();
        StringBuffer buf = new StringBuffer();
        buf.append("<form>");
        buf.append("<p><span color=\"title\" font=\"header\">");
        buf.append(task.getName());
        buf.append("</span></p>");
        if (desc.charAt(0) != '<') {
            buf.append("<p>");
            buf.append(desc);
            buf.append("</p>");
        } else {
            buf.append(desc);
        }
        ICompositeCheatSheetTask[] successorTasks = new SuccesorTaskFinder(task).getRecommendedSuccessors();
        int i = 0;
        while (i < successorTasks.length) {
            this.addSuccessorTask(buf, successorTasks[i]);
            ++i;
        }
        buf.append("<p/>");
        buf.append("<p><a href=\"");
        buf.append(REVIEW_TAG);
        buf.append(task.getId());
        buf.append("\">");
        buf.append(Messages.COMPOSITE_PAGE_REVIEW_TASK);
        String string = "</a></p>";
        buf.append(string);
        buf.append("</form>");
        this.completePanel.setText(buf.toString());
        this.completePanel.reflow(true);
        this.setCurrentEditor((Control)this.completePanel);
    }

    private void addSuccessorTask(StringBuffer buf, ICompositeCheatSheetTask task) {
        buf.append("<p/>");
        buf.append("<p><a href=\"");
        buf.append(NEXT_TASK_TAG);
        buf.append(task.getId());
        buf.append("\">");
        buf.append(NLS.bind((String)Messages.COMPOSITE_PAGE_GOTO_TASK, (Object[])new Object[]{task.getName()}));
        buf.append("</a></p>");
    }

    private ITaskEditor getTaskEditor(ICompositeCheatSheetTask task) {
        Control[] controls = this.taskEditorContainer.getChildren();
        int i = 0;
        while (i < controls.length) {
            ICompositeCheatSheetTask ctask;
            Control control = controls[i];
            if (control != this.descriptionPanel && control != this.completePanel && task == (ctask = (ICompositeCheatSheetTask)control.getData(TASK))) {
                return (ITaskEditor)control.getData(EDITOR);
            }
            ++i;
        }
        ITaskEditor editor = TaskEditorManager.getInstance().getEditor(task.getKind());
        if (editor != null) {
            editor.createControl((Composite)this.taskEditorContainer, this.mform.getToolkit());
            editor.getControl().setData(TASK, (Object)task);
            editor.getControl().setData(EDITOR, (Object)editor);
        }
        return editor;
    }

    public Control getControl() {
        return this.form;
    }

    protected String getTitle() {
        return this.model.getName();
    }

    public void initialized() {
        this.saveHelper.loadCompositeState(this.model, null);
        this.setInputModel(this.model);
        this.model.setSaveHelper(this.saveHelper);
    }

    private final class CompletionHyperlinkAdapter
    extends HyperlinkAdapter {
        CompletionHyperlinkAdapter() {
        }

        public void linkActivated(HyperlinkEvent e) {
            String ref = (String)e.getHref();
            if (ref.startsWith(CompositeCheatSheetPage.REVIEW_TAG)) {
                String review = ref.substring(CompositeCheatSheetPage.REVIEW_TAG.length());
                CheatSheetTask reviewTask = CompositeCheatSheetPage.this.model.getDependencies().getTask(review);
                CompositeCheatSheetPage.this.showTaskEditor(reviewTask);
            }
            if (ref.startsWith(CompositeCheatSheetPage.NEXT_TASK_TAG)) {
                String next = ref.substring(CompositeCheatSheetPage.NEXT_TASK_TAG.length());
                CheatSheetTask nextTask = CompositeCheatSheetPage.this.model.getDependencies().getTask(next);
                CompositeCheatSheetPage.this.currentExplorer.setSelection((ISelection)new StructuredSelection((Object)nextTask), true);
            }
        }
    }
}

