/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.history;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.RefactoringSessionDescriptor;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.eclipse.ltk.internal.core.refactoring.history.DefaultRefactoringDescriptorProxy;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryImplementation;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringSessionReader;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringSessionTransformer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class RefactoringHistoryManager {
    public static final char DELIMITER_COMPONENT = '\t';
    public static final char DELIMITER_ENTRY = '\n';
    private static final TimeZone LOCAL_TIME_ZONE = TimeZone.getTimeZone("GMT+00:00");
    private RefactoringSessionDescriptor fCachedDescriptor = null;
    private Document fCachedDocument = null;
    private IPath fCachedPath = null;
    private IFileStore fCachedStore = null;
    private final IFileStore fHistoryStore;
    private final String fProjectName;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void addIndexEntry(IFileStore file, RefactoringDescriptor descriptor, IProgressMonitor monitor) throws CoreException, IOException {
        OutputStream output = null;
        try {
            monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_updating_history, 2);
            file.getParent().mkdir(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
            output = new BufferedOutputStream(file.openOutputStream(1, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)));
            StringBuffer buffer = new StringBuffer(256);
            buffer.append(descriptor.getTimeStamp());
            buffer.append('\t');
            buffer.append(RefactoringHistoryManager.escapeString(descriptor.getDescription()));
            buffer.append('\n');
            output.write(buffer.toString().getBytes("utf-8"));
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            if (output == null) throw throwable;
            try {
                output.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
        if (output == null) return;
        try {}
        catch (IOException iOException) {
            return;
        }
        output.close();
    }

    public static String escapeString(String string) {
        if (string.indexOf(9) < 0) {
            int length = string.length();
            StringBuffer buffer = new StringBuffer(length + 4);
            int index = 0;
            while (index < length) {
                char character = string.charAt(index);
                if ('\t' == character) {
                    buffer.append('\t');
                }
                buffer.append(character);
                ++index;
            }
            return buffer.toString();
        }
        return string;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void readRefactoringDescriptorProxies(IFileStore store, String project, Collection collection, long start, long end, int flags, IProgressMonitor monitor) throws CoreException {
        try {
            Object var13_15;
            int index;
            block21: {
                block22: {
                    monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_retrieving_history, 22);
                    IFileInfo info = store.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 2, 2));
                    if (!store.getName().equalsIgnoreCase("refactorings.index") || info.isDirectory() || !info.exists()) break block22;
                    InputStream stream = null;
                    try {
                        try {
                            stream = store.openInputStream(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                            RefactoringDescriptorProxy[] proxies = RefactoringHistoryManager.readRefactoringDescriptorProxies(stream, project, start, end, flags);
                            index = 0;
                            while (true) {
                                block23: {
                                    if (index < proxies.length) break block23;
                                    monitor.worked(1);
                                    break;
                                }
                                collection.add(proxies[index]);
                                ++index;
                            }
                        }
                        catch (IOException exception) {
                            throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 0, exception.getLocalizedMessage(), null));
                        }
                    }
                    catch (Throwable throwable) {
                        Object var13_14 = null;
                        monitor.worked(1);
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        monitor.worked(1);
                        throw throwable;
                    }
                    {
                        var13_15 = null;
                        monitor.worked(1);
                        if (stream != null) {
                            try {}
                            catch (IOException iOException) {}
                            stream.close();
                        }
                        monitor.worked(1);
                        break block21;
                    }
                }
                monitor.worked(4);
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IFileStore[] stores = store.childStores(0, (IProgressMonitor)new SubProgressMonitor(monitor, 2, 2));
            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 12);
            try {
                subMonitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_retrieving_history, stores.length);
                index = 0;
                while (index < stores.length) {
                    RefactoringHistoryManager.readRefactoringDescriptorProxies(stores[index], project, collection, start, end, flags, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 1));
                    ++index;
                }
            }
            catch (Throwable throwable) {
                var13_15 = null;
                subMonitor.done();
                throw throwable;
            }
            {
                var13_15 = null;
                subMonitor.done();
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var15_18 = null;
        }
        monitor.done();
    }

    public static RefactoringDescriptorProxy[] readRefactoringDescriptorProxies(InputStream stream, String project, long start, long end, int flags) throws IOException {
        ArrayList<DefaultRefactoringDescriptorProxy> list = new ArrayList<DefaultRefactoringDescriptorProxy>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "utf-8"));
        while (reader.ready()) {
            int index;
            String line = reader.readLine();
            if (line == null || (index = line.indexOf(9)) <= 0) continue;
            try {
                long stamp = new Long(line.substring(0, index));
                if (stamp < start || stamp > end) continue;
                list.add(new DefaultRefactoringDescriptorProxy(RefactoringHistoryManager.unescapeString(line.substring(index + 1)), project, stamp));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return list.toArray(new RefactoringDescriptorProxy[list.size()]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void readRefactoringDescriptors(InputStream stream, Collection collection, int count, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_retrieving_history, 1);
            RefactoringDescriptor[] results = new RefactoringSessionReader().readSession(new InputSource(new BufferedInputStream(stream))).getRefactorings();
            Arrays.sort(results, new Comparator(){

                public final int compare(Object first, Object second) {
                    return (int)(((RefactoringDescriptor)first).getTimeStamp() - ((RefactoringDescriptor)second).getTimeStamp());
                }
            });
            monitor.worked(1);
            int size = count - collection.size();
            int index = 0;
            while (index < results.length && index < size) {
                collection.add(results[index]);
                ++index;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        monitor.done();
    }

    public static RefactoringDescriptor[] readRefactoringDescriptors(InputStream stream, long start, long end) throws CoreException {
        ArrayList list = new ArrayList();
        RefactoringHistoryManager.readRefactoringDescriptors(stream, list, Integer.MAX_VALUE, (IProgressMonitor)new NullProgressMonitor());
        RefactoringDescriptor[] descriptors = new RefactoringDescriptor[list.size()];
        list.toArray(descriptors);
        return descriptors;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void removeIndexEntry(IFileStore file, long stamp, IProgressMonitor monitor) throws CoreException, IOException {
        BufferedReader reader = null;
        try {
            block16: {
                monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_updating_history, 4);
                if (file.fetchInfo().exists()) {
                    String value = new Long(stamp).toString();
                    reader = new BufferedReader(new InputStreamReader((InputStream)new DataInputStream(new BufferedInputStream(file.openInputStream(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)))), "utf-8"));
                    StringBuffer buffer = new StringBuffer();
                    while (reader.ready()) {
                        String line = reader.readLine();
                        if (line == null || line.startsWith(value)) continue;
                        buffer.append(line);
                        buffer.append('\n');
                    }
                    monitor.worked(1);
                    try {
                        reader.close();
                        reader = null;
                    }
                    catch (IOException iOException) {}
                    OutputStream stream = null;
                    try {
                        file.getParent().mkdir(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                        stream = new BufferedOutputStream(file.openOutputStream(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)));
                        stream.write(buffer.toString().getBytes("utf-8"));
                        Object var8_9 = null;
                        if (stream == null) break block16;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        if (stream == null) throw throwable;
                        try {
                            stream.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {}
                    catch (IOException iOException) {}
                    stream.close();
                }
            }
            Object var10_12 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            monitor.done();
            try {
                if (reader == null) throw throwable;
                reader.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        monitor.done();
        try {}
        catch (IOException iOException) {
            return;
        }
        if (reader == null) return;
        reader.close();
    }

    /*
     * Exception decompiling
     */
    private static void removeIndexTree(IFileStore store, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 177->180)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static IPath stampToPath(long stamp) {
        Calendar calendar = Calendar.getInstance(LOCAL_TIME_ZONE);
        calendar.setTimeInMillis(stamp);
        Path path = new Path(String.valueOf(calendar.get(1)));
        path = path.append(String.valueOf(calendar.get(2) + 1));
        path = path.append(String.valueOf(calendar.get(3)));
        return path;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object transformDescriptor(RefactoringDescriptor descriptor) throws CoreException {
        RefactoringSessionTransformer transformer = new RefactoringSessionTransformer();
        try {
            transformer.beginSession(null);
            try {
                transformer.beginRefactoring(descriptor.getID(), descriptor.getTimeStamp(), descriptor.getProject(), descriptor.getDescription(), descriptor.getComment(), descriptor.getFlags());
                Iterator iterator = descriptor.getArguments().entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    transformer.createArgument((String)entry.getKey(), (String)entry.getValue());
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                transformer.endRefactoring();
                throw throwable;
            }
            {
                Object var4_6 = null;
                transformer.endRefactoring();
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            transformer.endSession();
            throw throwable;
        }
        {
            Object var6_9 = null;
            transformer.endSession();
            return transformer.getResult();
        }
    }

    public static String unescapeString(String string) {
        if (string.indexOf(9) < 0) {
            int length = string.length();
            StringBuffer buffer = new StringBuffer(length);
            int index = 0;
            while (index < length) {
                char escape;
                char character = string.charAt(index);
                if ('\t' != character || index >= length - 1 || '\t' != (escape = string.charAt(index + 1))) {
                    buffer.append(character);
                }
                ++index;
            }
            return buffer.toString();
        }
        return string;
    }

    public static void writeRefactoringDescriptors(OutputStream stream, RefactoringDescriptor[] descriptors, boolean stamps) throws CoreException {
        RefactoringHistoryManager.writeRefactoringSession(stream, new RefactoringSessionDescriptor(descriptors, "1.0", null), stamps);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeRefactoringSession(OutputStream stream, RefactoringSessionDescriptor descriptor, boolean stamps) throws CoreException {
        Object result;
        RefactoringSessionTransformer transformer = new RefactoringSessionTransformer();
        RefactoringDescriptor[] descriptors = descriptor.getRefactorings();
        try {
            transformer.beginSession(descriptor.getComment());
            int index = 0;
            while (index < descriptors.length) {
                RefactoringDescriptor current = descriptors[index];
                if (current != null) {
                    Object var11_15;
                    try {
                        long stamp = stamps ? current.getTimeStamp() : -1L;
                        transformer.beginRefactoring(current.getID(), stamp, current.getProject(), current.getDescription(), current.getComment(), current.getFlags());
                        Iterator iterator = current.getArguments().entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry entry = iterator.next();
                            transformer.createArgument((String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                    catch (Throwable throwable) {
                        var11_15 = null;
                        transformer.endRefactoring();
                        throw throwable;
                    }
                    {
                        var11_15 = null;
                        transformer.endRefactoring();
                    }
                }
                ++index;
            }
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            transformer.endSession();
            throw throwable;
        }
        {
            Object var13_19 = null;
            transformer.endSession();
            result = transformer.getResult();
        }
        if (!(result instanceof Node)) return;
        try {
            Transformer transform = TransformerFactory.newInstance().newTransformer();
            transform.setOutputProperty("indent", "yes");
            transform.setOutputProperty("method", "xml");
            transform.setOutputProperty("encoding", "utf-8");
            transform.transform(new DOMSource((Node)result), new StreamResult(stream));
            return;
        }
        catch (TransformerConfigurationException exception) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ltk.core.refactoring", 10006, exception.getLocalizedMessage(), (Throwable)exception));
        }
        catch (TransformerFactoryConfigurationError exception) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.ltk.core.refactoring", 10006, exception.getLocalizedMessage(), (Throwable)exception));
        }
        catch (TransformerException exception) {
            Throwable throwable = exception.getException();
            if (throwable instanceof IOException) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ltk.core.refactoring", 10006, throwable.getLocalizedMessage(), throwable));
            }
            RefactoringCorePlugin.log(exception);
        }
    }

    RefactoringHistoryManager(IFileStore store, String name) {
        Assert.isNotNull((Object)store);
        Assert.isTrue((name == null || !"".equals(name) ? 1 : 0) != 0);
        this.fHistoryStore = store;
        this.fProjectName = name;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addHistoryEntry(IFileStore file, Node node, IProgressMonitor monitor) throws CoreException, IOException {
        OutputStream output = null;
        try {
            monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_updating_history, 2);
            try {
                try {
                    file.getParent().mkdir(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                    output = new BufferedOutputStream(file.openOutputStream(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)));
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("method", "xml");
                    transformer.setOutputProperty("encoding", "utf-8");
                    try {
                        transformer.transform(new DOMSource(node), new StreamResult(output));
                    }
                    catch (Throwable throwable) {
                        Object var6_10 = null;
                        this.fCachedDocument = null;
                        this.fCachedPath = null;
                        this.fCachedDescriptor = null;
                        this.fCachedStore = null;
                        throw throwable;
                    }
                    {
                        Object var6_11 = null;
                        this.fCachedDocument = null;
                        this.fCachedPath = null;
                        this.fCachedDescriptor = null;
                        this.fCachedStore = null;
                    }
                }
                catch (TransformerConfigurationException exception) {
                    throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 0, exception.getLocalizedMessage(), null));
                }
                catch (TransformerFactoryConfigurationError exception) {
                    throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 0, exception.getLocalizedMessage(), null));
                }
                catch (TransformerException exception) {
                    Throwable throwable = exception.getException();
                    if (throwable instanceof IOException) {
                        throw (IOException)throwable;
                    }
                    RefactoringCorePlugin.log(exception);
                }
            }
            catch (Throwable throwable) {
                Object var8_14 = null;
                if (output == null) throw throwable;
                try {
                    output.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var8_15 = null;
                if (output != null) {
                    try {}
                    catch (IOException iOException) {}
                    output.close();
                }
            }
        }
        catch (Throwable throwable) {
            Object var10_17 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var10_18 = null;
        }
        monitor.done();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void addRefactoringDescriptor(RefactoringDescriptor descriptor, IProgressMonitor monitor) throws CoreException {
        try {
            block24: {
                IPath path;
                IFileStore folder;
                monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_updating_history, 5);
                long stamp = descriptor.getTimeStamp();
                if (stamp >= 0L && (folder = this.fHistoryStore.getChild(path = RefactoringHistoryManager.stampToPath(stamp))) != null) {
                    IFileStore history = folder.getChild("refactorings.history");
                    IFileStore index = folder.getChild("refactorings.index");
                    if (history != null && index != null) {
                        if (history.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)).exists()) {
                            InputStream input = null;
                            try {
                                try {
                                    input = new BufferedInputStream(history.openInputStream(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)));
                                    Document document = this.getCachedDocument(path, input);
                                    try {
                                        input.close();
                                        input = null;
                                    }
                                    catch (IOException iOException) {}
                                    monitor.worked(1);
                                    Object result = RefactoringHistoryManager.transformDescriptor(descriptor);
                                    if (result instanceof Document) {
                                        NodeList list = ((Document)result).getElementsByTagName("refactoring");
                                        Assert.isTrue((list.getLength() == 1 ? 1 : 0) != 0);
                                        document.getDocumentElement().appendChild(document.importNode(list.item(0), true));
                                        this.addHistoryEntry(history, document, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                                        RefactoringHistoryManager.addIndexEntry(index, descriptor, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                                    }
                                }
                                catch (ParserConfigurationException exception) {
                                    new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 0, exception.getLocalizedMessage(), null));
                                }
                                catch (IOException exception) {
                                    new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 0, exception.getLocalizedMessage(), null));
                                }
                                catch (SAXException exception) {
                                    new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 0, exception.getLocalizedMessage(), null));
                                }
                                Object var13_19 = null;
                                if (input == null) break block24;
                            }
                            catch (Throwable throwable) {
                                Object var13_18 = null;
                                if (input == null) throw throwable;
                                try {
                                    input.close();
                                    throw throwable;
                                }
                                catch (IOException iOException) {}
                                throw throwable;
                            }
                            try {}
                            catch (IOException iOException) {}
                            input.close();
                        } else {
                            try {
                                Object result = RefactoringHistoryManager.transformDescriptor(descriptor);
                                if (result instanceof Node) {
                                    this.addHistoryEntry(history, (Node)result, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                                    RefactoringHistoryManager.addIndexEntry(index, descriptor, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                                }
                            }
                            catch (IOException exception) {
                                throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 0, exception.getLocalizedMessage(), null));
                            }
                        }
                    }
                }
            }
            Object var15_22 = null;
        }
        catch (Throwable throwable) {
            Object var15_21 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    private Document getCachedDocument(IPath path, InputStream input) throws SAXException, IOException, ParserConfigurationException {
        Document document;
        if (path.equals((Object)this.fCachedPath) && this.fCachedDocument != null) {
            return this.fCachedDocument;
        }
        this.fCachedDocument = document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(input));
        this.fCachedPath = path;
        return document;
    }

    private RefactoringSessionDescriptor getCachedSession(IFileStore store, InputStream input) throws CoreException {
        RefactoringSessionDescriptor descriptor;
        if (store.equals(this.fCachedStore) && this.fCachedDescriptor != null) {
            return this.fCachedDescriptor;
        }
        this.fCachedDescriptor = descriptor = new RefactoringSessionReader().readSession(new InputSource(input));
        this.fCachedStore = store;
        return descriptor;
    }

    RefactoringHistory readRefactoringHistory(long start, long end, int flags, IProgressMonitor monitor) {
        RefactoringHistoryImplementation refactoringHistoryImplementation;
        try {
            monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_retrieving_history, 200);
            HashSet set = new HashSet();
            try {
                IFileStore store;
                if (this.fHistoryStore.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20, 2)).exists()) {
                    RefactoringHistoryManager.readRefactoringDescriptorProxies(this.fHistoryStore, this.fProjectName, set, start, end, flags, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
                }
                if ((store = EFS.getLocalFileSystem().getStore(RefactoringCorePlugin.getDefault().getStateLocation()).getChild(".refactorings").getChild(".workspace")).fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20, 2)).exists()) {
                    RefactoringHistoryManager.readRefactoringDescriptorProxies(store, null, set, start, end, flags, (IProgressMonitor)new SubProgressMonitor(monitor, 80));
                }
            }
            catch (CoreException exception) {
                RefactoringCorePlugin.log(exception);
            }
            RefactoringDescriptorProxy[] proxies = new RefactoringDescriptorProxy[set.size()];
            set.toArray(proxies);
            refactoringHistoryImplementation = new RefactoringHistoryImplementation(proxies);
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return refactoringHistoryImplementation;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeRefactoringDescriptor(long stamp, IProgressMonitor monitor) throws CoreException {
        try {
            block23: {
                monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_updating_history, 6);
                IPath path = RefactoringHistoryManager.stampToPath(stamp);
                IFileStore folder = this.fHistoryStore.getChild(path);
                if (folder != null) {
                    IFileStore history = folder.getChild("refactorings.history");
                    IFileStore index = folder.getChild("refactorings.index");
                    if (history != null && index != null && history.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)).exists() && index.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)).exists()) {
                        InputStream input = null;
                        try {
                            try {
                                input = new BufferedInputStream(history.openInputStream(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2)));
                                Document document = this.getCachedDocument(path, input);
                                NodeList list = document.getElementsByTagName("refactoring");
                                int length = list.getLength();
                                int offset = 0;
                                while (offset < length) {
                                    Node item;
                                    Node node = list.item(offset);
                                    NamedNodeMap attributes = node.getAttributes();
                                    if (attributes != null && (item = attributes.getNamedItem("stamp")) != null) {
                                        String value = item.getNodeValue();
                                        if (String.valueOf(stamp).equals(value)) {
                                            node.getParentNode().removeChild(node);
                                            try {
                                                input.close();
                                                input = null;
                                            }
                                            catch (IOException iOException) {}
                                            if (length == 1) {
                                                RefactoringHistoryManager.removeIndexTree(folder, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                                            } else {
                                                this.addHistoryEntry(history, document, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                                                RefactoringHistoryManager.removeIndexEntry(index, stamp, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 2));
                                            }
                                            break;
                                        }
                                    }
                                    ++offset;
                                }
                            }
                            catch (ParserConfigurationException exception) {
                                new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 0, exception.getLocalizedMessage(), null));
                            }
                            catch (IOException exception) {
                                new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 0, exception.getLocalizedMessage(), null));
                            }
                            catch (SAXException exception) {
                                new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 0, exception.getLocalizedMessage(), null));
                            }
                            Object var17_21 = null;
                            if (input == null) break block23;
                        }
                        catch (Throwable throwable) {
                            Object var17_20 = null;
                            if (input == null) throw throwable;
                            try {
                                input.close();
                                throw throwable;
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                        try {}
                        catch (IOException iOException) {}
                        input.close();
                    }
                }
            }
            Object var19_24 = null;
        }
        catch (Throwable throwable) {
            Object var19_23 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    /*
     * Exception decompiling
     */
    RefactoringDescriptor requestDescriptor(RefactoringDescriptorProxy proxy, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 7[TRYBLOCK] [3 : 215->221)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setComment(RefactoringDescriptorProxy proxy, String comment, IProgressMonitor monitor) throws CoreException {
        try {
            block19: {
                IFileStore history;
                IPath path;
                IFileStore folder;
                monitor.beginTask(RefactoringCoreMessages.RefactoringHistoryService_updating_history, 100);
                long stamp = proxy.getTimeStamp();
                if (stamp >= 0L && (folder = this.fHistoryStore.getChild(path = RefactoringHistoryManager.stampToPath(stamp))) != null && (history = folder.getChild("refactorings.history")) != null && history.fetchInfo(0, (IProgressMonitor)new SubProgressMonitor(monitor, 20, 2)).exists()) {
                    InputStream input = null;
                    try {
                        try {
                            input = new BufferedInputStream(history.openInputStream(0, (IProgressMonitor)new SubProgressMonitor(monitor, 40, 2)));
                            Document document = this.getCachedDocument(path, input);
                            try {
                                input.close();
                                input = null;
                            }
                            catch (IOException iOException) {}
                            String time = String.valueOf(stamp);
                            NodeList list = document.getElementsByTagName("refactoring");
                            int index = 0;
                            while (true) {
                                if (index >= list.getLength()) {
                                    this.addHistoryEntry(history, document, (IProgressMonitor)new SubProgressMonitor(monitor, 40, 2));
                                }
                                Element element = (Element)list.item(index);
                                if (time.equals(element.getAttribute("stamp"))) {
                                    element.setAttribute("comment", comment);
                                }
                                ++index;
                            }
                        }
                        catch (ParserConfigurationException exception) {
                            new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 0, exception.getLocalizedMessage(), null));
                        }
                        catch (IOException exception) {
                            new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 0, exception.getLocalizedMessage(), null));
                        }
                        catch (SAXException exception) {
                            new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 0, exception.getLocalizedMessage(), null));
                        }
                        Object var15_19 = null;
                        if (input == null) break block19;
                    }
                    catch (Throwable throwable) {
                        Object var15_18 = null;
                        if (input == null) throw throwable;
                        try {
                            input.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {}
                    catch (IOException iOException) {}
                    input.close();
                }
            }
            Object var17_22 = null;
        }
        catch (Throwable throwable) {
            Object var17_21 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }
}

