/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.history;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ltk.core.refactoring.IRefactoringInstanceCreator;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;

public final class RefactoringInstanceFactory
implements IRegistryChangeListener,
IRefactoringInstanceCreator {
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_ID = "id";
    private static RefactoringInstanceFactory fInstance = null;
    private static final String REFACTORING_CREATORS_EXTENSION_POINT = "refactoringCreators";
    private Map fCreatorCache = null;

    public static RefactoringInstanceFactory getInstance() {
        if (fInstance == null) {
            fInstance = new RefactoringInstanceFactory();
        }
        return fInstance;
    }

    private RefactoringInstanceFactory() {
    }

    public void connect() {
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this, "org.eclipse.ltk.core.refactoring");
    }

    public RefactoringArguments createArguments(RefactoringDescriptor descriptor) {
        IRefactoringInstanceCreator creator;
        Assert.isNotNull((Object)descriptor);
        String id = descriptor.getID();
        if (id != null && (creator = this.createRefactoringCreator(id)) != null) {
            return creator.createArguments(descriptor);
        }
        return null;
    }

    public Refactoring createRefactoring(RefactoringDescriptor descriptor) throws CoreException {
        IRefactoringInstanceCreator creator;
        Assert.isNotNull((Object)descriptor);
        String id = descriptor.getID();
        if (id != null && (creator = this.createRefactoringCreator(id)) != null) {
            return creator.createRefactoring(descriptor);
        }
        return null;
    }

    private IRefactoringInstanceCreator createRefactoringCreator(String id) {
        Assert.isNotNull((Object)id);
        Assert.isTrue((!"".equals(id) ? 1 : 0) != 0);
        if (this.fCreatorCache == null) {
            this.fCreatorCache = new HashMap();
            IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ltk.core.refactoring", REFACTORING_CREATORS_EXTENSION_POINT);
            int index = 0;
            while (index < elements.length) {
                block10: {
                    IConfigurationElement element = elements[index];
                    String attributeId = element.getAttribute(ATTRIBUTE_ID);
                    if (attributeId != null && !"".equals(attributeId)) {
                        String className = element.getAttribute(ATTRIBUTE_CLASS);
                        if (className != null && !"".equals(className)) {
                            try {
                                Object implementation = element.createExecutableExtension(ATTRIBUTE_CLASS);
                                if (implementation instanceof IRefactoringInstanceCreator) {
                                    if (this.fCreatorCache.get(attributeId) != null) {
                                        RefactoringCorePlugin.logErrorMessage(Messages.format(RefactoringCoreMessages.RefactoringCorePlugin_duplicate_warning, new String[]{attributeId, "org.eclipse.ltk.core.refactoring.refactoringCreators"}));
                                    }
                                    this.fCreatorCache.put(attributeId, implementation);
                                    break block10;
                                }
                                RefactoringCorePlugin.logErrorMessage(Messages.format(RefactoringCoreMessages.RefactoringCorePlugin_creation_error, new String[]{"org.eclipse.ltk.core.refactoring.refactoringCreators", attributeId}));
                            }
                            catch (CoreException exception) {
                                RefactoringCorePlugin.log(exception);
                            }
                        } else {
                            RefactoringCorePlugin.logErrorMessage(Messages.format(RefactoringCoreMessages.RefactoringCorePlugin_missing_class_attribute, new String[]{"org.eclipse.ltk.core.refactoring.refactoringCreators", attributeId, ATTRIBUTE_CLASS}));
                        }
                    } else {
                        RefactoringCorePlugin.logErrorMessage(Messages.format(RefactoringCoreMessages.RefactoringCorePlugin_missing_attribute, new String[]{"org.eclipse.ltk.core.refactoring.refactoringCreators", ATTRIBUTE_ID}));
                    }
                }
                ++index;
            }
        }
        return (IRefactoringInstanceCreator)this.fCreatorCache.get(id);
    }

    public void disconnect() {
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
    }

    public void registryChanged(IRegistryChangeEvent event) {
        this.fCreatorCache = null;
    }
}

