/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.history;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.Splitter;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.ui.refactoring.Messages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPluginImages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryEntry;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryNode;
import org.eclipse.ltk.ui.refactoring.history.IRefactoringHistoryControl;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryContentProvider;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.UIJob;

public class RefactoringHistoryControl
extends Composite
implements IRefactoringHistoryControl {
    private Image fCaptionImage = null;
    private final Set fCheckedDescriptors = new HashSet();
    private CompareViewerSwitchingPane fCommentPane = null;
    protected final RefactoringHistoryControlConfiguration fControlConfiguration;
    private CompareViewerPane fHistoryPane = null;
    protected TreeViewer fHistoryViewer = null;
    private final Set fSelectedDescriptors = new HashSet();
    private Splitter fSplitterControl = null;

    public RefactoringHistoryControl(Composite parent, RefactoringHistoryControlConfiguration configuration) {
        super(parent, 0);
        Assert.isNotNull((Object)configuration);
        this.fControlConfiguration = configuration;
    }

    public final void addCheckStateListener(ICheckStateListener listener) {
        Assert.isNotNull((Object)listener);
        if (this.fHistoryViewer instanceof RefactoringHistoryTreeViewer) {
            RefactoringHistoryTreeViewer viewer = (RefactoringHistoryTreeViewer)this.fHistoryViewer;
            viewer.addCheckStateListener(listener);
        }
    }

    public final void addSelectionChangedListener(ISelectionChangedListener listener) {
        Assert.isNotNull((Object)listener);
        if (this.fHistoryViewer != null) {
            this.fHistoryViewer.addSelectionChangedListener(listener);
        }
    }

    protected void createButtonBar(Composite parent) {
    }

    public void createControl() {
        RefactoringCore.getRefactoringHistoryService().connect();
        this.fCaptionImage = RefactoringPluginImages.DESC_OBJS_REFACTORING_COLL.createImage();
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.setLayout((Layout)layout);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.setLayoutData(data);
        this.fSplitterControl = new Splitter((Composite)this, 512);
        this.fSplitterControl.setLayoutData((Object)new GridData(1808));
        this.fSplitterControl.addDisposeListener(new DisposeListener(){

            public final void widgetDisposed(DisposeEvent event) {
                if (RefactoringHistoryControl.this.fCaptionImage != null) {
                    RefactoringHistoryControl.this.fCaptionImage.dispose();
                }
            }
        });
        this.createButtonBar(this);
        Composite leftPane = new Composite((Composite)this.fSplitterControl, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 2;
        layout.verticalSpacing = 2;
        leftPane.setLayout((Layout)layout);
        this.fHistoryPane = new CompareViewerPane(leftPane, 0x800800);
        if (this.fControlConfiguration.isTimeDisplayed()) {
            this.fHistoryPane.setImage(this.fCaptionImage);
        }
        this.fHistoryPane.setText(this.getHistoryPaneText());
        this.fHistoryPane.setLayoutData((Object)new GridData(1808));
        this.fHistoryViewer = this.createHistoryViewer((Composite)this.fHistoryPane);
        if (!this.fControlConfiguration.isTimeDisplayed()) {
            this.fHistoryViewer.setAutoExpandLevel(-1);
        }
        this.fHistoryViewer.setUseHashlookup(true);
        this.fHistoryViewer.setContentProvider((IContentProvider)this.fControlConfiguration.getContentProvider());
        this.fHistoryViewer.setLabelProvider((IBaseLabelProvider)this.fControlConfiguration.getLabelProvider());
        this.fHistoryViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public final void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    RefactoringHistoryControl.this.handleSelectionChanged((IStructuredSelection)selection);
                }
            }
        });
        this.fHistoryPane.setContent(this.fHistoryViewer.getControl());
        this.fCommentPane = new CompareViewerSwitchingPane((Composite)this.fSplitterControl, 0x800800){

            protected final Viewer getViewer(Viewer viewer, Object input) {
                if (input instanceof String) {
                    String comment = (String)input;
                    TextViewer extended = new TextViewer((Composite)RefactoringHistoryControl.this.fCommentPane, 0);
                    extended.setDocument((IDocument)new Document(comment));
                    this.setText(RefactoringHistoryControl.this.fControlConfiguration.getCommentCaption());
                    return extended;
                }
                return null;
            }
        };
        this.fCommentPane.setText(this.fControlConfiguration.getCommentCaption());
        this.fCommentPane.setEnabled(false);
        this.fSplitterControl.setWeights(new int[]{80, 20});
        Dialog.applyDialogFont((Control)this);
    }

    protected TreeViewer createHistoryViewer(Composite parent) {
        Assert.isNotNull((Object)parent);
        if (this.fControlConfiguration.isCheckableViewer()) {
            return new RefactoringHistoryTreeViewer(parent, 768);
        }
        return new TreeViewer(parent, 768);
    }

    public final void dispose() {
        RefactoringCore.getRefactoringHistoryService().disconnect();
        super.dispose();
    }

    public final RefactoringDescriptorProxy[] getCheckedDescriptors() {
        if (this.fHistoryViewer instanceof RefactoringHistoryTreeViewer) {
            return this.fCheckedDescriptors.toArray(new RefactoringDescriptorProxy[this.fCheckedDescriptors.size()]);
        }
        return this.getSelectedDescriptors();
    }

    public final Control getControl() {
        return this;
    }

    private Collection getCoveredDescriptors(Object element) {
        Assert.isNotNull((Object)element);
        HashSet set = new HashSet();
        this.getCoveredDescriptors(element, set);
        return set;
    }

    private void getCoveredDescriptors(Object element, Set set) {
        Assert.isNotNull((Object)element);
        Assert.isNotNull((Object)set);
        RefactoringHistoryContentProvider provider = (RefactoringHistoryContentProvider)this.fHistoryViewer.getContentProvider();
        if (provider != null) {
            if (element instanceof RefactoringHistoryEntry) {
                RefactoringHistoryEntry entry = (RefactoringHistoryEntry)element;
                RefactoringDescriptorProxy proxy = entry.getDescriptor();
                set.add(proxy);
            } else {
                Object[] children = provider.getChildren(element);
                int index = 0;
                while (index < children.length) {
                    Object child = children[index];
                    if (child instanceof RefactoringHistoryNode) {
                        this.getCoveredDescriptors(child, set);
                    }
                    ++index;
                }
            }
        }
    }

    private String getHistoryPaneText() {
        String text = null;
        IProject project = this.fControlConfiguration.getProject();
        text = project != null ? Messages.format(this.fControlConfiguration.getProjectPattern(), new String[]{project.getName()}) : this.fControlConfiguration.getWorkspaceCaption();
        return text;
    }

    public final RefactoringHistory getInput() {
        return (RefactoringHistory)this.fHistoryViewer.getInput();
    }

    public final RefactoringDescriptorProxy[] getSelectedDescriptors() {
        return this.fSelectedDescriptors.toArray(new RefactoringDescriptorProxy[this.fSelectedDescriptors.size()]);
    }

    protected void handleCheckStateChanged() {
        RefactoringHistory history = this.getInput();
        if (history != null) {
            int total = history.getDescriptors().length;
            if (total > 0 && this.fControlConfiguration.isCheckableViewer()) {
                this.fHistoryPane.setText(NLS.bind((String)RefactoringUIMessages.RefactoringHistoryControl_selection_pattern, (Object[])new String[]{this.getHistoryPaneText(), String.valueOf(this.fCheckedDescriptors.size()), String.valueOf(total)}));
            } else {
                this.fHistoryPane.setText(this.getHistoryPaneText());
            }
        }
    }

    protected void handleSelectionChanged(IStructuredSelection selection) {
        Assert.isNotNull((Object)selection);
        this.fSelectedDescriptors.clear();
        Object[] elements = selection.toArray();
        int index = 0;
        while (index < elements.length) {
            Object element = elements[index];
            if (element instanceof RefactoringHistoryEntry) {
                RefactoringHistoryEntry entry = (RefactoringHistoryEntry)element;
                RefactoringDescriptorProxy proxy = entry.getDescriptor();
                this.fSelectedDescriptors.add(proxy);
            } else if (element instanceof RefactoringHistoryNode) {
                RefactoringHistoryNode node = (RefactoringHistoryNode)element;
                this.fSelectedDescriptors.addAll(this.getCoveredDescriptors(node));
            }
            ++index;
        }
        if (elements.length == 1 && elements[0] instanceof RefactoringHistoryEntry) {
            RefactoringHistoryEntry entry = (RefactoringHistoryEntry)elements[0];
            final RefactoringDescriptorProxy proxy = entry.getDescriptor();
            UIJob job = new UIJob(RefactoringUIMessages.RefactoringHistoryControl_resolving_information){

                public final IStatus runInUIThread(IProgressMonitor monitor) {
                    RefactoringDescriptor descriptor = proxy.requestDescriptor(monitor);
                    if (descriptor != null) {
                        RefactoringHistoryControl.this.fCommentPane.setInput((Object)descriptor.getComment());
                        RefactoringHistoryControl.this.fCommentPane.setText(RefactoringHistoryControl.this.fControlConfiguration.getCommentCaption());
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
        this.fCommentPane.setInput(null);
        this.fCommentPane.setText(this.fControlConfiguration.getCommentCaption());
    }

    public final void removeCheckStateListener(ICheckStateListener listener) {
        Assert.isNotNull((Object)listener);
        Assert.isNotNull((Object)listener);
        if (this.fHistoryViewer instanceof RefactoringHistoryTreeViewer) {
            RefactoringHistoryTreeViewer viewer = (RefactoringHistoryTreeViewer)this.fHistoryViewer;
            viewer.removeCheckStateListener(listener);
        }
    }

    public final void removeSelectionChangedListener(ISelectionChangedListener listener) {
        Assert.isNotNull((Object)listener);
        if (this.fHistoryViewer != null) {
            this.fHistoryViewer.removeSelectionChangedListener(listener);
        }
    }

    public final void setCheckedDescriptors(RefactoringDescriptorProxy[] descriptors) {
        Assert.isNotNull((Object)descriptors);
        if (this.fHistoryViewer instanceof RefactoringHistoryTreeViewer) {
            this.fCheckedDescriptors.clear();
            this.fCheckedDescriptors.addAll(Arrays.asList(descriptors));
            RefactoringHistoryTreeViewer viewer = (RefactoringHistoryTreeViewer)this.fHistoryViewer;
            RefactoringHistoryNode[] nodes = new RefactoringHistoryNode[descriptors.length];
            int index = 0;
            while (index < descriptors.length) {
                nodes[index] = new RefactoringHistoryEntry(null, descriptors[index]);
                ++index;
            }
            RefactoringHistory history = this.getInput();
            if (history != null) {
                viewer.reconcileCheckState(history);
            }
            this.handleCheckStateChanged();
        } else {
            this.setSelectedDescriptors(descriptors);
        }
    }

    public void setInput(RefactoringHistory history) {
        RefactoringHistoryContentProvider provider;
        this.fHistoryViewer.setInput((Object)history);
        this.fSelectedDescriptors.clear();
        this.fCheckedDescriptors.clear();
        if (history != null && (provider = (RefactoringHistoryContentProvider)this.fHistoryViewer.getContentProvider()) != null) {
            Object first;
            provider.inputChanged((Viewer)this.fHistoryViewer, null, history);
            this.handleCheckStateChanged();
            Object[] roots = provider.getRootElements();
            if (roots != null && roots.length > 0 && (first = roots[0]) != null) {
                this.fHistoryViewer.setExpandedState(first, true);
            }
        }
    }

    public final void setSelectedDescriptors(RefactoringDescriptorProxy[] descriptors) {
        Assert.isNotNull((Object)descriptors);
        if (this.fHistoryViewer != null) {
            this.fSelectedDescriptors.clear();
            this.fSelectedDescriptors.addAll(Arrays.asList(descriptors));
            Object[] nodes = new RefactoringHistoryNode[descriptors.length];
            int index = 0;
            while (index < descriptors.length) {
                nodes[index] = new RefactoringHistoryEntry(null, descriptors[index]);
                ++index;
            }
            this.fHistoryViewer.setSelection((ISelection)new StructuredSelection(nodes));
        }
    }

    protected final class RefactoringHistoryTreeViewer
    extends CheckboxTreeViewer {
        public RefactoringHistoryTreeViewer(Composite parent, int style) {
            super(parent, style);
            this.addCheckStateListener(new ICheckStateListener(this){
                final /* synthetic */ RefactoringHistoryTreeViewer this$1;
                {
                    this.this$1 = refactoringHistoryTreeViewer;
                }

                public final void checkStateChanged(CheckStateChangedEvent event) {
                    RefactoringHistoryTreeViewer.access$0(this.this$1, event.getElement(), event.getChecked());
                    RefactoringHistoryTreeViewer.access$3(this.this$1).handleCheckStateChanged();
                }
            });
            this.addTreeListener(new ITreeViewerListener(this){
                final /* synthetic */ RefactoringHistoryTreeViewer this$1;
                {
                    this.this$1 = refactoringHistoryTreeViewer;
                }

                public final void treeCollapsed(TreeExpansionEvent event) {
                }

                public final void treeExpanded(TreeExpansionEvent event) {
                    Object element = event.getElement();
                    if (this.this$1.getChecked(element)) {
                        RefactoringHistoryTreeViewer.access$1(this.this$1, element, false);
                        this.this$1.setSubtreeChecked(element, true);
                    }
                }
            });
        }

        private Object[] getChildren(Object element) {
            return ((RefactoringHistoryContentProvider)this.getContentProvider()).getChildren(element);
        }

        private void reconcileCheckState(Object element) {
            Object[] children = this.getChildren(element);
            int index = 0;
            while (index < children.length) {
                this.reconcileCheckState(children[index]);
                ++index;
            }
            int checkCount = 0;
            Collection collection = RefactoringHistoryControl.this.getCoveredDescriptors(element);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                RefactoringDescriptorProxy proxy = (RefactoringDescriptorProxy)iterator.next();
                if (!RefactoringHistoryControl.this.fCheckedDescriptors.contains(proxy)) continue;
                ++checkCount;
            }
            this.setElementChecked(element, checkCount > 0);
            this.setElementGrayed(element, checkCount != 0 && checkCount != collection.size());
        }

        private void reconcileCheckState(Object element, boolean checked) {
            if (element instanceof RefactoringHistoryEntry) {
                RefactoringHistoryEntry entry = (RefactoringHistoryEntry)element;
                RefactoringDescriptorProxy proxy = entry.getDescriptor();
                if (checked) {
                    RefactoringHistoryControl.this.fCheckedDescriptors.add(proxy);
                } else {
                    RefactoringHistoryControl.this.fCheckedDescriptors.remove(proxy);
                }
            } else if (element instanceof RefactoringHistoryNode) {
                Collection collection = RefactoringHistoryControl.this.getCoveredDescriptors(element);
                if (checked) {
                    RefactoringHistoryControl.this.fCheckedDescriptors.addAll(collection);
                } else {
                    RefactoringHistoryControl.this.fCheckedDescriptors.removeAll(collection);
                }
            }
            RefactoringHistory history = RefactoringHistoryControl.this.getInput();
            if (history != null) {
                this.reconcileCheckState(history);
            }
        }

        private void setElementChecked(Object element, boolean checked) {
            Widget widget = this.findItem(element);
            if (widget instanceof TreeItem) {
                TreeItem item = (TreeItem)widget;
                item.setChecked(checked);
            }
        }

        private void setElementGrayed(Object element, boolean grayed) {
            Widget widget = this.findItem(element);
            if (widget instanceof TreeItem) {
                TreeItem item = (TreeItem)widget;
                item.setGrayed(grayed);
            }
        }

        private void setSubTreeGrayed(Object element, boolean grayed) {
            this.setElementGrayed(element, grayed);
            Object[] children = this.getChildren(element);
            int index = 0;
            while (index < children.length) {
                this.setSubTreeGrayed(children[index], grayed);
                ++index;
            }
        }

        static /* synthetic */ void access$0(RefactoringHistoryTreeViewer refactoringHistoryTreeViewer, Object object, boolean bl) {
            refactoringHistoryTreeViewer.reconcileCheckState(object, bl);
        }

        static /* synthetic */ void access$1(RefactoringHistoryTreeViewer refactoringHistoryTreeViewer, Object object, boolean bl) {
            refactoringHistoryTreeViewer.setSubTreeGrayed(object, bl);
        }

        static /* synthetic */ RefactoringHistoryControl access$3(RefactoringHistoryTreeViewer refactoringHistoryTreeViewer) {
            return refactoringHistoryTreeViewer.RefactoringHistoryControl.this;
        }
    }
}

