/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.history;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.history.IRefactoringHistoryService;
import org.eclipse.ltk.internal.core.refactoring.history.IRefactoringDescriptorDeleteQuery;
import org.eclipse.ltk.internal.core.refactoring.history.RefactoringHistoryService;
import org.eclipse.ltk.internal.ui.refactoring.Messages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.internal.ui.refactoring.history.ManageRefactoringHistoryControl;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;

public final class RefactoringPropertyPage
extends PropertyPage {
    private static final String PREFERENCE_DO_NOT_WARN_DELETE = String.valueOf(RefactoringUIPlugin.getPluginId()) + ".do.not.warn.delete.descriptor";
    private static final String PREFERENCE_DO_NOT_WARN_DELETE_ALL = String.valueOf(RefactoringUIPlugin.getPluginId()) + ".do.not.warn.delete.history";
    private boolean fHasProjectHistory = false;
    private IWorkingCopyManager fManager = null;
    private Button fShareHistory = null;
    static /* synthetic */ Class class$0;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        IPreferencePageContainer container = this.getContainer();
        if (container instanceof IWorkbenchPreferenceContainer) {
            this.fManager = ((IWorkbenchPreferenceContainer)container).getWorkingCopyManager();
        }
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginRight = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 64);
        label.setText(RefactoringUIMessages.RefactoringPropertyPage_label_message);
        final ManageRefactoringHistoryControl control = new ManageRefactoringHistoryControl(composite, new RefactoringHistoryControlConfiguration(this.getCurrentProject(), true, true));
        control.createControl();
        control.getDeleteAllButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final void widgetSelected(SelectionEvent event) {
                IProject project = RefactoringPropertyPage.this.getCurrentProject();
                IPreferenceStore store = RefactoringUIPlugin.getDefault().getPreferenceStore();
                MessageDialogWithToggle dialog = null;
                if (!store.getBoolean(PREFERENCE_DO_NOT_WARN_DELETE_ALL) && !control.getInput().isEmpty()) {
                    dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)RefactoringPropertyPage.this.getShell(), (String)RefactoringUIMessages.RefactoringPropertyPage_confirm_delete_all_caption, (String)Messages.format(RefactoringUIMessages.RefactoringPropertyPage_confirm_delete_all_pattern, project.getName()), (String)RefactoringUIMessages.RefactoringHistoryWizard_do_not_show_message, (boolean)false, null, null);
                    store.setValue(PREFERENCE_DO_NOT_WARN_DELETE_ALL, dialog.getToggleState());
                }
                if (dialog != null) {
                    if (dialog.getReturnCode() != 2) return;
                }
                RefactoringHistoryService service = RefactoringHistoryService.getInstance();
                try {
                    service.connect();
                    try {
                        service.deleteRefactoringHistory(project, null);
                    }
                    catch (CoreException exception) {
                        Throwable throwable = exception.getStatus().getException();
                        if (throwable instanceof IOException) {
                            MessageDialog.openError((Shell)RefactoringPropertyPage.this.getShell(), (String)RefactoringUIMessages.ChangeExceptionHandler_refactoring, (String)throwable.getLocalizedMessage());
                        }
                        RefactoringUIPlugin.log(exception);
                    }
                    control.setInput(service.getProjectHistory(project, null));
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    service.disconnect();
                    throw throwable;
                }
                {
                    Object var8_10 = null;
                }
                service.disconnect();
            }
        });
        control.getDeleteButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final void widgetSelected(SelectionEvent event) {
                RefactoringDescriptorProxy[] selection = control.getCheckedDescriptors();
                if (selection.length <= 0) return;
                RefactoringHistoryService service = RefactoringHistoryService.getInstance();
                try {
                    service.connect();
                    try {
                        service.deleteRefactoringDescriptors(selection, (IRefactoringDescriptorDeleteQuery)new RefactoringDescriptorDeleteQuery(), null);
                    }
                    catch (CoreException exception) {
                        Throwable throwable = exception.getStatus().getException();
                        if (throwable instanceof IOException) {
                            MessageDialog.openError((Shell)RefactoringPropertyPage.this.getShell(), (String)RefactoringUIMessages.ChangeExceptionHandler_refactoring, (String)throwable.getLocalizedMessage());
                        }
                        RefactoringUIPlugin.log(exception);
                    }
                    control.setInput(service.getProjectHistory(RefactoringPropertyPage.this.getCurrentProject(), null));
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    service.disconnect();
                    throw throwable;
                }
                {
                    Object var6_8 = null;
                }
                service.disconnect();
            }
        });
        control.getEditButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            /*
             * Exception decompiling
             */
            public final void widgetSelected(SelectionEvent event) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 159->163)] java.lang.Throwable
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
        this.fShareHistory = new Button(composite, 32);
        this.fShareHistory.setText(RefactoringUIMessages.RefactoringPropertyPage_share_message);
        this.fShareHistory.setData((Object)"org.eclipse.ltk.core.refactoring.enable.project.refactoring.history");
        this.fShareHistory.setLayoutData((Object)new GridData(256));
        this.fShareHistory.setSelection(this.hasSharedRefactoringHistory());
        new Label(composite, 0);
        IProject project = this.getCurrentProject();
        if (project != null) {
            IRefactoringHistoryService service = RefactoringCore.getRefactoringHistoryService();
            try {
                service.connect();
                control.setInput(service.getProjectHistory(project, null));
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                service.disconnect();
                throw throwable;
            }
            {
                Object var9_11 = null;
            }
            service.disconnect();
        }
        this.applyDialogFont(composite);
        return composite;
    }

    private IProject getCurrentProject() {
        IAdaptable iAdaptable = this.getElement();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IProject)iAdaptable.getAdapter((Class)clazz);
    }

    private IEclipsePreferences getPreferences(IWorkingCopyManager manager, IScopeContext context) {
        IEclipsePreferences preferences = context.getNode("org.eclipse.ltk.core.refactoring");
        if (manager != null) {
            return manager.getWorkingCopy(preferences);
        }
        return preferences;
    }

    private boolean hasSharedRefactoringHistory() {
        IProject project = this.getCurrentProject();
        if (project != null) {
            return RefactoringHistoryService.getInstance().hasSharedRefactoringHistory(project);
        }
        return false;
    }

    protected void performDefaults() {
        super.performDefaults();
        IProject project = this.getCurrentProject();
        if (project != null) {
            this.setPreference(this.fManager, (IScopeContext)new ProjectScope(project), "org.eclipse.ltk.core.refactoring.enable.project.refactoring.history", null);
        }
    }

    public boolean performOk() {
        IProject project = this.getCurrentProject();
        if (project != null) {
            this.setPreference(this.fManager, (IScopeContext)new ProjectScope(project), "org.eclipse.ltk.core.refactoring.enable.project.refactoring.history", Boolean.valueOf(this.fShareHistory.getSelection()).toString());
        }
        if (this.fManager != null) {
            try {
                this.fManager.applyChanges();
                RefactoringHistoryService service = RefactoringHistoryService.getInstance();
                boolean history = service.hasSharedRefactoringHistory(project);
                if (history != this.fHasProjectHistory && project != null) {
                    service.setSharedRefactoringHistory(project, history, null);
                }
            }
            catch (BackingStoreException exception) {
                RefactoringUIPlugin.log(exception);
            }
            catch (CoreException exception) {
                RefactoringUIPlugin.log(exception);
            }
        }
        return super.performOk();
    }

    private void setPreference(IWorkingCopyManager manager, IScopeContext context, String key, String value) {
        IEclipsePreferences preferences = this.getPreferences(manager, context);
        if (value != null) {
            preferences.put(key, value);
        } else {
            preferences.remove(key);
        }
    }

    public void setVisible(boolean visible) {
        this.fHasProjectHistory = this.hasSharedRefactoringHistory();
        super.setVisible(visible);
    }

    private class RefactoringDescriptorDeleteQuery
    implements IRefactoringDescriptorDeleteQuery {
        RefactoringDescriptorDeleteQuery() {
        }

        public RefactoringStatus proceed(RefactoringDescriptorProxy proxy) {
            Assert.isNotNull((Object)proxy);
            IPreferenceStore store = RefactoringUIPlugin.getDefault().getPreferenceStore();
            MessageDialogWithToggle dialog = null;
            if (!store.getBoolean(PREFERENCE_DO_NOT_WARN_DELETE)) {
                String project = proxy.getProject();
                dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)RefactoringPropertyPage.this.getShell(), (String)RefactoringUIMessages.RefactoringPropertyPage_confirm_delete_caption, (String)(project == null || "".equals(project) ? RefactoringUIMessages.RefactoringPropertyPage_confirm_delete_workspace_pattern : RefactoringUIMessages.RefactoringPropertyPage_confirm_delete_project_pattern), (String)RefactoringUIMessages.RefactoringHistoryWizard_do_not_show_message, (boolean)false, null, null);
                store.setValue(PREFERENCE_DO_NOT_WARN_DELETE, dialog.getToggleState());
            }
            if (dialog == null || dialog.getReturnCode() == 2) {
                return new RefactoringStatus();
            }
            return RefactoringStatus.createErrorStatus((String)IDialogConstants.NO_LABEL);
        }
    }
}

