/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.scripting;

import java.io.File;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPluginImages;
import org.eclipse.ltk.internal.ui.refactoring.history.SelectRefactoringHistoryControl;
import org.eclipse.ltk.internal.ui.refactoring.scripting.CreateRefactoringScriptWizard;
import org.eclipse.ltk.internal.ui.refactoring.scripting.ScriptingMessages;
import org.eclipse.ltk.internal.ui.refactoring.util.SWTUtil;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public final class CreateRefactoringScriptWizardPage
extends WizardPage {
    private static final String PAGE_NAME = "CreateRefactoringScriptWizardPage";
    private SelectRefactoringHistoryControl fHistoryControl = null;
    private Text fLocationField = null;
    private final CreateRefactoringScriptWizard fWizard;

    public CreateRefactoringScriptWizardPage(CreateRefactoringScriptWizard wizard) {
        super(PAGE_NAME);
        Assert.isNotNull((Object)((Object)wizard));
        this.fWizard = wizard;
        this.setTitle(ScriptingMessages.CreateRefactoringScriptWizard_title);
        this.setDescription(ScriptingMessages.CreateRefactoringScriptWizard_description);
        this.setImageDescriptor(RefactoringPluginImages.DESC_WIZBAN_REFACTOR);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.fHistoryControl = new SelectRefactoringHistoryControl(composite, new RefactoringHistoryControlConfiguration(null, true, true)){

            protected final void handleDeselectAll() {
                super.handleDeselectAll();
                CreateRefactoringScriptWizardPage.this.fWizard.setRefactoringDescriptors(EMPTY_DESCRIPTORS);
            }

            protected final void handleSelectAll() {
                super.handleSelectAll();
                RefactoringHistory history = this.getInput();
                if (history != null) {
                    CreateRefactoringScriptWizardPage.this.fWizard.setRefactoringDescriptors(history.getDescriptors());
                }
            }
        };
        this.fHistoryControl.createControl();
        this.fHistoryControl.setInput(this.fWizard.getRefactoringHistory());
        this.fHistoryControl.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                CreateRefactoringScriptWizardPage.this.fWizard.setRefactoringDescriptors(CreateRefactoringScriptWizardPage.this.fHistoryControl.getCheckedDescriptors());
            }
        });
        this.createLocationGroup(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.refactoring_create_script_page");
    }

    private GridData createGridData(int flag, int hspan, int indent) {
        GridData data = new GridData(flag);
        data.horizontalIndent = indent;
        data.horizontalSpan = hspan;
        return data;
    }

    private void createLocationGroup(Composite parent) {
        Assert.isNotNull((Object)parent);
        Label label = new Label(parent, 0);
        label.setText(ScriptingMessages.ApplyRefactoringScriptWizardPage_location_caption);
        GridData data = this.createGridData(40, 1, 0);
        data.verticalIndent = this.convertVerticalDLUsToPixels(4);
        label.setLayoutData((Object)data);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)this.createGridData(768, 6, 0));
        composite.setLayout((Layout)new GridLayout(3, false));
        label = new Label(composite, 0);
        label.setText(ScriptingMessages.ApplyRefactoringScriptWizardPage_location_label);
        data = this.createGridData(32, 1, 0);
        label.setLayoutData((Object)data);
        this.fLocationField = new Text(composite, 2052);
        this.fLocationField.setLayoutData((Object)this.createGridData(768, 1, 0));
        this.fLocationField.addModifyListener(new ModifyListener(){

            public final void modifyText(ModifyEvent event) {
                CreateRefactoringScriptWizardPage.this.handleLocationChanged();
            }
        });
        this.fLocationField.setFocus();
        Button button = new Button(composite, 8);
        button.setText(ScriptingMessages.ApplyRefactoringScriptWizardPage_browse_label);
        button.setLayoutData((Object)this.createGridData(256, 1, 0));
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                CreateRefactoringScriptWizardPage.this.handleBrowseButtonSelected();
            }
        });
        this.setPageComplete(false);
    }

    private void handleBrowseButtonSelected() {
        FileDialog file = new FileDialog(this.getShell(), 4096);
        file.setText(ScriptingMessages.CreateRefactoringScriptWizardPage_browse_caption);
        file.setFilterNames(new String[]{ScriptingMessages.ApplyRefactoringScriptWizardPage_filter_name_script, ScriptingMessages.ApplyRefactoringScriptWizardPage_filter_name_wildcard});
        file.setFilterExtensions(new String[]{ScriptingMessages.ApplyRefactoringScriptWizardPage_filter_extension_script, ScriptingMessages.ApplyRefactoringScriptWizardPage_filter_extension_wildcard});
        String path = file.open();
        if (path != null) {
            if (!path.endsWith(ScriptingMessages.CreateRefactoringScriptWizardPage_script_extension)) {
                path = String.valueOf(path) + ScriptingMessages.CreateRefactoringScriptWizardPage_script_extension;
            }
            this.fLocationField.setText(path);
        }
    }

    private void handleLocationChanged() {
        if (this.fLocationField != null) {
            String path = this.fLocationField.getText();
            if ("".equals(path)) {
                this.setErrorMessage(ScriptingMessages.ApplyRefactoringScriptWizardPage_invalid_location);
                this.setPageComplete(false);
                this.fWizard.setScriptLocation(null);
            } else {
                this.fWizard.setScriptLocation(new File(path).toURI());
                this.setErrorMessage(null);
                this.setPageComplete(true);
            }
        }
    }
}

