/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.ui.refactoring.history;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryCollection;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryDate;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryEntry;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryNode;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;

public class RefactoringHistoryContentProvider
implements ITreeContentProvider {
    private static final Object[] NO_ELEMENTS = new Object[0];
    private final RefactoringHistoryControlConfiguration fControlConfiguration;
    private RefactoringHistory fRefactoringHistory = null;
    private long[][] fRefactoringRoots = null;
    private long[] fRefactoringStamps = null;

    private static int getRefactoringRootKindIndex(long[][] structure, int kind) {
        int index = structure.length - 1;
        while (index >= 0) {
            if ((long)kind >= structure[index][1]) {
                return index;
            }
            --index;
        }
        return -1;
    }

    public RefactoringHistoryContentProvider(RefactoringHistoryControlConfiguration configuration) {
        Assert.isNotNull((Object)configuration);
        this.fControlConfiguration = configuration;
    }

    public void dispose() {
    }

    public Object[] getChildren(Object element) {
        if (element instanceof RefactoringHistoryNode && this.fRefactoringHistory != null) {
            RefactoringHistoryNode node = (RefactoringHistoryNode)element;
            RefactoringDescriptorProxy[] proxies = this.getRefactoringHistoryDescriptors();
            if (proxies != null && proxies.length > 0) {
                long[][] structure = this.getRefactoringRootStructure(proxies[0].getTimeStamp());
                int kind = node.getKind();
                switch (kind) {
                    case 11: {
                        return this.getRefactoringHistoryEntries(node);
                    }
                }
                if (node instanceof RefactoringHistoryDate) {
                    RefactoringHistoryDate date = (RefactoringHistoryDate)node;
                    Calendar calendar = Calendar.getInstance();
                    long stamp = date.getTimeStamp();
                    switch (kind) {
                        case 0: {
                            return this.getRefactoringHistoryEntries(node, stamp, Long.MAX_VALUE);
                        }
                        case 1: {
                            return this.getRefactoringHistoryEntries(node, stamp, structure[RefactoringHistoryContentProvider.getRefactoringRootKindIndex(structure, 0)][0] - 1L);
                        }
                        case 2: {
                            return this.getRefactoringHistoryDays(node, stamp, structure[RefactoringHistoryContentProvider.getRefactoringRootKindIndex(structure, 1)][0] - 1L);
                        }
                        case 3: {
                            return this.getRefactoringHistoryDays(node, stamp, structure[RefactoringHistoryContentProvider.getRefactoringRootKindIndex(structure, 2)][0] - 1L);
                        }
                        case 4: {
                            return this.getRefactoringHistoryWeeks(node, stamp, structure[RefactoringHistoryContentProvider.getRefactoringRootKindIndex(structure, 3)][0] - 1L);
                        }
                        case 5: {
                            return this.getRefactoringHistoryWeeks(node, stamp, structure[RefactoringHistoryContentProvider.getRefactoringRootKindIndex(structure, 4)][0] - 1L);
                        }
                        case 9: {
                            return this.getRefactoringHistoryEntries(node, stamp, stamp + 86400000L - 1L);
                        }
                        case 8: {
                            return this.getRefactoringHistoryDays(node, stamp, stamp + 604800000L - 1L);
                        }
                        case 7: {
                            calendar.setTimeInMillis(stamp);
                            calendar.add(2, 1);
                            return this.getRefactoringHistoryWeeks(node, stamp, calendar.getTimeInMillis() - 1L);
                        }
                        case 6: {
                            calendar.setTimeInMillis(stamp);
                            calendar.add(1, 1);
                            return this.getRefactoringHistoryMonths(node, stamp, calendar.getTimeInMillis() - 1L);
                        }
                    }
                }
            }
        } else if (element instanceof RefactoringHistory) {
            return this.getElements(element);
        }
        return NO_ELEMENTS;
    }

    public Object[] getElements(Object element) {
        if (element instanceof RefactoringHistory) {
            if (this.fControlConfiguration.isTimeDisplayed()) {
                return this.getRootElements();
            }
            if (this.fRefactoringHistory != null && !this.fRefactoringHistory.isEmpty()) {
                return new Object[]{new RefactoringHistoryCollection()};
            }
        }
        return NO_ELEMENTS;
    }

    public Object getParent(Object element) {
        if (element instanceof RefactoringHistoryNode) {
            RefactoringHistoryNode node = (RefactoringHistoryNode)element;
            return node.getParent();
        }
        return null;
    }

    private Object[] getRefactoringHistoryDays(RefactoringHistoryNode parent, long start, long end) {
        Assert.isTrue((start >= 0L ? 1 : 0) != 0);
        Assert.isTrue((end >= start ? 1 : 0) != 0);
        Calendar calendar = Calendar.getInstance();
        RefactoringDescriptorProxy[] proxies = this.getRefactoringHistoryDescriptors();
        int[] range = this.getRefactoringHistoryRange(start, end);
        ArrayList<RefactoringHistoryDate> list = new ArrayList<RefactoringHistoryDate>(proxies.length);
        int last = -1;
        int index = range[0];
        while (index <= range[1]) {
            long stamp = proxies[index].getTimeStamp();
            if (stamp >= 0L) {
                calendar.setTimeInMillis(stamp);
                int day = calendar.get(6);
                if (day != last) {
                    last = day;
                    calendar.set(14, 0);
                    calendar.set(13, 0);
                    calendar.set(12, 0);
                    calendar.set(11, 0);
                    list.add(new RefactoringHistoryDate(parent, calendar.getTimeInMillis(), 9));
                }
            }
            ++index;
        }
        return list.toArray();
    }

    private RefactoringDescriptorProxy[] getRefactoringHistoryDescriptors() {
        RefactoringDescriptorProxy[] proxies = this.fRefactoringHistory.getDescriptors();
        if (this.fRefactoringStamps == null) {
            int length = proxies.length;
            this.fRefactoringStamps = new long[length];
            int index = 0;
            while (index < length) {
                this.fRefactoringStamps[length - index - 1] = proxies[index].getTimeStamp();
                ++index;
            }
        }
        return proxies;
    }

    private Object[] getRefactoringHistoryEntries(RefactoringHistoryNode parent) {
        RefactoringDescriptorProxy[] proxies = this.getRefactoringHistoryDescriptors();
        ArrayList<RefactoringHistoryEntry> list = new ArrayList<RefactoringHistoryEntry>(proxies.length);
        int index = 0;
        while (index < proxies.length) {
            list.add(new RefactoringHistoryEntry(parent, proxies[index]));
            ++index;
        }
        return list.toArray();
    }

    private Object[] getRefactoringHistoryEntries(RefactoringHistoryNode parent, long start, long end) {
        Assert.isTrue((start >= 0L ? 1 : 0) != 0);
        Assert.isTrue((end >= start ? 1 : 0) != 0);
        RefactoringDescriptorProxy[] proxies = this.getRefactoringHistoryDescriptors();
        int[] range = this.getRefactoringHistoryRange(start, end);
        ArrayList<RefactoringHistoryEntry> list = new ArrayList<RefactoringHistoryEntry>(proxies.length);
        int index = range[0];
        while (index <= range[1]) {
            list.add(new RefactoringHistoryEntry(parent, proxies[index]));
            ++index;
        }
        return list.toArray();
    }

    private Object[] getRefactoringHistoryMonths(RefactoringHistoryNode parent, long start, long end) {
        Assert.isTrue((start >= 0L ? 1 : 0) != 0);
        Assert.isTrue((end >= start ? 1 : 0) != 0);
        Calendar calendar = Calendar.getInstance();
        RefactoringDescriptorProxy[] proxies = this.getRefactoringHistoryDescriptors();
        int[] range = this.getRefactoringHistoryRange(start, end);
        ArrayList<RefactoringHistoryDate> list = new ArrayList<RefactoringHistoryDate>(proxies.length);
        int last = -1;
        int index = range[0];
        while (index <= range[1]) {
            long stamp = proxies[index].getTimeStamp();
            if (stamp >= 0L) {
                calendar.setTimeInMillis(stamp);
                int month = calendar.get(2);
                if (month != last) {
                    last = month;
                    calendar.set(14, 0);
                    calendar.set(13, 0);
                    calendar.set(12, 0);
                    calendar.set(11, 0);
                    calendar.set(5, 1);
                    list.add(new RefactoringHistoryDate(parent, calendar.getTimeInMillis(), 7));
                }
            }
            ++index;
        }
        return list.toArray();
    }

    private int[] getRefactoringHistoryRange(long start, long end) {
        Assert.isTrue((start >= 0L ? 1 : 0) != 0);
        Assert.isTrue((end >= start ? 1 : 0) != 0);
        this.getRefactoringHistoryDescriptors();
        int[] range = new int[2];
        int left = Arrays.binarySearch(this.fRefactoringStamps, start);
        range[0] = left >= 0 ? left : Math.max(0, -left - 1);
        int right = Arrays.binarySearch(this.fRefactoringStamps, end);
        range[1] = right >= 0 ? right : -right - 2;
        int temp = this.fRefactoringStamps.length - range[1] - 1;
        range[1] = this.fRefactoringStamps.length - range[0] - 1;
        range[0] = temp;
        return range;
    }

    private Object[] getRefactoringHistoryWeeks(RefactoringHistoryNode parent, long start, long end) {
        Assert.isTrue((start >= 0L ? 1 : 0) != 0);
        Assert.isTrue((end >= start ? 1 : 0) != 0);
        Calendar calendar = Calendar.getInstance();
        RefactoringDescriptorProxy[] proxies = this.getRefactoringHistoryDescriptors();
        int[] range = this.getRefactoringHistoryRange(start, end);
        ArrayList<RefactoringHistoryDate> list = new ArrayList<RefactoringHistoryDate>(proxies.length);
        int last = -1;
        int index = range[0];
        while (index <= range[1]) {
            long stamp = proxies[index].getTimeStamp();
            if (stamp >= 0L) {
                calendar.setTimeInMillis(stamp);
                int week = calendar.get(3);
                if (week != last) {
                    last = week;
                    calendar.set(14, 0);
                    calendar.set(13, 0);
                    calendar.set(12, 0);
                    calendar.set(11, 0);
                    calendar.set(7, 2);
                    list.add(new RefactoringHistoryDate(parent, calendar.getTimeInMillis(), 8));
                }
            }
            ++index;
        }
        return list.toArray();
    }

    private long[][] getRefactoringRootStructure(long stamp) {
        if (this.fRefactoringRoots == null) {
            long time = System.currentTimeMillis();
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(time);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            int zoneOffset = calendar.get(15);
            int dstOffset = calendar.get(16);
            int count = 0;
            long[] thresholds = new long[32];
            int[] kinds = new int[32];
            thresholds[count] = calendar.getTimeInMillis();
            kinds[count] = 0;
            calendar.add(5, -1);
            thresholds[++count] = calendar.getTimeInMillis();
            kinds[count] = 1;
            ++count;
            int day = calendar.get(7);
            if (day != 1) {
                calendar.set(7, 2);
                thresholds[count] = calendar.getTimeInMillis();
                kinds[count] = 2;
                ++count;
                calendar.add(3, -1);
            }
            calendar.set(7, 2);
            thresholds[count] = calendar.getTimeInMillis();
            kinds[count] = 3;
            ++count;
            calendar.setTimeInMillis(time);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            calendar.set(5, 1);
            if (thresholds[count - 1] >= calendar.getTimeInMillis()) {
                thresholds[count] = calendar.getTimeInMillis();
                kinds[count] = 4;
                ++count;
            }
            calendar.add(2, -1);
            thresholds[count] = calendar.getTimeInMillis();
            kinds[count] = 5;
            ++count;
            int month = calendar.get(2);
            if (month != 0) {
                calendar.set(2, 0);
                thresholds[count] = calendar.getTimeInMillis();
                kinds[count] = 6;
                ++count;
            }
            if (stamp > 0L) {
                long localized = stamp + (long)zoneOffset + (long)dstOffset;
                calendar.set(2, 0);
                do {
                    calendar.add(1, -1);
                    thresholds[count] = calendar.getTimeInMillis();
                    kinds[count] = 6;
                    ++count;
                } while (calendar.getTimeInMillis() > localized);
            }
            long[][] result = new long[count - 1][2];
            int index = 0;
            while (index < count - 1) {
                result[index][0] = thresholds[index];
                result[index][1] = kinds[index];
                ++index;
            }
            this.fRefactoringRoots = result;
        }
        return this.fRefactoringRoots;
    }

    public final Object[] getRootElements() {
        RefactoringDescriptorProxy[] proxies;
        ArrayList<RefactoringHistoryDate> list = new ArrayList<RefactoringHistoryDate>();
        if (!this.fRefactoringHistory.isEmpty() && (proxies = this.getRefactoringHistoryDescriptors()) != null && proxies.length > 0) {
            long[][] structure = this.getRefactoringRootStructure(proxies[0].getTimeStamp());
            int begin = 0;
            long end = Long.MAX_VALUE;
            int index = 0;
            while (index < proxies.length) {
                long stamp = proxies[index].getTimeStamp();
                int offset = begin;
                while (offset < structure.length) {
                    long start = structure[offset][0];
                    if (stamp >= start && stamp <= end) {
                        list.add(new RefactoringHistoryDate(null, start, (int)structure[offset][1]));
                        begin = offset + 1;
                        end = start - 1L;
                        break;
                    }
                    ++offset;
                }
                ++index;
            }
        }
        return list.toArray();
    }

    public boolean hasChildren(Object element) {
        return !(element instanceof RefactoringHistoryEntry);
    }

    public void inputChanged(Viewer viewer, Object predecessor, Object successor) {
        if (predecessor == successor) {
            return;
        }
        this.fRefactoringHistory = successor instanceof RefactoringHistory ? (RefactoringHistory)successor : null;
        this.fRefactoringRoots = null;
        this.fRefactoringStamps = null;
    }
}

