/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.UFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;

public abstract class DateFormat
extends UFormat {
    protected Calendar calendar;
    protected NumberFormat numberFormat;
    public static final int ERA_FIELD = 0;
    public static final int YEAR_FIELD = 1;
    public static final int MONTH_FIELD = 2;
    public static final int DATE_FIELD = 3;
    public static final int HOUR_OF_DAY1_FIELD = 4;
    public static final int HOUR_OF_DAY0_FIELD = 5;
    public static final int MINUTE_FIELD = 6;
    public static final int SECOND_FIELD = 7;
    public static final int FRACTIONAL_SECOND_FIELD = 8;
    public static final int MILLISECOND_FIELD = 8;
    public static final int DAY_OF_WEEK_FIELD = 9;
    public static final int DAY_OF_YEAR_FIELD = 10;
    public static final int DAY_OF_WEEK_IN_MONTH_FIELD = 11;
    public static final int WEEK_OF_YEAR_FIELD = 12;
    public static final int WEEK_OF_MONTH_FIELD = 13;
    public static final int AM_PM_FIELD = 14;
    public static final int HOUR1_FIELD = 15;
    public static final int HOUR0_FIELD = 16;
    public static final int TIMEZONE_FIELD = 17;
    public static final int YEAR_WOY_FIELD = 18;
    public static final int DOW_LOCAL_FIELD = 19;
    public static final int EXTENDED_YEAR_FIELD = 20;
    public static final int JULIAN_DAY_FIELD = 21;
    public static final int MILLISECONDS_IN_DAY_FIELD = 22;
    public static final int TIMEZONE_RFC_FIELD = 23;
    public static final int TIMEZONE_GENERIC_FIELD = 24;
    public static final int STANDALONE_DAY_FIELD = 25;
    public static final int STANDALONE_MONTH_FIELD = 26;
    public static final int FIELD_COUNT = 27;
    private static final long serialVersionUID = 7218322306649953788L;
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    public static final int DEFAULT = 2;

    public final StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        if (obj instanceof Calendar) {
            return this.format((Calendar)obj, toAppendTo, fieldPosition);
        }
        if (obj instanceof Date) {
            return this.format((Date)obj, toAppendTo, fieldPosition);
        }
        if (obj instanceof Number) {
            return this.format(new Date(((Number)obj).longValue()), toAppendTo, fieldPosition);
        }
        throw new IllegalArgumentException("Cannot format given Object as a Date");
    }

    public abstract StringBuffer format(Calendar var1, StringBuffer var2, FieldPosition var3);

    public final StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        this.calendar.setTime(date);
        return this.format(this.calendar, toAppendTo, fieldPosition);
    }

    public final String format(Date date) {
        return this.format(date, new StringBuffer(64), new FieldPosition(0)).toString();
    }

    public Date parse(String text) throws ParseException {
        ParsePosition pos = new ParsePosition(0);
        Date result = this.parse(text, pos);
        if (pos.getIndex() == 0) {
            throw new ParseException("Unparseable date: \"" + text + "\"", pos.getErrorIndex());
        }
        return result;
    }

    public abstract void parse(String var1, Calendar var2, ParsePosition var3);

    public final Date parse(String text, ParsePosition pos) {
        int start = pos.getIndex();
        this.calendar.clear();
        this.parse(text, this.calendar, pos);
        if (pos.getIndex() != start) {
            try {
                return this.calendar.getTime();
            }
            catch (IllegalArgumentException e) {
                pos.setIndex(start);
                pos.setErrorIndex(start);
            }
        }
        return null;
    }

    public Object parseObject(String source, ParsePosition pos) {
        return this.parse(source, pos);
    }

    public static final DateFormat getTimeInstance() {
        return DateFormat.get(-1, 2, ULocale.getDefault());
    }

    public static final DateFormat getTimeInstance(int style) {
        return DateFormat.get(-1, style, ULocale.getDefault());
    }

    public static final DateFormat getTimeInstance(int style, Locale aLocale) {
        return DateFormat.get(-1, style, ULocale.forLocale(aLocale));
    }

    public static final DateFormat getTimeInstance(int style, ULocale locale) {
        return DateFormat.get(-1, style, locale);
    }

    public static final DateFormat getDateInstance() {
        return DateFormat.get(2, -1, ULocale.getDefault());
    }

    public static final DateFormat getDateInstance(int style) {
        return DateFormat.get(style, -1, ULocale.getDefault());
    }

    public static final DateFormat getDateInstance(int style, Locale aLocale) {
        return DateFormat.get(style, -1, ULocale.forLocale(aLocale));
    }

    public static final DateFormat getDateInstance(int style, ULocale locale) {
        return DateFormat.get(style, -1, locale);
    }

    public static final DateFormat getDateTimeInstance() {
        return DateFormat.get(2, 2, ULocale.getDefault());
    }

    public static final DateFormat getDateTimeInstance(int dateStyle, int timeStyle) {
        return DateFormat.get(dateStyle, timeStyle, ULocale.getDefault());
    }

    public static final DateFormat getDateTimeInstance(int dateStyle, int timeStyle, Locale aLocale) {
        return DateFormat.get(dateStyle, timeStyle, ULocale.forLocale(aLocale));
    }

    public static final DateFormat getDateTimeInstance(int dateStyle, int timeStyle, ULocale locale) {
        return DateFormat.get(dateStyle, timeStyle, locale);
    }

    public static final DateFormat getInstance() {
        return DateFormat.getDateTimeInstance(3, 3);
    }

    public static Locale[] getAvailableLocales() {
        return ICUResourceBundle.getAvailableLocales("com/ibm/icu/impl/data/icudt35b");
    }

    public static ULocale[] getAvailableULocales() {
        return ICUResourceBundle.getAvailableULocales("com/ibm/icu/impl/data/icudt35b");
    }

    public void setCalendar(Calendar newCalendar) {
        this.calendar = newCalendar;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void setNumberFormat(NumberFormat newNumberFormat) {
        this.numberFormat = newNumberFormat;
        this.numberFormat.setParseIntegerOnly(true);
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public void setTimeZone(TimeZone zone) {
        this.calendar.setTimeZone(zone);
    }

    public TimeZone getTimeZone() {
        return this.calendar.getTimeZone();
    }

    public void setLenient(boolean lenient) {
        this.calendar.setLenient(lenient);
    }

    public boolean isLenient() {
        return this.calendar.isLenient();
    }

    public int hashCode() {
        return this.numberFormat.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DateFormat other = (DateFormat)obj;
        return this.calendar.isEquivalentTo(other.calendar) && this.numberFormat.equals(other.numberFormat);
    }

    public Object clone() {
        DateFormat other = (DateFormat)super.clone();
        other.calendar = (Calendar)this.calendar.clone();
        other.numberFormat = (NumberFormat)this.numberFormat.clone();
        return other;
    }

    private static DateFormat get(int dateStyle, int timeStyle, ULocale loc) {
        if (timeStyle < -1 || timeStyle > 3) {
            throw new IllegalArgumentException("Illegal time style " + timeStyle);
        }
        if (dateStyle < -1 || dateStyle > 3) {
            throw new IllegalArgumentException("Illegal date style " + dateStyle);
        }
        try {
            Calendar cal = Calendar.getInstance(loc);
            DateFormat result = cal.getDateTimeFormat(dateStyle, timeStyle, loc);
            result.setLocale(cal.getLocale(ULocale.VALID_LOCALE), cal.getLocale(ULocale.ACTUAL_LOCALE));
            return result;
        }
        catch (MissingResourceException e) {
            return new SimpleDateFormat("M/d/yy h:mm a");
        }
    }

    protected DateFormat() {
    }

    public static final DateFormat getDateInstance(Calendar cal, int dateStyle, Locale locale) {
        return DateFormat.getDateTimeInstance(cal, dateStyle, -1, ULocale.forLocale(locale));
    }

    public static final DateFormat getDateInstance(Calendar cal, int dateStyle, ULocale locale) {
        return DateFormat.getDateTimeInstance(cal, dateStyle, -1, locale);
    }

    public static final DateFormat getTimeInstance(Calendar cal, int timeStyle, Locale locale) {
        return DateFormat.getDateTimeInstance(cal, -1, timeStyle, ULocale.forLocale(locale));
    }

    public static final DateFormat getTimeInstance(Calendar cal, int timeStyle, ULocale locale) {
        return DateFormat.getDateTimeInstance(cal, -1, timeStyle, locale);
    }

    public static final DateFormat getDateTimeInstance(Calendar cal, int dateStyle, int timeStyle, Locale locale) {
        return cal.getDateTimeFormat(dateStyle, timeStyle, ULocale.forLocale(locale));
    }

    public static final DateFormat getDateTimeInstance(Calendar cal, int dateStyle, int timeStyle, ULocale locale) {
        return cal.getDateTimeFormat(dateStyle, timeStyle, locale);
    }

    public static final DateFormat getInstance(Calendar cal, Locale locale) {
        return DateFormat.getDateTimeInstance(cal, 3, 3, ULocale.forLocale(locale));
    }

    public static final DateFormat getInstance(Calendar cal, ULocale locale) {
        return DateFormat.getDateTimeInstance(cal, 3, 3, locale);
    }

    public static final DateFormat getInstance(Calendar cal) {
        return DateFormat.getInstance(cal, ULocale.getDefault());
    }

    public static final DateFormat getDateInstance(Calendar cal, int dateStyle) {
        return DateFormat.getDateInstance(cal, dateStyle, ULocale.getDefault());
    }

    public static final DateFormat getTimeInstance(Calendar cal, int timeStyle) {
        return DateFormat.getTimeInstance(cal, timeStyle, ULocale.getDefault());
    }

    public static final DateFormat getDateTimeInstance(Calendar cal, int dateStyle, int timeStyle) {
        return DateFormat.getDateTimeInstance(cal, dateStyle, timeStyle, ULocale.getDefault());
    }
}

