/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.internal.ITocsChangedListener;
import org.eclipse.help.internal.context.ContextManager;
import org.eclipse.help.internal.index.IndexManager;
import org.eclipse.help.internal.toc.TocManager;
import org.eclipse.help.internal.util.ResourceLocator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class HelpPlugin
extends Plugin
implements IRegistryChangeListener,
BundleListener {
    public static final String PLUGIN_ID = "org.eclipse.help";
    public static boolean DEBUG = false;
    public static boolean DEBUG_CONTEXT = false;
    public static boolean DEBUG_PROTOCOLS = false;
    protected static HelpPlugin plugin;
    private List tocsChangedListeners = new Vector();
    public static final String BASE_TOCS_KEY = "baseTOCS";
    public static final String IGNORED_TOCS_KEY = "ignoredTOCS";
    protected TocManager tocManager;
    protected static Object tocManagerCreateLock;
    protected ContextManager contextManager;
    protected IndexManager indexManager;

    static {
        tocManagerCreateLock = new Object();
    }

    public static synchronized void logError(String message, Throwable ex) {
        if (message == null) {
            message = "";
        }
        Status errorStatus = new Status(4, PLUGIN_ID, 0, message, ex);
        HelpPlugin.logStatus((IStatus)errorStatus);
    }

    private static void logStatus(IStatus errorStatus) {
        HelpPlugin.getDefault().getLog().log(errorStatus);
    }

    public static synchronized void logWarning(String message) {
        if (DEBUG) {
            if (message == null) {
                message = "";
            }
            Status warningStatus = new Status(2, PLUGIN_ID, 0, message, null);
            HelpPlugin.getDefault().getLog().log((IStatus)warningStatus);
        }
    }

    public static HelpPlugin getDefault() {
        return plugin;
    }

    public void stop(BundleContext context) throws Exception {
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
        context.removeBundleListener((BundleListener)this);
        plugin = null;
        super.stop(context);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        context.addBundleListener((BundleListener)this);
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this, PLUGIN_ID);
        DEBUG = this.isDebugging();
        if (DEBUG) {
            DEBUG_CONTEXT = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.help/debug/context"));
            DEBUG_PROTOCOLS = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.help/debug/protocols"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TocManager getTocManager() {
        if (HelpPlugin.getDefault().tocManager == null) {
            Object object = tocManagerCreateLock;
            synchronized (object) {
                if (HelpPlugin.getDefault().tocManager == null) {
                    HelpPlugin.getDefault().tocManager = new TocManager();
                }
            }
        }
        return HelpPlugin.getDefault().tocManager;
    }

    public static ContextManager getContextManager() {
        if (HelpPlugin.getDefault().contextManager == null) {
            HelpPlugin.getDefault().contextManager = new ContextManager();
        }
        return HelpPlugin.getDefault().contextManager;
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas(PLUGIN_ID, "toc");
        if (deltas.length > 0) {
            this.tocManager = null;
        }
        if (deltas.length > 0) {
            Iterator it = this.tocsChangedListeners.iterator();
            while (it.hasNext()) {
                ((ITocsChangedListener)it.next()).tocsChanged();
            }
        }
    }

    public void addTocsChangedListener(ITocsChangedListener listener) {
        if (!this.tocsChangedListeners.contains(listener)) {
            this.tocsChangedListeners.add(listener);
        }
    }

    public void removeTocsChangedListener(ITocsChangedListener listener) {
        this.tocsChangedListeners.remove(listener);
    }

    public void bundleChanged(BundleEvent event) {
        int type = event.getType();
        if (type == 32 || type == 64) {
            ResourceLocator.clearZipCache();
        }
    }

    public static IndexManager getIndexManager() {
        if (HelpPlugin.getDefault().indexManager == null) {
            HelpPlugin.getDefault().indexManager = new IndexManager();
        }
        return HelpPlugin.getDefault().indexManager;
    }
}

