/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.updatables;

import org.eclipse.jface.databinding.ChangeEvent;
import org.eclipse.jface.databinding.IChangeListener;
import org.eclipse.jface.databinding.IDataBindingContext;
import org.eclipse.jface.databinding.IUpdatable;
import org.eclipse.jface.databinding.UpdatableValue;

public abstract class CalculatedValue
extends UpdatableValue {
    private Class valueType;
    private Object calculatedResult = null;
    private boolean modifying = false;
    private final IChangeListener updatableChangeListener = new IChangeListener(){

        public void handleChange(ChangeEvent changeEvent) {
            CalculatedValue.this.handleChange();
        }
    };
    private IUpdatable[] dependantUpdatableValues;
    private boolean selfMadeUpdatables;

    public CalculatedValue(Class valueType) {
        this.valueType = valueType;
        this.handleChange();
    }

    public void setValue(Object value) {
        throw new UnsupportedOperationException("CalculatedUpdatableValue objects are read-only");
    }

    public Class getValueType() {
        return this.valueType;
    }

    public Object computeValue() {
        return this.calculatedResult;
    }

    protected abstract Object calculate();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleChange() {
        if (this.modifying) return;
        this.modifying = true;
        try {
            Object oldValue = this.calculatedResult;
            this.calculatedResult = this.calculate();
            this.fireChangeEvent(1, oldValue, this.calculatedResult);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.modifying = false;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.modifying = false;
            return;
        }
    }

    public IChangeListener getUpdatableChangeListener() {
        return this.updatableChangeListener;
    }

    public void setDependencies(IUpdatable[] values) {
        this.unhookDependantUpdatableValues();
        this.dependantUpdatableValues = values;
        this.hookDependantUpdatableValues();
        this.selfMadeUpdatables = false;
    }

    protected IUpdatable[] getDependantUpdatableValues() {
        return this.dependantUpdatableValues;
    }

    private void unhookDependantUpdatableValues() {
        if (this.dependantUpdatableValues == null) {
            return;
        }
        int i = 0;
        while (i < this.dependantUpdatableValues.length) {
            this.dependantUpdatableValues[i].removeChangeListener(this.getUpdatableChangeListener());
            if (this.selfMadeUpdatables) {
                this.dependantUpdatableValues[i].dispose();
            }
            ++i;
        }
        this.dependantUpdatableValues = null;
    }

    private void hookDependantUpdatableValues() {
        int i = 0;
        while (i < this.dependantUpdatableValues.length) {
            this.dependantUpdatableValues[i].addChangeListener(this.getUpdatableChangeListener());
            ++i;
        }
    }

    public void setDependencies(IDataBindingContext dbc, Object[] descriptionObjects) {
        IUpdatable[] values = this.convertToUpdatables(dbc, descriptionObjects);
        this.setDependencies(values);
        this.selfMadeUpdatables = true;
    }

    private IUpdatable[] convertToUpdatables(IDataBindingContext dbc, Object[] objects) {
        IUpdatable[] result = new IUpdatable[objects.length];
        int i = 0;
        while (i < objects.length) {
            result[i] = dbc.createUpdatable(objects[i]);
            ++i;
        }
        return result;
    }

    public void dispose() {
        this.unhookDependantUpdatableValues();
        super.dispose();
    }
}

