/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.viewers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import org.eclipse.jface.databinding.viewers.TableViewerDescription;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.Item;

public class DefaultCellModifier
implements ICellModifier {
    private TableViewerDescription tableViewerDescription;

    public DefaultCellModifier(TableViewerDescription tableViewerDescription) {
        this.tableViewerDescription = tableViewerDescription;
    }

    private TableViewerDescription.Column findColumn(String property) {
        int i = 0;
        while (i < this.tableViewerDescription.getColumnCount()) {
            TableViewerDescription.Column column = this.tableViewerDescription.getColumn(i);
            if (column.getPropertyName().equals(property)) {
                return column;
            }
            ++i;
        }
        return null;
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        TableViewerDescription.Column column = this.findColumn(property);
        if (column == null) {
            return null;
        }
        try {
            Method getter = element.getClass().getMethod("get" + property.substring(0, 1).toUpperCase(Locale.ENGLISH) + property.substring(1), new Class[0]);
            return getter.invoke(element, new Object[0]);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return null;
    }

    public void modify(Object element, String property, Object value) {
        TableViewerDescription.Column column = this.findColumn(property);
        if (column == null) {
            return;
        }
        if (element instanceof Item) {
            element = ((Item)element).getData();
        }
        try {
            Method setter = element.getClass().getMethod("set" + property.substring(0, 1).toUpperCase(Locale.ENGLISH) + property.substring(1), column.getConverter().getTargetType());
            setter.invoke(element, value);
            return;
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
    }
}

