/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding;

import org.eclipse.jface.databinding.ChangeEvent;
import org.eclipse.jface.databinding.IChangeListener;
import org.eclipse.jface.databinding.IDataBindingContext;
import org.eclipse.jface.databinding.INestedUpdatableValue;
import org.eclipse.jface.databinding.IUpdatableValue;
import org.eclipse.jface.databinding.Property;
import org.eclipse.jface.databinding.UpdatableValue;
import org.eclipse.jface.util.Assert;

public class NestedUpdatableValue
extends UpdatableValue
implements INestedUpdatableValue {
    private boolean updating = false;
    private IChangeListener innerChangeListener = new IChangeListener(){

        public void handleChange(ChangeEvent changeEvent) {
            if (!NestedUpdatableValue.this.updating) {
                NestedUpdatableValue.this.fireChangeEvent(changeEvent.getChangeType(), changeEvent.getOldValue(), changeEvent.getNewValue());
            }
        }
    };
    private Object currentOuterValue;
    private Object feature;
    private IUpdatableValue innerUpdatableValue;
    private IDataBindingContext databindingContext;
    private Class featureType;
    private IUpdatableValue outerUpdatableValue;
    IChangeListener outerChangeListener = new IChangeListener(){

        public void handleChange(ChangeEvent changeEvent) {
            if (changeEvent.getChangeType() == 1) {
                Object oldValue = NestedUpdatableValue.this.computeValue();
                NestedUpdatableValue.this.updateInnerUpdatableValue(NestedUpdatableValue.this.outerUpdatableValue);
                NestedUpdatableValue.this.fireChangeEvent(1, oldValue, NestedUpdatableValue.this.computeValue());
            }
        }
    };

    public NestedUpdatableValue(IDataBindingContext databindingContext, IUpdatableValue outerUpdatableValue, Object feature, Class featureType) {
        this.databindingContext = databindingContext;
        this.feature = feature;
        this.featureType = featureType;
        this.outerUpdatableValue = outerUpdatableValue;
        this.updateInnerUpdatableValue(outerUpdatableValue);
        outerUpdatableValue.addChangeListener(this.outerChangeListener);
    }

    private void updateInnerUpdatableValue(IUpdatableValue outerUpdatableValue) {
        this.currentOuterValue = outerUpdatableValue.getValue();
        if (this.innerUpdatableValue != null) {
            this.innerUpdatableValue.removeChangeListener(this.innerChangeListener);
            this.innerUpdatableValue.dispose();
        }
        if (this.currentOuterValue == null) {
            this.innerUpdatableValue = null;
        } else {
            this.innerUpdatableValue = (IUpdatableValue)this.databindingContext.createUpdatable(new Property(this.currentOuterValue, this.feature));
            Class innerValueType = this.innerUpdatableValue.getValueType();
            if (this.featureType == null) {
                this.featureType = innerValueType;
            } else {
                Assert.isTrue((boolean)this.featureType.equals(innerValueType), (String)"Cannot change value type in a nested updatable value");
            }
            this.innerUpdatableValue.addChangeListener(this.innerChangeListener);
        }
    }

    public void setValue(Object value) {
        if (this.innerUpdatableValue != null) {
            this.innerUpdatableValue.setValue(value);
        }
    }

    public Object computeValue() {
        return this.innerUpdatableValue == null ? null : this.innerUpdatableValue.getValue();
    }

    public Class getValueType() {
        return this.featureType;
    }

    public void dispose() {
        super.dispose();
        if (this.outerUpdatableValue != null) {
            this.outerUpdatableValue.removeChangeListener(this.outerChangeListener);
            this.outerUpdatableValue.dispose();
        }
        if (this.innerUpdatableValue != null) {
            this.innerUpdatableValue.removeChangeListener(this.innerChangeListener);
            this.innerUpdatableValue.dispose();
        }
        this.currentOuterValue = null;
        this.databindingContext = null;
        this.feature = null;
        this.innerUpdatableValue = null;
        this.innerChangeListener = null;
    }

    public IUpdatableValue getInnerUpdatableValue() {
        return this.innerUpdatableValue;
    }

    public IUpdatableValue getOuterUpdatableValue() {
        return this.outerUpdatableValue;
    }
}

