/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.WorkbenchPlugin;

class StartupProgressMonitor
implements IProgressMonitor {
    private static boolean progressMonitorReturned = false;
    private double sumWorked = 0.0;
    private int totalWork;
    private int lastReportedWork = -1;
    private AsynchronousPrinter printer;

    static IProgressMonitor getInstance() {
        OutputStream outputStream;
        if (!progressMonitorReturned && (outputStream = WorkbenchPlugin.getDefault().getSplashStream()) != null) {
            progressMonitorReturned = true;
            return new StartupProgressMonitor(outputStream);
        }
        return null;
    }

    private StartupProgressMonitor(OutputStream os) {
        this.printer = new AsynchronousPrinter(os);
    }

    private void reportWork(int value) {
        if (this.lastReportedWork != value) {
            this.printer.println("value=" + value);
            this.printer.flush();
            this.lastReportedWork = value;
        }
    }

    public void beginTask(String name, int total) {
        this.totalWork = total;
        this.printer.start();
        this.printInitializationData();
    }

    private void printInitializationData() {
        int foregroundColorInteger;
        String progressRect = null;
        String messageRect = null;
        String foregroundColor = null;
        IProduct product = Platform.getProduct();
        if (product != null) {
            progressRect = product.getProperty("startupProgressRect");
            messageRect = product.getProperty("startupMessageRect");
            foregroundColor = product.getProperty("startupForegroundColor");
        }
        if (progressRect == null) {
            progressRect = "10,10,300,15";
        }
        if (messageRect == null) {
            messageRect = "10,35,300,15";
        }
        try {
            foregroundColorInteger = Integer.parseInt(foregroundColor, 16);
        }
        catch (Exception exception) {
            foregroundColorInteger = 13817855;
        }
        this.printer.println("foreground=" + foregroundColorInteger);
        this.printer.println("messageRect=" + messageRect);
        this.printer.println("progressRect=" + progressRect);
        this.printer.println("maximum=" + this.totalWork);
        this.printer.flush();
    }

    public void done() {
        if (this.lastReportedWork < this.totalWork) {
            this.reportWork(this.totalWork);
        }
        this.printer.close();
    }

    public void internalWorked(double work) {
        if (work == 0.0) {
            return;
        }
        this.sumWorked += work;
        if (this.sumWorked > (double)this.totalWork) {
            this.sumWorked = this.totalWork;
        }
        if (this.sumWorked < 0.0) {
            this.sumWorked = 0.0;
        }
        this.reportWork((int)this.sumWorked);
    }

    public boolean isCanceled() {
        return false;
    }

    public void setCanceled(boolean value) {
    }

    public void setTaskName(String name) {
    }

    public void subTask(String name) {
        this.printer.println("message=" + name.replace('\n', ' '));
        this.printer.flush();
    }

    public void worked(int work) {
        this.internalWorked(work);
    }

    private class AsynchronousPrinter
    extends Thread {
        private PrintStream printStream;
        private LinkedList tasks = new LinkedList();

        AsynchronousPrinter(OutputStream stream) {
            this.printStream = new PrintStream(stream, false);
            this.setName("Startup Progress Printer");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Object task;
                LinkedList linkedList = this.tasks;
                synchronized (linkedList) {
                    while (this.tasks.isEmpty()) {
                        try {
                            this.tasks.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                    task = this.tasks.removeFirst();
                }
                if (task == null) {
                    this.printStream.close();
                    return;
                }
                if ("".equals(task)) {
                    this.printStream.flush();
                    continue;
                }
                this.printStream.print(String.valueOf(task.toString()) + "\n");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addTask(Object o) {
            LinkedList linkedList = this.tasks;
            synchronized (linkedList) {
                this.tasks.addLast(o);
                this.tasks.notifyAll();
            }
        }

        void println(String string) {
            this.addTask(string);
        }

        void flush() {
            this.addTask("");
        }

        void close() {
            this.addTask(null);
        }
    }
}

