/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.expressions;

import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.util.Util;

public final class ActivePartExpression
extends Expression {
    private final IWorkbenchPart activePart;

    public ActivePartExpression(IWorkbenchPart activePart) {
        if (activePart == null) {
            throw new NullPointerException("The active part must not be null");
        }
        this.activePart = activePart;
    }

    public final void collectExpressionInfo(ExpressionInfo info) {
        info.addVariableNameAccess("activePart");
    }

    public final EvaluationResult evaluate(IEvaluationContext context) {
        Object variable = context.getVariable("activePart");
        if (Util.equals(this.activePart, variable)) {
            return EvaluationResult.TRUE;
        }
        return EvaluationResult.FALSE;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ActivePartExpression(");
        buffer.append(this.activePart);
        buffer.append(')');
        return buffer.toString();
    }
}

