/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.util.Tracing;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.internal.misc.Policy;
import org.eclipse.ui.internal.services.ExpressionAuthority;

final class HandlerAuthority
extends ExpressionAuthority {
    private static final int ACTIVATIONS_BY_SOURCE_SIZE = 256;
    private static final int ACTIVATIONS_TO_RECOMPUTE_SIZE = 1024;
    private static final boolean DEBUG = Policy.DEBUG_HANDLERS;
    private static final boolean DEBUG_PERFORMANCE = Policy.DEBUG_HANDLERS_PERFORMANCE;
    private static final boolean DEBUG_VERBOSE = Policy.DEBUG_HANDLERS && Policy.DEBUG_HANDLERS_VERBOSE;
    private static final String DEBUG_VERBOSE_COMMAND_ID = Policy.DEBUG_HANDLERS_VERBOSE_COMMAND_ID;
    private static final String TRACING_COMPONENT = "HANDLERS";
    private final Set[] activationsBySourcePriority = new Set[33];
    private final ICommandService commandService;
    private final Map handlerActivationsByCommandId = new HashMap();

    HandlerAuthority(ICommandService commandService) {
        if (commandService == null) {
            throw new NullPointerException("The handler authority needs a command service");
        }
        this.commandService = commandService;
    }

    final void activateHandler(IHandlerActivation activation) {
        ArrayList<IHandlerActivation> handlerActivations;
        String commandId = activation.getCommandId();
        Object value = this.handlerActivationsByCommandId.get(commandId);
        if (value instanceof Collection) {
            handlerActivations = (ArrayList<IHandlerActivation>)value;
            if (!handlerActivations.contains(activation)) {
                handlerActivations.add(activation);
                this.updateCommand(commandId, this.resolveConflicts(commandId, handlerActivations));
            }
        } else if (value instanceof IHandlerActivation) {
            if (value != activation) {
                handlerActivations = new ArrayList<IHandlerActivation>(2);
                handlerActivations.add((IHandlerActivation)value);
                handlerActivations.add(activation);
                this.handlerActivationsByCommandId.put(commandId, handlerActivations);
                this.updateCommand(commandId, this.resolveConflicts(commandId, handlerActivations));
            }
        } else {
            this.handlerActivationsByCommandId.put(commandId, activation);
            this.updateCommand(commandId, this.evaluate(activation) ? activation : null);
        }
        int sourcePriority = activation.getSourcePriority();
        int i = 1;
        while (i <= 32) {
            if ((sourcePriority & 1 << i) != 0) {
                HashSet<IHandlerActivation> activations = this.activationsBySourcePriority[i];
                if (activations == null) {
                    this.activationsBySourcePriority[i] = activations = new HashSet<IHandlerActivation>(256);
                }
                activations.add(activation);
            }
            ++i;
        }
    }

    final void deactivateHandler(IHandlerActivation activation) {
        String commandId = activation.getCommandId();
        Object value = this.handlerActivationsByCommandId.get(commandId);
        if (value instanceof Collection) {
            Collection handlerActivations = (Collection)value;
            if (handlerActivations.contains(activation)) {
                handlerActivations.remove(activation);
                if (handlerActivations.isEmpty()) {
                    this.handlerActivationsByCommandId.remove(commandId);
                    this.updateCommand(commandId, null);
                } else if (handlerActivations.size() == 1) {
                    IHandlerActivation remainingActivation = (IHandlerActivation)handlerActivations.iterator().next();
                    this.handlerActivationsByCommandId.put(commandId, remainingActivation);
                    this.updateCommand(commandId, this.evaluate(remainingActivation) ? remainingActivation : null);
                } else {
                    this.updateCommand(commandId, this.resolveConflicts(commandId, handlerActivations));
                }
            }
        } else if (value instanceof IHandlerActivation && value == activation) {
            this.handlerActivationsByCommandId.remove(commandId);
            this.updateCommand(commandId, null);
        }
        int sourcePriority = activation.getSourcePriority();
        int i = 1;
        while (i <= 32) {
            Set activations;
            if ((sourcePriority & 1 << i) != 0 && (activations = this.activationsBySourcePriority[i]) != null) {
                activations.remove(activation);
                if (activations.isEmpty()) {
                    this.activationsBySourcePriority[i] = null;
                }
            }
            ++i;
        }
    }

    final Shell getActiveShell() {
        return (Shell)this.getVariable("activeShell");
    }

    private final IHandlerActivation resolveConflicts(String commandId, Collection activations) {
        if (activations.isEmpty()) {
            return null;
        }
        Iterator activationItr = activations.iterator();
        IHandlerActivation bestActivation = (IHandlerActivation)activationItr.next();
        if (!this.evaluate(bestActivation)) {
            bestActivation = null;
        }
        boolean conflict = false;
        while (activationItr.hasNext()) {
            IHandlerActivation currentActivation = (IHandlerActivation)activationItr.next();
            if (!this.evaluate(currentActivation)) continue;
            if (bestActivation == null) {
                bestActivation = currentActivation;
                conflict = false;
                continue;
            }
            int comparison = bestActivation.compareTo(currentActivation);
            if (comparison > 0) {
                bestActivation = currentActivation;
                conflict = false;
                continue;
            }
            if (comparison != 0 || currentActivation.getHandler() == bestActivation.getHandler()) continue;
            conflict = true;
        }
        if (DEBUG) {
            if (conflict) {
                Tracing.printTrace((String)TRACING_COMPONENT, (String)("Unresolved conflict detected for '" + commandId + '\''));
            } else if (bestActivation != null && DEBUG_VERBOSE && (DEBUG_VERBOSE_COMMAND_ID == null || DEBUG_VERBOSE_COMMAND_ID.equals(commandId))) {
                Tracing.printTrace((String)TRACING_COMPONENT, (String)"Resolved conflict detected.  The following activation won: ");
                Tracing.printTrace((String)TRACING_COMPONENT, (String)("    " + bestActivation));
            }
        }
        if (conflict) {
            return null;
        }
        return bestActivation;
    }

    protected final void sourceChanged(int sourcePriority) {
        long startTime = 0L;
        if (DEBUG_PERFORMANCE) {
            startTime = System.currentTimeMillis();
        }
        HashSet activationsToRecompute = new HashSet(1024);
        int i = 1;
        while (i <= 32) {
            Set activations;
            if ((sourcePriority & 1 << i) != 0 && (activations = this.activationsBySourcePriority[i]) != null) {
                Iterator activationItr = activations.iterator();
                while (activationItr.hasNext()) {
                    activationsToRecompute.add(activationItr.next());
                }
            }
            ++i;
        }
        ArrayList<String> changedCommandIds = new ArrayList<String>(activationsToRecompute.size());
        Iterator activationItr = activationsToRecompute.iterator();
        while (activationItr.hasNext()) {
            IHandlerActivation activation = (IHandlerActivation)activationItr.next();
            boolean currentActive = this.evaluate(activation);
            activation.clearResult();
            boolean newActive = this.evaluate(activation);
            if (newActive == currentActive) continue;
            changedCommandIds.add(activation.getCommandId());
        }
        Iterator changedCommandIdItr = changedCommandIds.iterator();
        while (changedCommandIdItr.hasNext()) {
            IHandlerActivation activation;
            String commandId = (String)changedCommandIdItr.next();
            Object value = this.handlerActivationsByCommandId.get(commandId);
            if (value instanceof IHandlerActivation) {
                activation = (IHandlerActivation)value;
                this.updateCommand(commandId, this.evaluate(activation) ? activation : null);
                continue;
            }
            if (value instanceof Collection) {
                activation = this.resolveConflicts(commandId, (Collection)value);
                this.updateCommand(commandId, activation);
                continue;
            }
            this.updateCommand(commandId, null);
        }
        if (DEBUG_PERFORMANCE) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            int size = activationsToRecompute.size();
            if (size > 0) {
                Tracing.printTrace((String)TRACING_COMPONENT, (String)(String.valueOf(size) + " activations recomputed in " + elapsedTime + "ms"));
            }
        }
    }

    private final void updateCommand(String commandId, IHandlerActivation activation) {
        Command command = this.commandService.getCommand(commandId);
        if (activation == null) {
            command.setHandler(null);
        } else {
            command.setHandler(activation.getHandler());
        }
    }

    final void updateShellKludge() {
        this.updateCurrentState();
        this.sourceChanged(1024);
    }
}

