/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.State;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.jface.bindings.keys.IKeyLookup;
import org.eclipse.jface.bindings.keys.KeyBinding;
import org.eclipse.jface.bindings.keys.KeyLookupFactory;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.commands.RadioState;
import org.eclipse.jface.commands.ToggleState;
import org.eclipse.jface.menus.IWidget;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.ActionExpression;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.commands.CommandImageManager;
import org.eclipse.ui.internal.commands.ICommandImageService;
import org.eclipse.ui.internal.expressions.LegacyActionExpressionWrapper;
import org.eclipse.ui.internal.expressions.LegacyEditorContributionExpression;
import org.eclipse.ui.internal.expressions.LegacyViewContributionExpression;
import org.eclipse.ui.internal.menus.IMenuContribution;
import org.eclipse.ui.internal.menus.IMenuService;
import org.eclipse.ui.internal.menus.LegacyLocationInfo;
import org.eclipse.ui.internal.menus.LocationElement;
import org.eclipse.ui.internal.menus.PulldownDelegateWidgetProxy;
import org.eclipse.ui.internal.menus.SActionSet;
import org.eclipse.ui.internal.menus.SBar;
import org.eclipse.ui.internal.menus.SGroup;
import org.eclipse.ui.internal.menus.SItem;
import org.eclipse.ui.internal.menus.SLocation;
import org.eclipse.ui.internal.menus.SMenu;
import org.eclipse.ui.internal.menus.SReference;
import org.eclipse.ui.internal.menus.SWidget;
import org.eclipse.ui.internal.services.RegistryPersistence;
import org.eclipse.ui.internal.util.BundleUtility;

public final class LegacyActionPersistence
extends RegistryPersistence {
    private static final int INDEX_ACTION_SETS = 0;
    private static final int INDEX_EDITOR_CONTRIBUTIONS = 1;
    private static final int INDEX_OBJECT_CONTRIBUTIONS = 2;
    private static final int INDEX_VIEW_CONTRIBUTIONS = 3;
    private static final int INDEX_VIEWER_CONTRIBUTIONS = 4;
    private final BindingManager bindingManager;
    private final CommandImageManager commandImageManager;
    private final ICommandService commandService;
    private final Collection menuContributions = new ArrayList();
    private final IMenuService menuService;

    private static final SLocation createLocation(String barType, String path, LegacyLocationInfo locationInfo, char mnemonic, String imageStyle) {
        SBar leafElement = new SBar(barType, path);
        LocationElement locationElement = locationInfo == null ? leafElement : locationInfo.append(leafElement);
        return new SLocation(locationElement, null, mnemonic, imageStyle);
    }

    private static final Expression readVisibility(IConfigurationElement parentElement, String parentId, List warningsToLog) {
        IConfigurationElement[] visibilityElements = parentElement.getChildren("visibility");
        if (visibilityElements == null || visibilityElements.length == 0) {
            return null;
        }
        if (visibilityElements.length != 1) {
            LegacyActionPersistence.addWarning(warningsToLog, "There can only be one visibility element", parentElement, parentId);
        }
        IConfigurationElement visibilityElement = visibilityElements[0];
        ActionExpression visibilityActionExpression = new ActionExpression(visibilityElement);
        LegacyActionExpressionWrapper wrapper = new LegacyActionExpressionWrapper(visibilityActionExpression, null);
        return wrapper;
    }

    public LegacyActionPersistence(ICommandService commandService, BindingManager bindingManager, CommandImageManager commandImageManager, IMenuService menuService) {
        this.commandService = commandService;
        this.bindingManager = bindingManager;
        this.commandImageManager = commandImageManager;
        this.menuService = menuService;
    }

    private final void clearBindings() {
    }

    private final void clearImages() {
    }

    private final void clearMenus() {
        this.menuService.removeContributions(this.menuContributions);
        this.menuContributions.clear();
    }

    private final void convertActionToBinding(IConfigurationElement element, ParameterizedCommand command) {
        String label;
        String acceleratorText = LegacyActionPersistence.readOptional(element, "accelerator");
        if (acceleratorText == null && (label = LegacyActionPersistence.readOptional(element, "label")) != null) {
            acceleratorText = LegacyActionTools.extractAcceleratorText((String)label);
        }
        if (acceleratorText != null) {
            IKeyLookup lookup = KeyLookupFactory.getSWTKeyLookup();
            int acceleratorInt = LegacyActionTools.convertAccelerator((String)acceleratorText);
            int modifierMask = lookup.getAlt() | lookup.getCommand() | lookup.getCtrl() | lookup.getShift();
            int modifierKeys = acceleratorInt & modifierMask;
            int naturalKey = acceleratorInt & ~modifierMask;
            KeyStroke keyStroke = KeyStroke.getInstance((int)modifierKeys, (int)naturalKey);
            KeySequence keySequence = KeySequence.getInstance((KeyStroke)keyStroke);
            Scheme activeScheme = this.bindingManager.getActiveScheme();
            KeyBinding binding = new KeyBinding(keySequence, command, activeScheme.getId(), "org.eclipse.ui.contexts.window", null, null, null, 0);
            this.bindingManager.addBinding((Binding)binding);
        }
    }

    private final ParameterizedCommand convertActionToCommand(IConfigurationElement element, String primaryId, String secondaryId, List warningsToLog) {
        String commandId = LegacyActionPersistence.readOptional(element, "definitionId");
        Command command = null;
        if (commandId != null) {
            command = this.commandService.getCommand(commandId);
        }
        String label = null;
        if (commandId == null || !command.isDefined()) {
            if (commandId == null) {
                commandId = "AUTOGEN:::" + primaryId + '/' + secondaryId;
            }
            if ((label = LegacyActionPersistence.readRequired(element, "label", warningsToLog, "Actions require a non-empty label or definitionId", commandId)) == null) {
                label = WorkbenchMessages.LegacyActionPersistence_AutogeneratedCommandName;
            }
            String tooltip = LegacyActionPersistence.readOptional(element, "tooltip");
            command = this.commandService.getCommand(commandId);
            Category category = this.commandService.getCategory(null);
            String name = LegacyActionTools.removeAcceleratorText((String)Action.removeMnemonics((String)label));
            command.define(name, tooltip, category, null);
            String style = LegacyActionPersistence.readOptional(element, "style");
            if ("radio".equals(style)) {
                RadioState state = new RadioState();
                boolean checked = LegacyActionPersistence.readBoolean(element, "state", false);
                state.setValue((Object)(checked ? Boolean.TRUE : Boolean.FALSE));
                command.addState("STYLE", (State)state);
            } else if ("toggle".equals(style)) {
                ToggleState state = new ToggleState();
                boolean checked = LegacyActionPersistence.readBoolean(element, "state", false);
                state.setValue((Object)(checked ? Boolean.TRUE : Boolean.FALSE));
                command.addState("STYLE", (State)state);
            }
        }
        return new ParameterizedCommand(command, null);
    }

    private final String convertActionToImages(IConfigurationElement element, ParameterizedCommand command) {
        String commandId = command.getId();
        String icon = LegacyActionPersistence.readOptional(element, "icon");
        String disabledIcon = LegacyActionPersistence.readOptional(element, "disabledIcon");
        String hoverIcon = LegacyActionPersistence.readOptional(element, "hoverIcon");
        if (icon == null && disabledIcon == null && hoverIcon == null) {
            return null;
        }
        String style = this.commandImageManager.generateUnusedStyle(commandId);
        if (icon != null) {
            URL iconURL = BundleUtility.find(element.getNamespace(), icon);
            this.commandImageManager.bind(commandId, ICommandImageService.TYPE_DEFAULT, style, iconURL);
        }
        if (disabledIcon != null) {
            URL disabledIconURL = BundleUtility.find(element.getNamespace(), disabledIcon);
            this.commandImageManager.bind(commandId, ICommandImageService.TYPE_DISABLED, style, disabledIconURL);
        }
        if (hoverIcon != null) {
            URL hoverIconURL = BundleUtility.find(element.getNamespace(), hoverIcon);
            this.commandImageManager.bind(commandId, ICommandImageService.TYPE_HOVER, style, hoverIconURL);
        }
        return style;
    }

    private final void convertActionToItem(IConfigurationElement element, List warningsToLog, ParameterizedCommand command, String imageStyle, LegacyLocationInfo locationInfo, Expression visibleWhenExpression) {
        SLocation[] locations;
        String commandId = command.getId();
        String id = LegacyActionPersistence.readRequired(element, "id", warningsToLog, "Actions require an id", commandId);
        if (id == null) {
            return;
        }
        String label = LegacyActionPersistence.readOptional(element, "label");
        char mnemonic = LegacyActionTools.extractMnemonic((String)label);
        String menubarPath = LegacyActionPersistence.readOptional(element, "menubarPath");
        String toolbarPath = LegacyActionPersistence.readOptional(element, "toolbarPath");
        int locationCount = 0;
        if (menubarPath != null) {
            ++locationCount;
        }
        if (toolbarPath != null) {
            ++locationCount;
        }
        if (locationCount == 0) {
            locations = null;
        } else {
            locations = new SLocation[locationCount];
            int i = 0;
            if (menubarPath != null) {
                locations[i++] = LegacyActionPersistence.createLocation("menu", menubarPath, locationInfo, mnemonic, imageStyle);
            }
            if (toolbarPath != null) {
                locations[i++] = LegacyActionPersistence.createLocation("trim", toolbarPath, locationInfo, mnemonic, imageStyle);
            }
        }
        if (LegacyActionPersistence.isPulldown(element)) {
            SWidget widget = this.menuService.getWidget(id);
            PulldownDelegateWidgetProxy proxy = new PulldownDelegateWidgetProxy(element, "class");
            widget.define((IWidget)proxy, locations);
            IMenuContribution contribution = this.menuService.contributeMenu(widget, visibleWhenExpression);
            this.menuContributions.add(contribution);
        } else {
            SItem item = this.menuService.getItem(id);
            item.define(command, id, locations);
            IMenuContribution contribution = this.menuService.contributeMenu(item, visibleWhenExpression);
            this.menuContributions.add(contribution);
        }
    }

    protected final boolean isChangeImportant(IRegistryChangeEvent event) {
        return event.getExtensionDeltas("org.eclipse.ui", "actionSets").length != 0 || event.getExtensionDeltas("org.eclipse.ui", "editorActions").length != 0 || event.getExtensionDeltas("org.eclipse.ui", "popupMenus").length != 0 || event.getExtensionDeltas("org.eclipse.ui", "viewActions").length != 0;
    }

    public final void dispose() {
        super.dispose();
        this.clearBindings();
        this.clearImages();
        this.clearMenus();
    }

    public final void read() {
        super.read();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        int actionSetCount = 0;
        int editorContributionCount = 0;
        int objectContributionCount = 0;
        int viewContributionCount = 0;
        int viewerContributionCount = 0;
        IConfigurationElement[][] indexedConfigurationElements = new IConfigurationElement[5][];
        IConfigurationElement[] actionSetsExtensionPoint = registry.getConfigurationElementsFor("org.eclipse.ui.actionSets");
        int i = 0;
        while (i < actionSetsExtensionPoint.length) {
            IConfigurationElement element = actionSetsExtensionPoint[i];
            String name = element.getName();
            if ("actionSet".equals(name)) {
                LegacyActionPersistence.addElementToIndexedArray(element, indexedConfigurationElements, 0, actionSetCount++);
            }
            ++i;
        }
        IConfigurationElement[] editorActionsExtensionPoint = registry.getConfigurationElementsFor("org.eclipse.ui.editorActions");
        int i2 = 0;
        while (i2 < editorActionsExtensionPoint.length) {
            IConfigurationElement element = editorActionsExtensionPoint[i2];
            String name = element.getName();
            if ("editorContribution".equals(name)) {
                LegacyActionPersistence.addElementToIndexedArray(element, indexedConfigurationElements, 1, editorContributionCount++);
            }
            ++i2;
        }
        IConfigurationElement[] popupMenusExtensionPoint = registry.getConfigurationElementsFor("org.eclipse.ui.popupMenus");
        int i3 = 0;
        while (i3 < popupMenusExtensionPoint.length) {
            IConfigurationElement element = popupMenusExtensionPoint[i3];
            String name = element.getName();
            if ("objectContribution".equals(name)) {
                LegacyActionPersistence.addElementToIndexedArray(element, indexedConfigurationElements, 2, objectContributionCount++);
            } else if ("viewerContribution".equals(name)) {
                LegacyActionPersistence.addElementToIndexedArray(element, indexedConfigurationElements, 4, viewerContributionCount++);
            }
            ++i3;
        }
        IConfigurationElement[] viewActionsExtensionPoint = registry.getConfigurationElementsFor("org.eclipse.ui.viewActions");
        int i4 = 0;
        while (i4 < viewActionsExtensionPoint.length) {
            IConfigurationElement element = viewActionsExtensionPoint[i4];
            String name = element.getName();
            if ("viewContribution".equals(name)) {
                LegacyActionPersistence.addElementToIndexedArray(element, indexedConfigurationElements, 3, viewContributionCount++);
            }
            ++i4;
        }
        this.clearMenus();
        this.clearBindings();
        this.clearImages();
        this.readActionSets(indexedConfigurationElements[0], actionSetCount);
        this.readEditorContributions(indexedConfigurationElements[1], editorContributionCount);
        this.readObjectContributions(indexedConfigurationElements[2], objectContributionCount);
        this.readViewContributions(indexedConfigurationElements[3], viewContributionCount);
        this.readViewerContributions(indexedConfigurationElements[4], viewerContributionCount);
    }

    private final SReference[] readActions(String primaryId, IConfigurationElement[] elements, List warningsToLog, LegacyLocationInfo locationInfo, Expression visibleWhenExpression) {
        ArrayList<SReference> references = new ArrayList<SReference>(elements.length);
        int i = 0;
        while (i < elements.length) {
            ParameterizedCommand command;
            IConfigurationElement element = elements[i];
            String id = LegacyActionPersistence.readRequired(element, "id", warningsToLog, "Actions require an id");
            if (id != null && (command = this.convertActionToCommand(element, primaryId, id, warningsToLog)) != null) {
                this.convertActionToBinding(element, command);
                String imageStyle = this.convertActionToImages(element, command);
                this.convertActionToItem(element, warningsToLog, command, imageStyle, locationInfo, visibleWhenExpression);
                references.add(new SReference(3, id));
            }
            ++i;
        }
        return references.toArray(new SReference[references.size()]);
    }

    private final SReference[] readActionsAndMenus(IConfigurationElement element, String id, List warningsToLog, LegacyLocationInfo locationInfo, Expression visibleWhenExpression) {
        IConfigurationElement[] actionElements = element.getChildren("action");
        SReference[] itemReferences = this.readActions(id, actionElements, warningsToLog, locationInfo, visibleWhenExpression);
        IConfigurationElement[] menuElements = element.getChildren("menu");
        if (menuElements != null && menuElements.length > 0) {
            SReference[] menuAndGroupReferences = this.readMenusAndGroups(menuElements, id, warningsToLog, locationInfo, visibleWhenExpression);
            if (itemReferences == null || itemReferences.length == 0) {
                return menuAndGroupReferences;
            }
            SReference[] references = new SReference[itemReferences.length + menuAndGroupReferences.length];
            System.arraycopy(itemReferences, 0, references, 0, itemReferences.length);
            System.arraycopy(menuAndGroupReferences, 0, references, itemReferences.length, menuAndGroupReferences.length);
            return references;
        }
        return itemReferences;
    }

    private final void readActionSets(IConfigurationElement[] configurationElements, int configurationElementCount) {
        ArrayList warningsToLog = new ArrayList(1);
        int i = 0;
        while (i < configurationElementCount) {
            String label;
            IConfigurationElement element = configurationElements[i];
            String id = LegacyActionPersistence.readRequired(element, "id", warningsToLog, "Action sets need an id");
            if (id != null && (label = LegacyActionPersistence.readRequired(element, "label", warningsToLog, "Actions set need a label", id)) != null) {
                String description = LegacyActionPersistence.readOptional(element, "description");
                boolean visible = LegacyActionPersistence.readBoolean(element, "visible", false);
                SReference[] references = this.readActionsAndMenus(element, id, warningsToLog, null, null);
                if (references != null && references.length != 0) {
                    SActionSet actionSet = this.menuService.getActionSet(id);
                    actionSet.define(label, description, visible, references);
                }
            }
            ++i;
        }
        LegacyActionPersistence.logWarnings(warningsToLog, "Warnings while parsing the action sets from the 'org.eclipse.ui.actionSets' extension point");
    }

    private final void readEditorContributions(IConfigurationElement[] configurationElements, int configurationElementCount) {
        ArrayList warningsToLog = new ArrayList(1);
        int i = 0;
        while (i < configurationElementCount) {
            String targetId;
            IConfigurationElement element = configurationElements[i];
            String id = LegacyActionPersistence.readRequired(element, "id", warningsToLog, "Editor contributions need an id");
            if (id != null && (targetId = LegacyActionPersistence.readRequired(element, "targetID", warningsToLog, "Editor contributions need a target id", id)) != null) {
                LegacyEditorContributionExpression visibleWhenExpression = new LegacyEditorContributionExpression(targetId, null);
                this.readActionsAndMenus(element, id, warningsToLog, null, visibleWhenExpression);
            }
            ++i;
        }
        LegacyActionPersistence.logWarnings(warningsToLog, "Warnings while parsing the editor contributions from the 'org.eclipse.ui.editorActions' extension point");
    }

    private final SReference[] readGroups(IConfigurationElement[] elements, List warningsToLog, String path, LegacyLocationInfo locationInfo, Expression visibleWhenExpression, boolean separatorsVisible) {
        int length = elements.length;
        ArrayList<SReference> separators = new ArrayList<SReference>(length);
        int i = 0;
        while (i < length) {
            IConfigurationElement element = elements[i];
            String name = LegacyActionPersistence.readRequired(element, "name", warningsToLog, "Groups require a name");
            if (name != null) {
                SGroup group = this.menuService.getGroup(name);
                SLocation location = LegacyActionPersistence.createLocation("menu", path, locationInfo, '\u0000', null);
                SLocation[] locations = null;
                if (group.isDefined()) {
                    try {
                        SLocation[] currentLocations = group.getLocations();
                        int currentLength = currentLocations.length;
                        locations = new SLocation[currentLength + 1];
                        System.arraycopy(currentLocations, 0, locations, 0, currentLength);
                        locations[currentLength] = location;
                    }
                    catch (NotDefinedException notDefinedException) {
                        LegacyActionPersistence.addWarning(warningsToLog, "Group became undefined while loading registry (threading problem)", element, name);
                    }
                } else {
                    locations = new SLocation[]{location};
                }
                group.define(separatorsVisible, locations, null);
                IMenuContribution contribution = this.menuService.contributeMenu(group, visibleWhenExpression);
                this.menuContributions.add(contribution);
                SReference reference = new SReference(2, name);
                separators.add(reference);
            }
            ++i;
        }
        return separators.toArray(new SReference[separators.size()]);
    }

    private final SReference[] readMenusAndGroups(IConfigurationElement[] menuElements, String contributionId, List warningsToLog, LegacyLocationInfo locationInfo, Expression visibleWhenExpression) {
        int length = menuElements.length;
        ArrayList<SReference> references = new ArrayList<SReference>(length);
        int i = 0;
        while (i < length) {
            String label;
            IConfigurationElement menuElement = menuElements[i];
            String menuId = LegacyActionPersistence.readRequired(menuElement, "id", warningsToLog, "Menus require an id", contributionId);
            if (menuId != null && (label = LegacyActionPersistence.readRequired(menuElement, "label", warningsToLog, "Menus require a label", menuId)) != null) {
                IConfigurationElement[] groupElements;
                SReference[] groupReferences;
                char mnemonic = LegacyActionTools.extractMnemonic((String)label);
                label = LegacyActionTools.removeMnemonics((String)label);
                String path = LegacyActionPersistence.readOptional(menuElement, "path");
                String subpath = path == null ? menuId : String.valueOf(menuId) + '/' + path;
                IConfigurationElement[] separatorElements = menuElement.getChildren("separator");
                SReference[] separatorReferences = this.readGroups(separatorElements, warningsToLog, subpath, locationInfo, visibleWhenExpression, true);
                if (separatorReferences != null) {
                    references.addAll(Arrays.asList(separatorReferences));
                }
                if ((groupReferences = this.readGroups(groupElements = menuElement.getChildren("groupMarker"), warningsToLog, subpath, locationInfo, visibleWhenExpression, false)) != null) {
                    references.addAll(Arrays.asList(groupReferences));
                }
                SMenu menu = this.menuService.getMenu(menuId);
                SLocation location = LegacyActionPersistence.createLocation("menu", path, locationInfo, mnemonic, null);
                SLocation[] locations = new SLocation[]{location};
                menu.define(label, locations, null);
                IMenuContribution contribution = this.menuService.contributeMenu(menu, visibleWhenExpression);
                this.menuContributions.add(contribution);
                references.add(new SReference(1, menuId));
            }
            ++i;
        }
        return references.toArray(new SReference[references.size()]);
    }

    private final void readObjectContributions(IConfigurationElement[] configurationElements, int configurationElementCount) {
        ArrayList warningsToLog = new ArrayList(1);
        int i = 0;
        while (i < configurationElementCount) {
            String objectClass;
            IConfigurationElement element = configurationElements[i];
            String id = LegacyActionPersistence.readRequired(element, "id", warningsToLog, "Object contributions need an id");
            if (id != null && (objectClass = LegacyActionPersistence.readRequired(element, "objectClass", warningsToLog, "Object contributions need an object class", id)) != null) {
                LegacyLocationInfo locationInfo = new LegacyLocationInfo();
                Expression visibleWhenExpression = LegacyActionPersistence.readVisibility(element, id, warningsToLog);
                this.readActionsAndMenus(element, id, warningsToLog, locationInfo, visibleWhenExpression);
            }
            ++i;
        }
        LegacyActionPersistence.logWarnings(warningsToLog, "Warnings while parsing the object contributions from the 'org.eclipse.ui.popupMenus' extension point");
    }

    private final void readViewContributions(IConfigurationElement[] configurationElements, int configurationElementCount) {
        ArrayList warningsToLog = new ArrayList(1);
        int i = 0;
        while (i < configurationElementCount) {
            String targetId;
            IConfigurationElement element = configurationElements[i];
            String id = LegacyActionPersistence.readRequired(element, "id", warningsToLog, "View contributions need an id");
            if (id != null && (targetId = LegacyActionPersistence.readRequired(element, "targetID", warningsToLog, "View contributions need a target id", id)) != null) {
                LegacyViewContributionExpression visibleWhenExpression = new LegacyViewContributionExpression(targetId, null);
                LegacyLocationInfo locationInfo = new LegacyLocationInfo(targetId);
                this.readActionsAndMenus(element, id, warningsToLog, locationInfo, visibleWhenExpression);
            }
            ++i;
        }
        LegacyActionPersistence.logWarnings(warningsToLog, "Warnings while parsing the view contributions from the 'org.eclipse.ui.viewActions' extension point");
    }

    private final void readViewerContributions(IConfigurationElement[] configurationElements, int configurationElementCount) {
        ArrayList warningsToLog = new ArrayList(1);
        int i = 0;
        while (i < configurationElementCount) {
            String targetId;
            IConfigurationElement element = configurationElements[i];
            String id = LegacyActionPersistence.readRequired(element, "id", warningsToLog, "Viewer contributions need an id");
            if (id != null && (targetId = LegacyActionPersistence.readRequired(element, "targetID", warningsToLog, "Viewer contributions need a target id", id)) != null) {
                LegacyLocationInfo locationInfo = new LegacyLocationInfo(targetId, true);
                Expression visibleWhenExpression = LegacyActionPersistence.readVisibility(element, id, warningsToLog);
                this.readActionsAndMenus(element, id, warningsToLog, locationInfo, visibleWhenExpression);
            }
            ++i;
        }
        LegacyActionPersistence.logWarnings(warningsToLog, "Warnings while parsing the viewer contributions from the 'org.eclipse.ui.popupMenus' extension point");
    }
}

