/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.runtime.logview;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.Collator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.pde.internal.runtime.PDERuntimeMessages;
import org.eclipse.pde.internal.runtime.PDERuntimePlugin;
import org.eclipse.pde.internal.runtime.PDERuntimePluginImages;
import org.eclipse.pde.internal.runtime.logview.LogEntry;
import org.eclipse.pde.internal.runtime.logview.LogSession;
import org.eclipse.pde.internal.runtime.logview.LogView;
import org.eclipse.pde.internal.runtime.logview.LogViewContentProvider;
import org.eclipse.pde.internal.runtime.logview.LogViewLabelProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class EventDetailsDialog
extends TrayDialog {
    private LogEntry entry;
    private LogEntry parentEntry;
    private LogViewLabelProvider labelProvider = new LogViewLabelProvider();
    private static int COPY_ID = 22;
    private TreeViewer provider;
    private int elementNum;
    private int totalElementCount;
    private LogEntry[] entryChildren;
    private int childIndex = 0;
    private boolean isOpen;
    private boolean isLastChild;
    private boolean isAtEndOfLog;
    private Label dateLabel;
    private Label severityImageLabel;
    private Label severityLabel;
    private Text msgText;
    private Text stackTraceText;
    private Text sessionDataText;
    private Clipboard clipboard;
    private Button copyButton;
    private Button backButton;
    private Button nextButton;
    private Image imgNextEnabled;
    private Image imgPrevEnabled;
    private Image imgCopyEnabled;
    private SashForm sashForm;
    private Comparator comparator = null;
    private Collator collator;
    private Point dialogLocation;
    private Point dialogSize;
    private int[] sashWeights;

    protected EventDetailsDialog(Shell parentShell, IAdaptable selection, ISelectionProvider provider, Comparator comparator) {
        super(parentShell);
        this.provider = (TreeViewer)provider;
        this.entry = (LogEntry)selection;
        this.comparator = comparator;
        this.setShellStyle(3312);
        this.clipboard = new Clipboard(parentShell.getDisplay());
        this.initialize();
        this.createImages();
        this.collator = Collator.getInstance();
        this.readConfiguration();
        this.isLastChild = false;
        this.isAtEndOfLog = false;
    }

    private void initialize() {
        this.elementNum = this.getParentElementNum();
        this.resetTotalElementCount();
        this.parentEntry = (LogEntry)((Object)this.entry.getParent((Object)this.entry));
        if (this.isChild(this.entry)) {
            this.setEntryChildren(this.parentEntry);
            this.resetChildIndex();
        }
        this.isLastChild = false;
        this.isAtEndOfLog = false;
    }

    private void resetChildIndex() {
        int i = 0;
        while (i < this.entryChildren.length) {
            if (this.equal(this.entryChildren[i].getMessage(), this.entry.getMessage()) && this.equal(this.entryChildren[i].getDate(), this.entry.getDate()) && this.equal(this.entryChildren[i].getPluginId(), this.entry.getPluginId()) && this.entryChildren[i].getSeverity() == this.entry.getSeverity() && this.equal(this.entryChildren[i].getSeverityText(), this.entry.getSeverityText())) {
                this.childIndex = i;
                break;
            }
            ++i;
        }
    }

    private boolean equal(String str1, String str2) {
        if (str1 == null) {
            return str1 == str2;
        }
        return str1.equals(str2);
    }

    private void createImages() {
        this.imgCopyEnabled = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY").createImage(true);
        this.imgPrevEnabled = PDERuntimePluginImages.DESC_PREV_EVENT.createImage(true);
        this.imgNextEnabled = PDERuntimePluginImages.DESC_NEXT_EVENT.createImage(true);
    }

    private boolean isChild(LogEntry entry) {
        return entry.getParent((Object)entry) != null;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public int open() {
        this.isOpen = true;
        if (this.sashWeights == null) {
            int width = this.getSashForm().getClientArea().width;
            width = width - 100 > 0 ? (width -= 100) : (width /= 2);
            this.sashWeights = new int[]{width, this.getSashForm().getClientArea().width - width};
        }
        this.getSashForm().setWeights(this.sashWeights);
        return super.open();
    }

    public boolean close() {
        this.storeSettings();
        this.isOpen = false;
        this.imgCopyEnabled.dispose();
        this.imgNextEnabled.dispose();
        this.imgPrevEnabled.dispose();
        return super.close();
    }

    public void create() {
        super.create();
        if (this.dialogLocation != null) {
            this.getShell().setLocation(this.dialogLocation);
        }
        if (this.dialogSize != null) {
            this.getShell().setSize(this.dialogSize);
        } else {
            this.getShell().setSize(500, 550);
        }
        EventDetailsDialog.applyDialogFont((Control)this.buttonBar);
        this.getButton(0).setFocus();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.okPressed();
        } else if (1 == buttonId) {
            this.cancelPressed();
        } else if (14 == buttonId) {
            this.backPressed();
        } else if (15 == buttonId) {
            this.nextPressed();
        } else if (COPY_ID == buttonId) {
            this.copyPressed();
        }
    }

    protected void backPressed() {
        if (this.isChild(this.entry)) {
            if (this.childIndex > 0) {
                if (this.isLastChild) {
                    this.setEntryChildren(this.parentEntry);
                    this.isLastChild = false;
                }
                --this.childIndex;
                this.entry = this.entryChildren[this.childIndex];
            } else {
                this.entry = this.parentEntry;
            }
        } else {
            if (this.elementNum - 1 >= 0) {
                --this.elementNum;
            }
            this.entry = this.entryChildren[this.elementNum];
        }
        this.setEntrySelectionInTable();
    }

    protected void nextPressed() {
        if (this.isChild(this.entry) && this.childIndex < this.entryChildren.length - 1) {
            ++this.childIndex;
            this.entry = this.entryChildren[this.childIndex];
            this.isLastChild = this.childIndex == this.entryChildren.length - 1;
        } else if (this.isChild(this.entry) && this.isLastChild && !this.isAtEndOfLog) {
            this.findNextSelectedChild(this.entry);
        } else if (this.elementNum + 1 < this.totalElementCount) {
            if (this.isLastChild) {
                this.setEntryChildren();
                this.isLastChild = false;
            }
            ++this.elementNum;
            this.entry = this.entryChildren[this.elementNum];
        } else {
            this.setEntryChildren(this.entry);
            this.entry = this.entryChildren[0];
            this.isAtEndOfLog = this.entryChildren.length == 0;
            this.isLastChild = this.entryChildren.length == 0;
        }
        this.setEntrySelectionInTable();
    }

    protected void copyPressed() {
        StringWriter writer = new StringWriter();
        PrintWriter pwriter = new PrintWriter(writer);
        this.entry.write(pwriter);
        pwriter.flush();
        String textVersion = writer.toString();
        try {
            pwriter.close();
            writer.close();
        }
        catch (IOException iOException) {}
        this.clipboard.setContents(new Object[]{textVersion}, new Transfer[]{TextTransfer.getInstance()});
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
        this.updateProperties();
    }

    private void setComparator(byte sortType, final int sortOrder) {
        this.comparator = sortType == 2 ? new Comparator(){

            public int compare(Object e1, Object e2) {
                try {
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                    Date date1 = formatter.parse(((LogEntry)((Object)e1)).getDate());
                    Date date2 = formatter.parse(((LogEntry)((Object)e2)).getDate());
                    if (sortOrder == LogView.ASCENDING) {
                        return date1.before(date2) ? -1 : 1;
                    }
                    return date1.after(date2) ? -1 : 1;
                }
                catch (ParseException parseException) {
                    return 0;
                }
            }
        } : (sortType == 1 ? new Comparator(){

            public int compare(Object e1, Object e2) {
                LogEntry entry1 = (LogEntry)((Object)e1);
                LogEntry entry2 = (LogEntry)((Object)e2);
                return EventDetailsDialog.this.collator.compare(entry1.getPluginId(), entry2.getPluginId()) * sortOrder;
            }
        } : new Comparator(){

            public int compare(Object e1, Object e2) {
                LogEntry entry1 = (LogEntry)((Object)e1);
                LogEntry entry2 = (LogEntry)((Object)e2);
                return EventDetailsDialog.this.collator.compare(entry1.getMessage(), entry2.getMessage()) * sortOrder;
            }
        });
    }

    public void resetSelection(IAdaptable selectedEntry, byte sortType, int sortOrder) {
        this.setComparator(sortType, sortOrder);
        this.resetSelection(selectedEntry);
    }

    public void resetSelection(IAdaptable selectedEntry) {
        if (((Object)((Object)this.entry)).equals(selectedEntry) && this.elementNum == this.getParentElementNum()) {
            this.updateProperties();
            return;
        }
        this.entry = (LogEntry)selectedEntry;
        this.initialize();
        this.updateProperties();
    }

    public void resetButtons() {
        this.backButton.setEnabled(false);
        this.nextButton.setEnabled(false);
    }

    private void setEntrySelectionInTable() {
        StructuredSelection selection = new StructuredSelection((Object)this.entry);
        this.provider.setSelection((ISelection)selection);
    }

    public void updateProperties() {
        if (this.isChild(this.entry)) {
            this.parentEntry = (LogEntry)((Object)this.entry.getParent((Object)this.entry));
            this.setEntryChildren(this.parentEntry);
            this.resetChildIndex();
            if (this.childIndex == this.entryChildren.length - 1) {
                this.isLastChild = true;
            }
        }
        this.resetTotalElementCount();
        this.dateLabel.setText(this.entry.getDate() != null ? this.entry.getDate() : "");
        this.severityImageLabel.setImage(this.labelProvider.getColumnImage((Object)this.entry, 0));
        this.severityLabel.setText(this.entry.getSeverityText());
        this.msgText.setText(this.entry.getMessage() != null ? this.entry.getMessage() : "");
        String stack = this.entry.getStack();
        if (stack != null) {
            this.stackTraceText.setText(stack);
        } else {
            this.stackTraceText.setText(PDERuntimeMessages.EventDetailsDialog_noStack);
        }
        LogSession session = this.entry.getSession();
        if (session != null && session.getSessionData() != null) {
            this.sessionDataText.setText(session.getSessionData());
        }
        this.updateButtons();
    }

    private void updateButtons() {
        boolean isAtEnd;
        boolean bl = isAtEnd = this.elementNum == this.totalElementCount - 1;
        if (this.isChild(this.entry)) {
            this.backButton.setEnabled(true);
            this.nextButton.setEnabled(this.nextChildExists(this.entry, this.parentEntry, this.entryChildren) || !this.isLastChild || !isAtEnd || this.entry.hasChildren());
        } else {
            this.backButton.setEnabled(this.elementNum != 0);
            this.nextButton.setEnabled(!isAtEnd || this.entry.hasChildren());
        }
    }

    private void findNextSelectedChild(LogEntry originalEntry) {
        if (this.isChild(this.parentEntry)) {
            this.entry = this.parentEntry;
            this.setEntryChildren((LogEntry)((Object)this.parentEntry.getParent((Object)this.parentEntry)));
            this.parentEntry = (LogEntry)((Object)this.parentEntry.getParent((Object)this.parentEntry));
            this.resetChildIndex();
            boolean bl = this.isLastChild = this.childIndex == this.entryChildren.length - 1;
            if (this.isLastChild) {
                this.findNextSelectedChild(originalEntry);
            } else {
                this.nextPressed();
            }
        } else {
            this.entry = originalEntry;
            this.isAtEndOfLog = true;
            this.nextPressed();
        }
    }

    private boolean nextChildExists(LogEntry originalEntry, LogEntry originalParent, LogEntry[] originalEntries) {
        if (this.isChild(this.parentEntry)) {
            this.entry = this.parentEntry;
            this.setEntryChildren((LogEntry)((Object)this.parentEntry.getParent((Object)this.parentEntry)));
            this.parentEntry = (LogEntry)((Object)this.parentEntry.getParent((Object)this.parentEntry));
            this.resetChildIndex();
            if (this.childIndex == this.entryChildren.length - 1) {
                this.nextChildExists(originalEntry, originalParent, originalEntries);
            } else {
                this.entry = originalEntry;
                this.parentEntry = originalParent;
                this.entryChildren = originalEntries;
                this.resetChildIndex();
                return true;
            }
        }
        this.entry = originalEntry;
        this.parentEntry = originalParent;
        this.entryChildren = originalEntries;
        this.resetChildIndex();
        return false;
    }

    private void setEntryChildren() {
        Object[] children = ((LogViewContentProvider)this.provider.getContentProvider()).getElements(null);
        if (this.comparator != null) {
            Arrays.sort(children, this.comparator);
        }
        this.entryChildren = new LogEntry[children.length];
        System.arraycopy(children, 0, this.entryChildren, 0, children.length);
    }

    private void resetTotalElementCount() {
        this.totalElementCount = this.provider.getTree().getItemCount();
    }

    private void setEntryChildren(LogEntry parent) {
        if (parent == null) {
            this.setEntryChildren();
            return;
        }
        Object[] children = parent.getChildren((Object)parent);
        if (this.comparator != null) {
            Arrays.sort(children, this.comparator);
        }
        this.entryChildren = new LogEntry[children.length];
        System.arraycopy(children, 0, this.entryChildren, 0, children.length);
    }

    private int getParentElementNum() {
        LogEntry itemEntry = (LogEntry)((Object)((IStructuredSelection)this.provider.getSelection()).getFirstElement());
        itemEntry = this.getRootEntry(itemEntry);
        this.setEntryChildren();
        int i = 0;
        while (i < this.provider.getTree().getItemCount()) {
            try {
                LogEntry littleEntry = this.entryChildren[i];
                if (((Object)((Object)itemEntry)).equals((Object)littleEntry)) {
                    return i;
                }
            }
            catch (Exception exception) {}
            ++i;
        }
        return 0;
    }

    private LogEntry getRootEntry(LogEntry entry) {
        if (!this.isChild(entry)) {
            return entry;
        }
        return this.getRootEntry((LogEntry)((Object)entry.getParent((Object)entry)));
    }

    public SashForm getSashForm() {
        return this.sashForm;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        this.createDetailsSection(container);
        this.createSashForm(container);
        this.createStackSection((Composite)this.getSashForm());
        this.createSessionSection((Composite)this.getSashForm());
        this.updateProperties();
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    private void createSashForm(Composite parent) {
        this.sashForm = new SashForm(parent, 512);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.sashForm.setLayout((Layout)layout);
        this.sashForm.setLayoutData((Object)new GridData(1808));
    }

    private void createToolbarButtonBar(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(1040));
        Composite container = new Composite(comp, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 10;
        layout.numColumns = 1;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.backButton = this.createButton(container, 14, "", false);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.verticalSpan = 1;
        this.backButton.setLayoutData((Object)gd);
        this.backButton.setToolTipText(PDERuntimeMessages.EventDetailsDialog_previous);
        this.backButton.setImage(this.imgPrevEnabled);
        this.nextButton = this.createButton(container, 15, "", false);
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.verticalSpan = 1;
        this.nextButton.setLayoutData((Object)gd);
        this.nextButton.setToolTipText(PDERuntimeMessages.EventDetailsDialog_next);
        this.nextButton.setImage(this.imgNextEnabled);
        this.copyButton = this.createButton(container, COPY_ID, "", false);
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.verticalSpan = 1;
        this.copyButton.setLayoutData((Object)gd);
        this.copyButton.setImage(this.imgCopyEnabled);
        this.copyButton.setToolTipText(PDERuntimeMessages.EventDetailsDialog_copy);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    private void createDetailsSection(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(768));
        this.createTextSection(container);
        this.createToolbarButtonBar(container);
    }

    private void createTextSection(Composite parent) {
        Composite textContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        textContainer.setLayout((Layout)layout);
        textContainer.setLayoutData((Object)new GridData(768));
        Label label = new Label(textContainer, 0);
        label.setText(PDERuntimeMessages.EventDetailsDialog_date);
        this.dateLabel = new Label(textContainer, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.dateLabel.setLayoutData((Object)gd);
        label = new Label(textContainer, 0);
        label.setText(PDERuntimeMessages.EventDetailsDialog_severity);
        this.severityImageLabel = new Label(textContainer, 0);
        this.severityLabel = new Label(textContainer, 0);
        gd = new GridData(768);
        this.severityLabel.setLayoutData((Object)gd);
        label = new Label(textContainer, 0);
        label.setText(PDERuntimeMessages.EventDetailsDialog_message);
        gd = new GridData(2);
        label.setLayoutData((Object)gd);
        this.msgText = new Text(textContainer, 2626);
        this.msgText.setEditable(false);
        gd = new GridData(1810);
        gd.horizontalSpan = 2;
        gd.heightHint = 44;
        gd.grabExcessVerticalSpace = true;
        this.msgText.setLayoutData((Object)gd);
    }

    private void createStackSection(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 6;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.heightHint = 100;
        container.setLayoutData((Object)gd);
        Label label = new Label(container, 0);
        label.setText(PDERuntimeMessages.EventDetailsDialog_exception);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        this.stackTraceText = new Text(container, 2818);
        gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        this.stackTraceText.setLayoutData((Object)gd);
        this.stackTraceText.setEditable(false);
    }

    private void createSessionSection(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 6;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.heightHint = 100;
        container.setLayoutData((Object)gd);
        Label line = new Label(container, 258);
        gd = new GridData(256);
        gd.widthHint = 1;
        line.setLayoutData((Object)gd);
        Label label = new Label(container, 0);
        label.setText(PDERuntimeMessages.EventDetailsDialog_session);
        gd = new GridData(768);
        label.setLayoutData((Object)gd);
        this.sessionDataText = new Text(container, 2816);
        gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        this.sessionDataText.setLayoutData((Object)gd);
        this.sessionDataText.setEditable(false);
    }

    private void storeSettings() {
        this.writeConfiguration();
    }

    private IDialogSettings getDialogSettings() {
        IDialogSettings settings = PDERuntimePlugin.getDefault().getDialogSettings();
        IDialogSettings dialogSettings = settings.getSection(((Object)((Object)this)).getClass().getName());
        if (dialogSettings == null) {
            dialogSettings = settings.addNewSection(((Object)((Object)this)).getClass().getName());
        }
        return dialogSettings;
    }

    private void readConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        try {
            int x = s.getInt("x");
            int y = s.getInt("y");
            this.dialogLocation = new Point(x, y);
            x = s.getInt("width");
            y = s.getInt("height");
            this.dialogSize = new Point(x, y);
            this.sashWeights = new int[2];
            this.sashWeights[0] = s.getInt("sashWidth1");
            this.sashWeights[1] = s.getInt("sashWidth2");
        }
        catch (NumberFormatException numberFormatException) {
            this.dialogLocation = null;
            this.dialogSize = null;
            this.sashWeights = null;
        }
    }

    private void writeConfiguration() {
        IDialogSettings s = this.getDialogSettings();
        Point location = this.getShell().getLocation();
        s.put("x", location.x);
        s.put("y", location.y);
        Point size = this.getShell().getSize();
        s.put("width", size.x);
        s.put("height", size.y);
        this.sashWeights = this.getSashForm().getWeights();
        s.put("sashWidth1", this.sashWeights[0]);
        s.put("sashWidth2", this.sashWeights[1]);
    }
}

