/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.security.Security;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.startup.Catalina;
import org.apache.commons.digester.Digester;

public class CatalinaService
extends Catalina {
    protected boolean arguments(String[] args) {
        boolean isConfig = false;
        if (args.length < 1) {
            this.usage();
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            if (isConfig) {
                this.configFile = args[i];
                isConfig = false;
                continue;
            }
            if (args[i].equals("-config")) {
                isConfig = true;
                continue;
            }
            if (args[i].equals("-debug")) {
                this.debug = true;
                continue;
            }
            if (args[i].equals("-nonaming")) {
                this.useNaming = false;
                continue;
            }
            if (args[i].equals("-help")) {
                this.usage();
                return false;
            }
            if (args[i].equals("start")) {
                this.starting = true;
                this.stopping = false;
                continue;
            }
            if (args[i].equals("stop")) {
                this.starting = false;
                this.stopping = true;
                continue;
            }
            this.usage();
            return false;
        }
        return true;
    }

    protected void execute() throws Exception {
        if (this.starting) {
            this.load();
            this.start();
        } else if (this.stopping) {
            this.stop();
        }
    }

    public void load() {
        block9: {
            Digester digester = this.createStartDigester();
            File file = this.configFile();
            try {
                digester.push((Object)this);
                digester.parse(file);
            }
            catch (Exception e) {
                System.out.println("Catalina.start: " + e);
                e.printStackTrace(System.out);
                System.exit(1);
            }
            if (!this.useNaming) {
                System.setProperty("catalina.useNaming", "false");
            } else {
                System.setProperty("catalina.useNaming", "true");
                String value = "org.apache.naming";
                String oldValue = System.getProperty("java.naming.factory.url.pkgs");
                if (oldValue != null) {
                    value = value + ":" + oldValue;
                }
                System.setProperty("java.naming.factory.url.pkgs", value);
                System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
            }
            if (System.getSecurityManager() != null) {
                String access = Security.getProperty("package.access");
                access = access != null && access.length() > 0 ? access + "," : "sun.,";
                Security.setProperty("package.access", access + "org.apache.catalina.,org.apache.jasper.");
                String definition = Security.getProperty("package.definition");
                definition = definition != null && definition.length() > 0 ? definition + "," : "sun.,";
                Security.setProperty("package.definition", definition + "java.,org.apache.catalina.,org.apache.jasper.,org.apache.coyote.");
            }
            if (this.server instanceof Lifecycle) {
                try {
                    this.server.initialize();
                }
                catch (LifecycleException e) {
                    System.out.println("Catalina.start: " + e);
                    e.printStackTrace(System.out);
                    if (e.getThrowable() == null) break block9;
                    System.out.println("----- Root Cause -----");
                    e.getThrowable().printStackTrace(System.out);
                }
            }
        }
    }

    public void load(String[] args) {
        this.setCatalinaHome();
        this.setCatalinaBase();
        try {
            if (this.arguments(args)) {
                this.load();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void start() {
        block3: {
            if (this.server instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)this.server)).start();
                }
                catch (LifecycleException e) {
                    System.out.println("Catalina.start: " + e);
                    e.printStackTrace(System.out);
                    if (e.getThrowable() == null) break block3;
                    System.out.println("----- Root Cause -----");
                    e.getThrowable().printStackTrace(System.out);
                }
            }
        }
    }

    public void stop() {
        block3: {
            if (this.server instanceof Lifecycle) {
                try {
                    ((Lifecycle)((Object)this.server)).stop();
                }
                catch (LifecycleException e) {
                    System.out.println("Catalina.stop: " + e);
                    e.printStackTrace(System.out);
                    if (e.getThrowable() == null) break block3;
                    System.out.println("----- Root Cause -----");
                    e.getThrowable().printStackTrace(System.out);
                }
            }
        }
    }
}

