/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.resources.mapping.ResourceChangeValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.ui.actions.WorkspaceAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

public class RenameResourceAction
extends WorkspaceAction {
    private TreeEditor treeEditor;
    private Tree navigatorTree;
    private Text textEditor;
    private Composite textEditorParent;
    private TextActionHandler textActionHandler;
    private IResource inlinedResource;
    private boolean saving = false;
    public static final String ID = "org.eclipse.ui.RenameResourceAction";
    private IPath newPath;
    private String[] modelProviderIds;
    private static final String CHECK_RENAME_TITLE = IDEWorkbenchMessages.RenameResourceAction_checkTitle;
    private static final String CHECK_RENAME_MESSAGE = IDEWorkbenchMessages.RenameResourceAction_readOnlyCheck;
    private static String RESOURCE_EXISTS_TITLE = IDEWorkbenchMessages.RenameResourceAction_resourceExists;
    private static String RESOURCE_EXISTS_MESSAGE = IDEWorkbenchMessages.RenameResourceAction_overwriteQuestion;
    private static String RENAMING_MESSAGE = IDEWorkbenchMessages.RenameResourceAction_progressMessage;

    public RenameResourceAction(Shell shell) {
        super(shell, IDEWorkbenchMessages.RenameResourceAction_text);
        this.setToolTipText(IDEWorkbenchMessages.RenameResourceAction_toolTip);
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.rename_resource_action_context");
    }

    public RenameResourceAction(Shell shell, Tree tree) {
        this(shell);
        this.navigatorTree = tree;
        this.treeEditor = new TreeEditor(tree);
    }

    private boolean checkOverwrite(final Shell shell, final IResource destination) {
        final boolean[] result = new boolean[1];
        Runnable query = new Runnable(){

            public void run() {
                String pathName = destination.getFullPath().makeRelative().toString();
                result[0] = MessageDialog.openQuestion((Shell)shell, (String)RESOURCE_EXISTS_TITLE, (String)MessageFormat.format(RESOURCE_EXISTS_MESSAGE, pathName));
            }
        };
        shell.getDisplay().syncExec(query);
        return result[0];
    }

    private boolean checkReadOnlyAndNull(IResource currentResource) {
        if (currentResource == null) {
            return false;
        }
        if (currentResource.getResourceAttributes().isReadOnly()) {
            return MessageDialog.openQuestion((Shell)this.getShell(), (String)CHECK_RENAME_TITLE, (String)MessageFormat.format(CHECK_RENAME_MESSAGE, currentResource.getName()));
        }
        return true;
    }

    Composite createParent() {
        Tree tree = this.getTree();
        Composite result = new Composite((Composite)tree, 0);
        TreeItem[] selectedItems = tree.getSelection();
        this.treeEditor.horizontalAlignment = 16384;
        this.treeEditor.grabHorizontal = true;
        this.treeEditor.setEditor((Control)result, selectedItems[0]);
        return result;
    }

    private static int getCellEditorInset(Control c) {
        if ("carbon".equals(SWT.getPlatform()) && (System.getProperty("org.eclipse.swt.internal.carbon.noFocusRing") == null || c.getShell().getParent() != null)) {
            return -2;
        }
        return 1;
    }

    private void createTextEditor(final IResource resource) {
        this.textEditorParent = this.createParent();
        this.textEditorParent.setVisible(false);
        final int inset = RenameResourceAction.getCellEditorInset((Control)this.textEditorParent);
        if (inset > 0) {
            this.textEditorParent.addListener(9, new Listener(){

                public void handleEvent(Event e) {
                    Point textSize = RenameResourceAction.this.textEditor.getSize();
                    Point parentSize = RenameResourceAction.this.textEditorParent.getSize();
                    e.gc.drawRectangle(0, 0, Math.min(textSize.x + 4, parentSize.x - 1), parentSize.y - 1);
                }
            });
        }
        this.textEditor = new Text(this.textEditorParent, 0);
        this.textEditor.setFont(this.navigatorTree.getFont());
        this.textEditorParent.setBackground(this.textEditor.getBackground());
        this.textEditor.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                Point textSize = RenameResourceAction.this.textEditor.computeSize(-1, -1);
                textSize.x += textSize.y;
                Point parentSize = RenameResourceAction.this.textEditorParent.getSize();
                RenameResourceAction.this.textEditor.setBounds(2, inset, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2 * inset);
                RenameResourceAction.this.textEditorParent.redraw();
            }
        });
        this.textEditor.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 2: {
                        RenameResourceAction.this.disposeTextWidget();
                        event.doit = true;
                        event.detail = 0;
                        break;
                    }
                    case 4: {
                        RenameResourceAction.this.saveChangesAndDispose(resource);
                        event.doit = true;
                        event.detail = 0;
                    }
                }
            }
        });
        this.textEditor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                RenameResourceAction.this.saveChangesAndDispose(resource);
            }
        });
        if (this.textActionHandler != null) {
            this.textActionHandler.addText(this.textEditor);
        }
    }

    private void disposeTextWidget() {
        if (this.textActionHandler != null) {
            this.textActionHandler.removeText(this.textEditor);
        }
        if (this.textEditorParent != null) {
            this.textEditorParent.dispose();
            this.textEditorParent = null;
            this.textEditor = null;
            this.treeEditor.setEditor(null, null);
        }
    }

    protected List getActionResources() {
        if (this.inlinedResource == null) {
            return super.getActionResources();
        }
        ArrayList<IResource> actionResources = new ArrayList<IResource>();
        actionResources.add(this.inlinedResource);
        return actionResources;
    }

    protected String getOperationMessage() {
        return IDEWorkbenchMessages.RenameResourceAction_progress;
    }

    protected String getProblemsMessage() {
        return IDEWorkbenchMessages.RenameResourceAction_problemMessage;
    }

    protected String getProblemsTitle() {
        return IDEWorkbenchMessages.RenameResourceAction_problemTitle;
    }

    private Tree getTree() {
        return this.navigatorTree;
    }

    protected void invokeOperation(IResource resource, IProgressMonitor monitor) throws CoreException {
        if (!this.validateMove(resource, this.newPath)) {
            return;
        }
        monitor.beginTask(RENAMING_MESSAGE, 100);
        IWorkspaceRoot workspaceRoot = resource.getWorkspace().getRoot();
        IResource newResource = workspaceRoot.findMember(this.newPath);
        if (newResource != null) {
            if (this.checkOverwrite(this.getShell(), newResource)) {
                if (resource.getType() == 1 && newResource.getType() == 1) {
                    IFile file = (IFile)resource;
                    IFile newFile = (IFile)newResource;
                    if (this.validateEdit(file, newFile, this.getShell())) {
                        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 50);
                        newFile.setContents(file.getContents(), 2, (IProgressMonitor)subMonitor);
                        file.delete(2, (IProgressMonitor)subMonitor);
                    }
                    monitor.worked(100);
                    return;
                }
                newResource.delete(2, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            } else {
                monitor.worked(100);
                return;
            }
        }
        if (resource.getType() == 4) {
            IProject project = (IProject)resource;
            IProjectDescription description = project.getDescription();
            description.setName(this.newPath.segment(0));
            project.move(description, 33, monitor);
        } else {
            resource.move(this.newPath, 34, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
        }
    }

    private boolean validateMove(IResource resource, IPath path) {
        IResourceChangeDescriptionFactory factory = ResourceChangeValidator.getValidator().createDeltaFactory();
        factory.move(resource, path);
        return IDE.promptToConfirm(this.getShell(), IDEWorkbenchMessages.RenameResourceAction_confirm, NLS.bind((String)IDEWorkbenchMessages.RenameResourceAction_warning, (Object)resource.getName()), factory.getDelta(), this.modelProviderIds, true);
    }

    protected String queryNewResourceName(final IResource resource) {
        final IWorkspace workspace = IDEWorkbenchPlugin.getPluginWorkspace();
        final IPath prefix = resource.getFullPath().removeLastSegments(1);
        IInputValidator validator = new IInputValidator(){

            public String isValid(String string) {
                if (resource.getName().equals(string)) {
                    return IDEWorkbenchMessages.RenameResourceAction_nameMustBeDifferent;
                }
                IStatus status = workspace.validateName(string, resource.getType());
                if (!status.isOK()) {
                    return status.getMessage();
                }
                if (workspace.getRoot().exists(prefix.append(string))) {
                    return IDEWorkbenchMessages.RenameResourceAction_nameExists;
                }
                return null;
            }
        };
        InputDialog dialog = new InputDialog(this.getShell(), IDEWorkbenchMessages.RenameResourceAction_inputDialogTitle, IDEWorkbenchMessages.RenameResourceAction_inputDialogMessage, resource.getName(), validator);
        dialog.setBlockOnOpen(true);
        dialog.open();
        return dialog.getValue();
    }

    private void queryNewResourceNameInline(IResource resource) {
        if (this.textEditorParent == null) {
            this.createTextEditor(resource);
        }
        this.textEditor.setText(resource.getName());
        this.textEditorParent.setVisible(true);
        Point textSize = this.textEditor.computeSize(-1, -1);
        textSize.x += textSize.y;
        Point parentSize = this.textEditorParent.getSize();
        int inset = RenameResourceAction.getCellEditorInset((Control)this.textEditorParent);
        this.textEditor.setBounds(2, inset, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2 * inset);
        this.textEditorParent.redraw();
        this.textEditor.selectAll();
        this.textEditor.setFocus();
    }

    public void run() {
        if (this.navigatorTree == null) {
            IResource currentResource = this.getCurrentResource();
            if (currentResource == null || !currentResource.exists()) {
                return;
            }
            if (!this.checkReadOnlyAndNull(currentResource)) {
                return;
            }
            String newName = this.queryNewResourceName(currentResource);
            if (newName == null || newName.equals("")) {
                return;
            }
            this.newPath = currentResource.getFullPath().removeLastSegments(1).append(newName);
            super.run();
        } else {
            this.runWithInlineEditor();
        }
    }

    private void runWithInlineEditor() {
        IResource currentResource = this.getCurrentResource();
        if (!this.checkReadOnlyAndNull(currentResource)) {
            return;
        }
        this.queryNewResourceNameInline(currentResource);
    }

    private IResource getCurrentResource() {
        List resources = this.getSelectedResources();
        if (resources.size() == 1) {
            return (IResource)resources.get(0);
        }
        return null;
    }

    protected void runWithNewPath(IPath path, IResource resource) {
        this.newPath = path;
        super.run();
    }

    private void saveChangesAndDispose(IResource resource) {
        if (this.saving) {
            return;
        }
        this.saving = true;
        this.inlinedResource = resource;
        final String newName = this.textEditor.getText();
        Runnable query = new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    if (!newName.equals(RenameResourceAction.this.inlinedResource.getName())) {
                        IWorkspace workspace = IDEWorkbenchPlugin.getPluginWorkspace();
                        IStatus status = workspace.validateName(newName, RenameResourceAction.this.inlinedResource.getType());
                        if (!status.isOK()) {
                            RenameResourceAction.this.displayError(status.getMessage());
                        } else {
                            IPath newPath = RenameResourceAction.this.inlinedResource.getFullPath().removeLastSegments(1).append(newName);
                            RenameResourceAction.this.runWithNewPath(newPath, RenameResourceAction.this.inlinedResource);
                        }
                    }
                    RenameResourceAction.this.inlinedResource = null;
                    RenameResourceAction.this.disposeTextWidget();
                    if (RenameResourceAction.this.navigatorTree != null && !RenameResourceAction.this.navigatorTree.isDisposed()) {
                        RenameResourceAction.this.navigatorTree.setFocus();
                    }
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    RenameResourceAction.this.saving = false;
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                }
                RenameResourceAction.this.saving = false;
            }
        };
        this.getTree().getShell().getDisplay().asyncExec(query);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.disposeTextWidget();
        if (selection.size() > 1) {
            return false;
        }
        if (!super.updateSelection(selection)) {
            return false;
        }
        IResource currentResource = this.getCurrentResource();
        return currentResource != null && currentResource.exists();
    }

    public void setTextActionHandler(TextActionHandler actionHandler) {
        this.textActionHandler = actionHandler;
    }

    boolean validateEdit(IFile source, IFile destination, Shell shell) {
        if (destination.isReadOnly()) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus status = source.isReadOnly() ? workspace.validateEdit(new IFile[]{source, destination}, (Object)shell) : workspace.validateEdit(new IFile[]{destination}, (Object)shell);
            return status.isOK();
        }
        return true;
    }

    public String[] getModelProviderIds() {
        return this.modelProviderIds;
    }

    public void setModelProviderIds(String[] modelProviderIds) {
        this.modelProviderIds = modelProviderIds;
    }
}

