/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class CloseUnrelatedProjectsAction
extends CloseResourceAction {
    public static final String ID = "org.eclipse.ui.CloseUnrelatedProjectsAction";
    private final List projectsToClose = new ArrayList();
    private boolean selectionDirty = true;
    private List oldSelection = Collections.EMPTY_LIST;

    public CloseUnrelatedProjectsAction(Shell shell) {
        super(shell, IDEWorkbenchMessages.CloseUnrelatedProjectsAction_text);
        this.setId(ID);
        this.setToolTipText(IDEWorkbenchMessages.CloseUnrelatedProjectsAction_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.close_unrelated_projects_action_context");
    }

    private void addRelatedProjects(HashSet relatedProjects, IProject project) {
        if (project == null || relatedProjects.contains(project)) {
            return;
        }
        relatedProjects.add(project);
        try {
            IProject[] related = project.getReferencedProjects();
            int i = 0;
            while (i < related.length) {
                this.addRelatedProjects(relatedProjects, related[i]);
                ++i;
            }
            related = project.getReferencingProjects();
            i = 0;
            while (i < related.length) {
                this.addRelatedProjects(relatedProjects, related[i]);
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    protected void clearCache() {
        super.clearCache();
        this.selectionDirty = true;
    }

    private void computeRelated(List selection) {
        HashSet relatedProjects = new HashSet();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (!(next instanceof IProject)) continue;
            this.addRelatedProjects(relatedProjects, (IProject)next);
        }
        HashSet<IProject> unrelated = new HashSet<IProject>();
        unrelated.addAll(Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()));
        unrelated.removeAll(relatedProjects);
        this.projectsToClose.clear();
        this.projectsToClose.addAll(unrelated);
    }

    protected List getSelectedResources() {
        if (this.selectionDirty) {
            List newSelection = super.getSelectedResources();
            if (!this.oldSelection.equals(newSelection)) {
                this.oldSelection = newSelection;
                this.computeRelated(newSelection);
            }
            this.selectionDirty = false;
        }
        return this.projectsToClose;
    }
}

