/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.provisional.ide.OpenWithEntry;
import org.eclipse.ui.part.FileEditorInput;

public class FileOpenWithEntry
extends OpenWithEntry {
    public FileOpenWithEntry(IEditorDescriptor editorDesc, IFile file) {
        super(editorDesc, file);
        Assert.isNotNull((Object)editorDesc);
    }

    public void openEditor(IWorkbenchPage page, boolean activate, int matchFlags, boolean rememberEditor) throws PartInitException {
        Assert.isNotNull((Object)this.getEditorDescriptor());
        String editorId = this.getEditorDescriptor().getId();
        IFile file = (IFile)this.getElement();
        page.openEditor((IEditorInput)new FileEditorInput(file), editorId, activate, matchFlags);
        if (rememberEditor) {
            IDE.setDefaultEditor(file, editorId);
        }
    }

    public ImageDescriptor getImageDescriptor() {
        ImageDescriptor imageDesc;
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        IFile file = (IFile)this.getElement();
        if (this.getEditorDescriptor() != null) {
            String editorId;
            String string = editorId = this.getEditorDescriptor() == null ? null : this.getEditorDescriptor().getId();
            if ("org.eclipse.ui.systemExternalEditor".equals(editorId) || "org.eclipse.ui.systemInPlaceEditor".equals(editorId)) {
                return registry.getSystemExternalEditorImageDescriptor(file.getName());
            }
            imageDesc = this.getEditorDescriptor().getImageDescriptor();
            if (imageDesc != null) {
                return imageDesc;
            }
        }
        if ((imageDesc = registry.getImageDescriptor(file.getName())) != null) {
            return imageDesc;
        }
        return super.getImageDescriptor();
    }
}

