/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.search.internal.ui.SearchPluginImages;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.Messages;
import org.eclipse.search2.internal.ui.RemoveAllSearchesAction;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.SearchView;
import org.eclipse.search2.internal.ui.ShowSearchHistoryDialogAction;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.osgi.framework.Bundle;

class SearchHistoryDropDownAction
extends Action
implements IMenuCreator {
    public static final int RESULTS_IN_DROP_DOWN = 10;
    private Menu fMenu;
    private SearchView fSearchView;

    public SearchHistoryDropDownAction(SearchView searchView) {
        this.setText(SearchMessages.SearchDropDownAction_label);
        this.setToolTipText(SearchMessages.SearchDropDownAction_tooltip);
        SearchPluginImages.setImageDescriptors((IAction)this, "lcl16/", "org.eclipse.search.ui.search_history.gif");
        this.fSearchView = searchView;
        this.setMenuCreator(this);
    }

    public void updateEnablement() {
        boolean hasQueries = InternalSearchUI.getInstance().getSearchManager().hasQueries();
        boolean emptyPageExt = this.fSearchView.getSearchPageRegistry().hasEmptyPageExtensions();
        this.setEnabled(hasQueries || emptyPageExt);
    }

    public void dispose() {
        this.disposeMenu();
    }

    void disposeMenu() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        ISearchQuery[] searches;
        ISearchResult currentSearch = this.fSearchView.getCurrentSearchResult();
        this.disposeMenu();
        this.fMenu = new Menu(parent);
        IConfigurationElement[] emptyPageExtensions = this.fSearchView.getSearchPageRegistry().getEmptyPageExtensions();
        if (emptyPageExtensions.length > 0) {
            int i = 0;
            while (i < emptyPageExtensions.length) {
                ShowEmptySearchAction action = new ShowEmptySearchAction(emptyPageExtensions[i]);
                this.addActionToMenu(this.fMenu, action);
                ++i;
            }
        }
        if ((searches = InternalSearchUI.getInstance().getSearchManager().getQueries()).length > 0) {
            if (emptyPageExtensions.length > 0) {
                new MenuItem(this.fMenu, 2);
            }
            int i = 0;
            while (i < searches.length) {
                ISearchResult search = searches[i].getSearchResult();
                ShowSearchFromHistoryAction action = new ShowSearchFromHistoryAction(search);
                action.setChecked(search.equals(currentSearch));
                this.addActionToMenu(this.fMenu, action);
                ++i;
            }
            new MenuItem(this.fMenu, 2);
            this.addActionToMenu(this.fMenu, new RemoveAllSearchesAction());
        }
        return this.fMenu;
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public void run() {
        new ShowSearchHistoryDialogAction(this.fSearchView).run();
    }

    private class ShowSearchFromHistoryAction
    extends Action {
        private ISearchResult fSearch;

        public ShowSearchFromHistoryAction(ISearchResult search) {
            this.fSearch = search;
            String label = this.escapeAmp(search.getLabel());
            if (InternalSearchUI.getInstance().isQueryRunning(search.getQuery())) {
                label = MessageFormat.format(SearchMessages.SearchDropDownAction_running_message, label);
            }
            if (label.indexOf(64) >= 0) {
                label = String.valueOf(label) + '@';
            }
            this.setText(label);
            this.setImageDescriptor(search.getImageDescriptor());
            this.setToolTipText(search.getTooltip());
        }

        private String escapeAmp(String label) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < label.length()) {
                char ch = label.charAt(i);
                buf.append(ch);
                if (ch == '&') {
                    buf.append('&');
                }
                ++i;
            }
            return buf.toString();
        }

        public void run() {
            InternalSearchUI.getInstance().getSearchManager().touch(this.fSearch.getQuery());
            SearchHistoryDropDownAction.this.fSearchView.showSearchResult(this.fSearch);
        }
    }

    private class ShowEmptySearchAction
    extends Action {
        private final String fPageId;

        public ShowEmptySearchAction(IConfigurationElement elem) {
            this.fPageId = elem.getAttribute("id");
            String pageLabel = elem.getAttribute("label");
            String text = Messages.format(SearchMessages.SearchHistoryDropDownAction_showemptyview_title, pageLabel);
            this.setText(text);
            String tooltip = Messages.format(SearchMessages.SearchHistoryDropDownAction_showemptyview_tooltip, pageLabel);
            this.setToolTipText(tooltip);
            String imageName = elem.getAttribute("icon");
            if (imageName != null) {
                Bundle bundle = Platform.getBundle((String)elem.getNamespace());
                this.setImageDescriptor(SearchPluginImages.createImageDescriptor(bundle, (IPath)new Path(imageName), true));
            }
        }

        public void run() {
            SearchHistoryDropDownAction.this.fSearchView.showEmptySearchPage(this.fPageId);
        }
    }
}

