/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search2.internal.ui.CancelSearchAction;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.PinSearchViewAction;
import org.eclipse.search2.internal.ui.SearchAgainAction;
import org.eclipse.search2.internal.ui.SearchHistoryDropDownAction;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.SearchPageRegistry;
import org.eclipse.search2.internal.ui.text.AnnotationManagers;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class SearchView
extends PageBookView
implements ISearchResultViewPart,
IQueryListener {
    private static final String MEMENTO_TYPE = "view";
    private HashMap fPartsToPages = new HashMap();
    private HashMap fPagesToParts = new HashMap();
    private HashMap fSearchViewStates;
    private SearchPageRegistry fSearchViewPageService = new SearchPageRegistry();
    private SearchHistoryDropDownAction fSearchesDropDownAction;
    private ISearchResult fCurrentSearch;
    private DummyPart fDefaultPart;
    private SearchAgainAction fSearchAgainAction;
    private CancelSearchAction fCancelAction;
    private PinSearchViewAction fPinSearchViewAction;
    private IMemento fPageState;
    private boolean fIsPinned = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static void createContextMenuGroups(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.new"));
        menu.add((IContributionItem)new GroupMarker("group.goto"));
        menu.add((IContributionItem)new GroupMarker("group.open"));
        menu.add((IContributionItem)new Separator("group.show"));
        menu.add((IContributionItem)new Separator("group.removeMatches"));
        menu.add((IContributionItem)new Separator("group.reorganize"));
        menu.add((IContributionItem)new GroupMarker("group.generate"));
        menu.add((IContributionItem)new Separator("group.search"));
        menu.add((IContributionItem)new Separator("group.build"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("group.viewerSetup"));
        menu.add((IContributionItem)new Separator("group.properties"));
    }

    public static void createToolBarGroups(IToolBarManager toolbar) {
        toolbar.add((IContributionItem)new Separator("group.new"));
        toolbar.add((IContributionItem)new GroupMarker("group.goto"));
        toolbar.add((IContributionItem)new GroupMarker("group.open"));
        toolbar.add((IContributionItem)new Separator("group.show"));
        toolbar.add((IContributionItem)new Separator("group.build"));
        toolbar.add((IContributionItem)new Separator("group.reorganize"));
        toolbar.add((IContributionItem)new Separator("group.removeMatches"));
        toolbar.add((IContributionItem)new GroupMarker("group.generate"));
        toolbar.add((IContributionItem)new Separator("additions"));
        toolbar.add((IContributionItem)new Separator("group.viewerSetup"));
        toolbar.add((IContributionItem)new Separator("group.properties"));
        toolbar.add((IContributionItem)new Separator("group.search"));
    }

    public SearchView() {
        this.fSearchViewStates = new HashMap();
    }

    public SearchPageRegistry getSearchPageRegistry() {
        return this.fSearchViewPageService;
    }

    public void partActivated(IWorkbenchPart part) {
        super.partActivated(part);
        if (part == this) {
            InternalSearchUI.getInstance().getSearchViewManager().searchViewActivated(this);
        }
    }

    protected IPage createDefaultPage(PageBook book) {
        EmptySearchView page = new EmptySearchView();
        page.createControl((Composite)book);
        this.initPage(page);
        DummyPart part = new DummyPart();
        this.fPartsToPages.put(part, page);
        this.fPagesToParts.put(page, part);
        this.fDefaultPart = part;
        return page;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart part) {
        IPageBookViewPage page = (IPageBookViewPage)this.fPartsToPages.get(part);
        this.initPage(page);
        page.createControl((Composite)this.getPageBook());
        PageBookView.PageRec rec = new PageBookView.PageRec(part, (IPage)page);
        return rec;
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        IPage page = pageRecord.page;
        page.dispose();
        pageRecord.dispose();
        this.fPartsToPages.remove(part);
    }

    protected IWorkbenchPart getBootstrapPart() {
        return null;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof DummyPart;
    }

    public void showSearchResult(ISearchResult search) {
        ISearchResultPage newPage = null;
        if (search != null && (newPage = this.fSearchViewPageService.findPageForSearchResult(search, true)) == null) {
            String format = SearchMessages.SearchView_error_noResultPage;
            String message = MessageFormat.format(format, search.getClass().getName());
            SearchPlugin.log((IStatus)new Status(4, SearchPlugin.getID(), 0, message, null));
            return;
        }
        this.internalShowSearchPage(newPage, search);
    }

    public void showEmptySearchPage(String pageId) {
        ISearchResultPage newPage = this.fSearchViewPageService.findPageForPageId(pageId, true);
        this.internalShowSearchPage(newPage, null);
    }

    private void internalShowSearchPage(ISearchResultPage page, ISearchResult search) {
        ISearchResultPage currentPage = (ISearchResultPage)this.getCurrentPage();
        if (this.fCurrentSearch != null && currentPage != null) {
            this.fSearchViewStates.put(this.fCurrentSearch, currentPage.getUIState());
            currentPage.setInput(null, null);
        }
        this.fCurrentSearch = search;
        if (page != null) {
            if (page != currentPage) {
                IWorkbenchPart part = (IWorkbenchPart)this.fPagesToParts.get(page);
                if (part == null) {
                    part = new DummyPart();
                    this.fPagesToParts.put(page, part);
                    this.fPartsToPages.put(part, page);
                    page.setViewPart(this);
                }
                this.partActivated(part);
            }
            Object uiState = search != null ? this.fSearchViewStates.get(search) : null;
            page.setInput(search, uiState);
        }
        this.updateLabel();
        this.updateCancelAction();
    }

    public void updateLabel() {
        ISearchResultPage page = this.getActivePage();
        String label = "";
        if (page != null) {
            label = page.getLabel();
        }
        this.setContentDescription(label);
    }

    public ISearchResult getCurrentSearchResult() {
        return this.fCurrentSearch;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.createActions();
        this.initializeToolBar();
        InternalSearchUI.getInstance().getSearchManager().addQueryListener(this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.search.new_search_view_context");
    }

    private void initializeToolBar() {
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        SearchView.createToolBarGroups(tbm);
        tbm.appendToGroup("group.search", (IAction)this.fSearchAgainAction);
        tbm.appendToGroup("group.search", (IAction)this.fCancelAction);
        tbm.appendToGroup("group.search", (IAction)this.fSearchesDropDownAction);
        tbm.appendToGroup("group.search", (IAction)this.fPinSearchViewAction);
        this.getViewSite().getActionBars().updateActionBars();
    }

    private void createActions() {
        this.fSearchesDropDownAction = new SearchHistoryDropDownAction(this);
        this.fSearchesDropDownAction.updateEnablement();
        this.fSearchAgainAction = new SearchAgainAction(this);
        this.fSearchAgainAction.setEnabled(false);
        this.fSearchAgainAction.setActionDefinitionId("org.eclipse.ui.file.refresh");
        this.fCancelAction = new CancelSearchAction(this);
        this.fCancelAction.setEnabled(false);
        this.fPinSearchViewAction = new PinSearchViewAction(this);
    }

    public void dispose() {
        InternalSearchUI.getInstance().getSearchViewManager().searchViewClosed(this);
        InternalSearchUI.getInstance().getSearchManager().removeQueryListener(this);
        AnnotationManagers.searchResultActivated(this.getSite().getWorkbenchWindow(), null);
        super.dispose();
    }

    public void queryStarting(ISearchQuery query) {
        if (query.getSearchResult().equals(this.fCurrentSearch)) {
            this.updateCancelAction();
        }
    }

    public void queryFinished(ISearchQuery query) {
        if (query.getSearchResult().equals(this.fCurrentSearch)) {
            this.updateCancelAction();
        }
    }

    private void updateCancelAction() {
        ISearchResult result = this.getCurrentSearchResult();
        boolean queryRunning = false;
        if (result != null) {
            queryRunning = InternalSearchUI.getInstance().isQueryRunning(result.getQuery());
        }
        this.fCancelAction.setEnabled(queryRunning);
        this.fSearchAgainAction.setEnabled(!queryRunning && result != null && result.getQuery().canRerun());
    }

    public void queryAdded(ISearchQuery query) {
        this.fSearchesDropDownAction.updateEnablement();
    }

    public void queryRemoved(ISearchQuery query) {
        InternalSearchUI.getInstance().cancelSearch(query);
        if (query.getSearchResult().equals(this.fCurrentSearch)) {
            this.showSearchResult(null);
            this.partActivated(this.fDefaultPart);
        }
        this.fSearchViewStates.remove(query.getSearchResult());
        this.fSearchesDropDownAction.disposeMenu();
        this.fSearchesDropDownAction.updateEnablement();
    }

    public void fillContextMenu(IMenuManager menuManager) {
        ISearchResult result = this.getCurrentSearchResult();
        if (result != null) {
            menuManager.appendToGroup("group.search", (IAction)this.fSearchAgainAction);
            MenuManager showInSubMenu = new MenuManager(SearchMessages.SearchView_showIn_menu);
            showInSubMenu.add(ContributionItemFactory.VIEWS_SHOW_IN.create(this.getViewSite().getWorkbenchWindow()));
            menuManager.appendToGroup("group.open", (IContributionItem)showInSubMenu);
        }
    }

    public void saveState(IMemento memento) {
        Iterator pages = this.fPagesToParts.keySet().iterator();
        while (pages.hasNext()) {
            ISearchResultPage page = (ISearchResultPage)pages.next();
            IMemento child = memento.createChild(MEMENTO_TYPE, page.getID());
            page.saveState(child);
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        SearchView.createContextMenuGroups(site.getActionBars().getMenuManager());
        this.fPageState = memento;
        IWorkbenchSiteProgressService progressService = this.getProgressService();
        if (progressService != null) {
            progressService.showBusyForFamily(InternalSearchUI.FAMILY_SEARCH);
        }
    }

    protected void initPage(IPageBookViewPage page) {
        super.initPage(page);
        page.getSite().getActionBars().setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.fSearchAgainAction);
        page.getSite().getActionBars().updateActionBars();
        ISearchResultPage srPage = (ISearchResultPage)page;
        IMemento memento = null;
        if (this.fPageState != null) {
            IMemento[] mementos = this.fPageState.getChildren(MEMENTO_TYPE);
            int i = 0;
            while (i < mementos.length) {
                if (mementos[i].getID().equals(srPage.getID())) {
                    memento = mementos[i];
                    break;
                }
                ++i;
            }
        }
        srPage.restoreState(memento);
    }

    public void setFocus() {
        IPage currentPage = this.getCurrentPage();
        if (currentPage != null) {
            currentPage.setFocus();
        } else {
            super.setFocus();
        }
    }

    public ISearchResultPage getActivePage() {
        IPage page = this.getCurrentPage();
        if (page instanceof ISearchResultPage) {
            return (ISearchResultPage)page;
        }
        return null;
    }

    public IWorkbenchSiteProgressService getProgressService() {
        Object siteService;
        IWorkbenchSiteProgressService service = null;
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((siteService = iWorkbenchPartSite.getAdapter((Class)clazz)) != null) {
            service = (IWorkbenchSiteProgressService)siteService;
        }
        return service;
    }

    public void showBusy(boolean busy) {
        super.showBusy(busy);
        this.getProgressService().warnOfContentChange();
    }

    public Object getAdapter(Class adapter) {
        Object superAdapter = super.getAdapter(adapter);
        if (superAdapter != null) {
            return superAdapter;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return new IShowInSource(){

                public ShowInContext getShowInContext() {
                    return new ShowInContext(null, SearchView.this.getSelectionProvider().getSelection());
                }
            };
        }
        return null;
    }

    public void setPinned(boolean pinned) {
        this.fIsPinned = pinned;
    }

    public boolean isPinned() {
        return this.fIsPinned;
    }

    class DummyPart
    implements IWorkbenchPart {
        DummyPart() {
        }

        public void addPropertyListener(IPropertyListener listener) {
        }

        public void createPartControl(Composite parent) {
        }

        public void dispose() {
        }

        public IWorkbenchPartSite getSite() {
            return null;
        }

        public String getTitle() {
            return null;
        }

        public Image getTitleImage() {
            return null;
        }

        public String getTitleToolTip() {
            return null;
        }

        public void removePropertyListener(IPropertyListener listener) {
        }

        public void setFocus() {
        }

        public Object getAdapter(Class adapter) {
            return null;
        }
    }

    class EmptySearchView
    extends Page
    implements ISearchResultPage {
        Control fControl;
        private String fId;

        EmptySearchView() {
        }

        public void createControl(Composite parent) {
            this.fControl = new Tree(parent, 0);
        }

        public Control getControl() {
            return this.fControl;
        }

        public void setFocus() {
            if (this.fControl != null) {
                this.fControl.setFocus();
            }
        }

        public void setInput(ISearchResult search, Object viewState) {
        }

        public void setViewPart(ISearchResultViewPart part) {
        }

        public Object getUIState() {
            return null;
        }

        public void init(IPageSite pageSite) {
            super.init(pageSite);
            this.getSite().setSelectionProvider(null);
        }

        public void saveState(IMemento memento) {
        }

        public void restoreState(IMemento memento) {
        }

        public void setID(String id) {
            this.fId = id;
        }

        public String getID() {
            return this.fId;
        }

        public String getLabel() {
            return "";
        }
    }
}

