/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.QueryManager;
import org.eclipse.search2.internal.ui.SearchHistorySelectionDialog;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.SearchView;

class ShowSearchHistoryDialogAction
extends Action {
    private SearchView fSearchView;

    public ShowSearchHistoryDialogAction(SearchView searchView) {
        super(SearchMessages.ShowSearchesAction_label);
        this.setToolTipText(SearchMessages.ShowSearchesAction_tooltip);
        this.fSearchView = searchView;
    }

    public void run() {
        List<Object> result;
        QueryManager sm = InternalSearchUI.getInstance().getSearchManager();
        ISearchQuery[] queries = sm.getQueries();
        ArrayList<ISearchResult> input = new ArrayList<ISearchResult>();
        int j = 0;
        while (j < queries.length) {
            ISearchResult search = queries[j].getSearchResult();
            input.add(search);
            ++j;
        }
        SearchHistorySelectionDialog dlg = new SearchHistorySelectionDialog(SearchPlugin.getActiveWorkbenchShell(), input);
        ISearchResult current = this.fSearchView.getCurrentSearchResult();
        if (current != null) {
            Object[] selected = new Object[]{current};
            dlg.setInitialSelections(selected);
        }
        if (dlg.open() == 0 && (result = Arrays.asList(dlg.getResult())) != null && result.size() == 1) {
            ISearchResult searchResult = (ISearchResult)result.get(0);
            InternalSearchUI.getInstance().getSearchManager().touch(searchResult.getQuery());
            this.fSearchView.showSearchResult(searchResult);
        }
    }
}

