/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.ui.text.AbstractSearchMatchInformationProvider;

public class JavaScanner
extends AbstractSearchMatchInformationProvider {
    private static final char[] IMPORT_CHARS = "import".toCharArray();
    private TextSearchMatchAccess fMatchAccess;
    private int fOffset;
    private int fLength;

    protected void scanFile(TextSearchMatchAccess matchAccess) {
        this.fMatchAccess = matchAccess;
        this.fOffset = -1;
        this.fLength = matchAccess.getFileContentLength();
        this.doScanFile();
        this.fMatchAccess = null;
    }

    private void doScanFile() {
        this.addLineOffset(0);
        int c = this.nextChar();
        block10: while (c != -1) {
            switch (c) {
                case 34: {
                    int offset = this.fOffset;
                    c = this.matchStringLiteral();
                    this.addLocation(offset, this.fOffset - offset, 1);
                    break;
                }
                case 76: {
                    int offset;
                    if (this.peekChar() == 34) {
                        offset = this.fOffset;
                        this.nextChar();
                        c = this.matchStringLiteral();
                        this.addLocation(offset, this.fOffset - offset, 1);
                        break;
                    }
                    c = this.matchKeywordOrIdentifier((char)c);
                    break;
                }
                case 39: {
                    c = this.matchCharacterLiteral();
                    break;
                }
                case 47: {
                    int offset = this.fOffset;
                    c = this.nextChar();
                    switch (c) {
                        case 47: {
                            c = this.matchSinglelineComment();
                            this.addLocation(offset, this.fOffset - offset, 2);
                            break;
                        }
                        case 42: {
                            c = this.matchMultilineComment();
                            this.addLocation(offset, this.fOffset - offset, 2);
                        }
                    }
                    continue block10;
                }
                default: {
                    c = Character.isJavaIdentifierStart((char)c) ? this.matchKeywordOrIdentifier((char)c) : this.nextChar();
                }
            }
        }
    }

    private int matchMultilineComment() {
        int c = this.nextChar();
        while (c != -1) {
            if (c == 42) {
                c = this.nextChar();
                if (c != 47) continue;
                return this.nextChar();
            }
            c = this.nextChar();
        }
        return c;
    }

    private int matchSinglelineComment() {
        int c;
        while ((c = this.nextChar()) != 10 && c != 13 && c != -1) {
        }
        if (c == 13 && this.peekChar() == 10) {
            this.nextChar();
        }
        return this.nextChar();
    }

    private int matchKeywordOrIdentifier(int c) {
        boolean isImport;
        int start = this.fOffset;
        int importIdx = 0;
        boolean bl = isImport = c == IMPORT_CHARS[importIdx++];
        while ((c = this.nextChar()) != -1 && Character.isJavaIdentifierPart((char)c)) {
            if (!isImport) continue;
            if (importIdx == IMPORT_CHARS.length) {
                isImport = false;
                continue;
            }
            isImport = IMPORT_CHARS[importIdx++] == c;
        }
        if (isImport) {
            c = this.matchEndOfImport(c);
            this.addLocation(start, this.fOffset - start, 3);
            return c;
        }
        return c;
    }

    private int matchEndOfImport(int c) {
        while (c != 59 && c != -1) {
            c = this.nextChar();
        }
        return this.nextChar();
    }

    private int matchCharacterLiteral() {
        boolean escaped = false;
        while (true) {
            int c = this.nextChar();
            switch (c) {
                case -1: 
                case 10: 
                case 13: {
                    return -1;
                }
                case 92: {
                    escaped = !escaped;
                    break;
                }
                case 39: {
                    if (!escaped) {
                        return this.nextChar();
                    }
                    escaped = false;
                }
            }
        }
    }

    private int matchStringLiteral() {
        boolean escaped = false;
        while (true) {
            int c = this.nextChar();
            switch (c) {
                case -1: 
                case 10: 
                case 13: {
                    return c;
                }
                case 92: {
                    escaped = !escaped;
                    break;
                }
                case 34: {
                    if (!escaped) {
                        return this.nextChar();
                    }
                    escaped = false;
                }
            }
        }
    }

    private int peekChar() {
        int offset = this.fOffset + 1;
        if (offset >= this.fLength) {
            return -1;
        }
        return this.fMatchAccess.getFileContentChar(offset);
    }

    private int nextChar() {
        if (++this.fOffset >= this.fLength) {
            this.fOffset = this.fLength;
            return -1;
        }
        char c = this.fMatchAccess.getFileContentChar(this.fOffset);
        if (c == '\n') {
            this.addLineOffset(this.fOffset + 1);
        } else if (c == '\r' && this.peekChar() != 10) {
            this.addLineOffset(this.fOffset + 1);
        }
        return c;
    }
}

