/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.text.revisions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.internal.text.JFaceTextUtil;
import org.eclipse.jface.internal.text.revisions.ChangeRegion;
import org.eclipse.jface.internal.text.revisions.DiffApplier;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.revisions.Revision;
import org.eclipse.jface.text.revisions.RevisionInformation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.IAnnotationHoverExtension2;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.ILineDiffer;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public final class RevisionPainter {
    private static boolean DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jface.text.source/debug/RevisionRulerColumn"));
    private final ISharedTextColors fSharedColors;
    private final ColorTool fColorTool = new ColorTool();
    private final MouseHandler fMouseHandler = new MouseHandler();
    private final RevisionHover fHover = new RevisionHover();
    private final AnnotationListener fAnnotationListener = new AnnotationListener();
    private final IVerticalRulerColumn fColumn;
    private CompositeRuler fParentRuler;
    private Control fControl;
    private ITextViewer fViewer;
    private StyledText fWidget;
    private RevisionInformation fRevisionInfo;
    private ILineDiffer fLineDiffer = null;
    private IAnnotationModel fAnnotationModel = null;
    private Color fBackground;
    private ArrayList fChangeRegions = null;
    private List fAnnotations = new ArrayList();
    private int fFocusLine = -1;
    private ChangeRegion fFocusRegion = null;
    private Revision fFocusRevision = null;
    private boolean fWheelHandlerInstalled = false;
    private boolean fIsOverviewShowing = false;

    public RevisionPainter(IVerticalRulerColumn column, ISharedTextColors sharedColors) {
        Assert.isLegal((column != null ? 1 : 0) != 0);
        Assert.isLegal((sharedColors != null ? 1 : 0) != 0);
        this.fColumn = column;
        this.fSharedColors = sharedColors;
    }

    public void setRevisionInformation(RevisionInformation info) {
        this.fRevisionInfo = info;
        this.fChangeRegions = null;
        this.updateFocusRegion(null);
        this.fColorTool.setInfo(info);
        this.postRedraw();
    }

    public void setBackground(Color background) {
        this.fBackground = background;
    }

    public void setParentRuler(CompositeRuler parentRuler) {
        this.fParentRuler = parentRuler;
    }

    public void paint(GC gc, ILineRange visibleLines) {
        this.connectIfNeeded();
        if (!this.isConnected()) {
            return;
        }
        List changes = this.getChangeRegions(visibleLines);
        Iterator it = changes.iterator();
        while (it.hasNext()) {
            ChangeRegion region = (ChangeRegion)it.next();
            this.paintChangeRegion(region, gc);
        }
    }

    private void connectIfNeeded() {
        if (this.isConnected() || this.fParentRuler == null) {
            return;
        }
        this.fViewer = this.fParentRuler.getTextViewer();
        if (this.fViewer == null) {
            return;
        }
        this.fWidget = this.fViewer.getTextWidget();
        if (this.fWidget == null) {
            return;
        }
        this.fControl = this.fColumn.getControl();
        if (this.fControl == null) {
            return;
        }
        this.fControl.addMouseTrackListener((MouseTrackListener)this.fMouseHandler);
        this.fControl.addMouseMoveListener((MouseMoveListener)this.fMouseHandler);
        this.fControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RevisionPainter.this.handleDispose();
            }
        });
    }

    private boolean isConnected() {
        return this.fControl != null;
    }

    public void setModel(IAnnotationModel model) {
        IAnnotationModel diffModel = model instanceof IAnnotationModelExtension ? ((IAnnotationModelExtension)model).getAnnotationModel((Object)"diff") : model;
        this.setDiffer(diffModel);
        this.setAnnotationModel(model);
    }

    private void setAnnotationModel(IAnnotationModel model) {
        if (this.fAnnotationModel != model) {
            this.fAnnotationModel = model;
        }
    }

    private void setDiffer(IAnnotationModel differ) {
        if (differ instanceof ILineDiffer && this.fLineDiffer != differ) {
            if (this.fLineDiffer != null) {
                ((IAnnotationModel)this.fLineDiffer).removeAnnotationModelListener((IAnnotationModelListener)this.fAnnotationListener);
            }
            this.fLineDiffer = (ILineDiffer)differ;
            if (this.fLineDiffer != null) {
                ((IAnnotationModel)this.fLineDiffer).addAnnotationModelListener((IAnnotationModelListener)this.fAnnotationListener);
            }
            this.redraw();
        }
    }

    private void handleDispose() {
        this.updateFocusLine(-1);
        if (this.fLineDiffer != null) {
            ((IAnnotationModel)this.fLineDiffer).removeAnnotationModelListener((IAnnotationModelListener)this.fAnnotationListener);
            this.fLineDiffer = null;
        }
    }

    private void paintChangeRegion(ChangeRegion region, GC gc) {
        Revision revision = region.getRevision();
        gc.setBackground(this.lookupColor(revision, false));
        if (revision == this.fFocusRevision) {
            gc.setForeground(this.lookupColor(revision, true));
        }
        List ranges = region.getAdjustedRanges();
        Iterator it = ranges.iterator();
        while (it.hasNext()) {
            ILineRange range = (ILineRange)it.next();
            Rectangle box = this.computeBoxBounds(range);
            if (box == null) {
                return;
            }
            if (revision == this.fFocusRevision) {
                this.paintHighlight(gc, box);
                continue;
            }
            gc.fillRectangle(box);
        }
    }

    private void paintHighlight(GC gc, Rectangle box) {
        boolean fillGradient = false;
        if (fillGradient) {
            this.fillGradientRectangle(gc, box);
        } else {
            gc.fillRectangle(box);
            gc.drawRectangle(box.x, box.y, box.width - 1, box.height - 1);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fillGradientRectangle(GC gc, Rectangle box) {
        int half = (box.width + 1) / 2;
        gc.fillGradientRectangle(box.x, box.y, half, box.height, false);
        gc.fillGradientRectangle(box.x + box.width, box.y, -half, box.height, false);
        Region reg = new Region(gc.getDevice());
        try {
            int[] triangle = new int[]{box.x, box.y, box.x + box.width, box.y, box.x + half, box.y + half};
            reg.add(triangle);
            triangle[1] = triangle[1] + box.height;
            triangle[3] = triangle[3] + box.height;
            triangle[5] = triangle[5] + (box.height - box.width);
            reg.add(triangle);
            gc.setClipping(reg);
            gc.fillGradientRectangle(box.x, box.y, box.width, half, true);
            gc.fillGradientRectangle(box.x, box.y + box.height, box.width, -half, true);
            gc.setClipping(null);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            reg.dispose();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        reg.dispose();
    }

    private Color lookupColor(Revision revision, boolean focus) {
        return this.fSharedColors.getColor(this.fColorTool.getColor(revision, focus));
    }

    private ChangeRegion getChangeRegion(int line) {
        List regions = this.getRegionCache();
        if (regions.isEmpty() || line == -1) {
            return null;
        }
        Iterator it = regions.iterator();
        while (it.hasNext()) {
            ChangeRegion region = (ChangeRegion)it.next();
            if (!RevisionPainter.contains(region.getAdjustedRanges(), line)) continue;
            return region;
        }
        ChangeRegion lastRegion = (ChangeRegion)regions.get(regions.size() - 1);
        if (line == RevisionPainter.end(lastRegion.getAdjustedCoverage())) {
            return lastRegion;
        }
        return null;
    }

    private List getChangeRegions(ILineRange lines) {
        List regions = this.getRegionCache();
        int end = RevisionPainter.end(lines);
        int first = -1;
        int last = -1;
        int i = 0;
        while (i < regions.size()) {
            ChangeRegion region = (ChangeRegion)regions.get(i);
            int coverageEnd = RevisionPainter.end(region.getAdjustedCoverage());
            if (first == -1 && coverageEnd > lines.getStartLine()) {
                first = i;
            }
            if (first != -1 && coverageEnd > end) {
                last = i;
                break;
            }
            ++i;
        }
        if (first == -1) {
            return Collections.EMPTY_LIST;
        }
        if (last == -1) {
            last = regions.size() - 1;
        }
        return regions.subList(first, last + 1);
    }

    private List getRegionCache() {
        if (this.fChangeRegions == null && this.fRevisionInfo != null) {
            ArrayList regions = new ArrayList();
            Iterator revisions = this.fRevisionInfo.getRevisions().iterator();
            while (revisions.hasNext()) {
                Revision revision = (Revision)revisions.next();
                regions.addAll(revision.getRegions());
            }
            Collections.sort(regions, new Comparator(){

                public int compare(Object o1, Object o2) {
                    ChangeRegion r1 = (ChangeRegion)o1;
                    ChangeRegion r2 = (ChangeRegion)o2;
                    return r1.getOriginalRange().getStartLine() - r2.getOriginalRange().getStartLine();
                }
            });
            if (this.fLineDiffer != null) {
                new DiffApplier().applyDiff(regions, this.fLineDiffer, this.fViewer.getDocument().getNumberOfLines());
            }
            this.fChangeRegions = regions;
        }
        if (this.fChangeRegions == null) {
            return Collections.EMPTY_LIST;
        }
        return this.fChangeRegions;
    }

    private static boolean contains(ILineRange range, int line) {
        return range.getStartLine() <= line && RevisionPainter.end(range) > line;
    }

    private static boolean contains(List ranges, int line) {
        Iterator it = ranges.iterator();
        while (it.hasNext()) {
            ILineRange range = (ILineRange)it.next();
            if (!RevisionPainter.contains(range, line)) continue;
            return true;
        }
        return false;
    }

    private static int end(ILineRange range) {
        return range.getStartLine() + range.getNumberOfLines();
    }

    private ILineRange modelLinesToWidgetLines(ILineRange range) {
        int widgetStartLine = -1;
        int widgetEndLine = -1;
        if (this.fViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)((Object)this.fViewer);
            int modelEndLine = RevisionPainter.end(range);
            int modelLine = range.getStartLine();
            while (modelLine < modelEndLine) {
                int widgetLine = extension.modelLine2WidgetLine(modelLine);
                if (widgetLine != -1) {
                    if (widgetStartLine == -1) {
                        widgetStartLine = widgetLine;
                    }
                    widgetEndLine = widgetLine;
                }
                ++modelLine;
            }
        } else {
            IRegion region = this.fViewer.getVisibleRegion();
            IDocument document = this.fViewer.getDocument();
            try {
                int visibleStartLine = document.getLineOfOffset(region.getOffset());
                int visibleEndLine = document.getLineOfOffset(region.getOffset() + region.getLength());
                widgetStartLine = Math.max(0, range.getStartLine() - visibleStartLine);
                widgetEndLine = Math.min(visibleEndLine, RevisionPainter.end(range) - 1);
            }
            catch (BadLocationException x) {
                x.printStackTrace();
            }
        }
        if (widgetStartLine == -1 || widgetEndLine == -1) {
            return null;
        }
        return new LineRange(widgetStartLine, widgetEndLine - widgetStartLine + 1);
    }

    public IAnnotationHover getHover() {
        return this.fHover;
    }

    private Rectangle computeBoxBounds(ILineRange range) {
        ILineRange widgetRange = this.modelLinesToWidgetLines(range);
        if (widgetRange == null) {
            return null;
        }
        int y1 = this.fWidget.getLinePixel(widgetRange.getStartLine());
        int y2 = this.fWidget.getLinePixel(widgetRange.getStartLine() + widgetRange.getNumberOfLines());
        return new Rectangle(0, y1, this.getWidth(), y2 - y1 - 1);
    }

    private void showOverviewAnnotations(Revision revision) {
        Iterator<Object> it;
        if (this.fAnnotationModel == null) {
            return;
        }
        HashMap<RevisionAnnotation, Position> added = null;
        if (revision != null && this.fIsOverviewShowing) {
            added = new HashMap<RevisionAnnotation, Position>();
            it = revision.getRegions().iterator();
            while (it.hasNext()) {
                ChangeRegion region = (ChangeRegion)it.next();
                Iterator regions = region.getAdjustedRanges().iterator();
                while (regions.hasNext()) {
                    ILineRange range = (ILineRange)regions.next();
                    try {
                        IRegion charRegion = this.toCharRegion(range);
                        Position position = new Position(charRegion.getOffset(), charRegion.getLength());
                        RevisionAnnotation annotation = new RevisionAnnotation(revision.getId());
                        added.put(annotation, position);
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
        }
        if (this.fAnnotationModel instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension ext = (IAnnotationModelExtension)this.fAnnotationModel;
            ext.replaceAnnotations(this.fAnnotations.toArray(new Annotation[this.fAnnotations.size()]), added);
        } else {
            it = this.fAnnotations.iterator();
            while (it.hasNext()) {
                Annotation annotation = (Annotation)it.next();
                this.fAnnotationModel.removeAnnotation(annotation);
            }
            if (added != null) {
                it = added.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    this.fAnnotationModel.addAnnotation((Annotation)entry.getKey(), (Position)entry.getValue());
                }
            }
        }
        this.fAnnotations.clear();
        if (added != null) {
            this.fAnnotations.addAll(added.keySet());
        }
    }

    private IRegion toCharRegion(ILineRange lines) throws BadLocationException {
        IDocument document = this.fViewer.getDocument();
        int offset = document.getLineOffset(lines.getStartLine());
        int nextLine = RevisionPainter.end(lines);
        int endOffset = nextLine >= document.getNumberOfLines() ? document.getLength() : document.getLineOffset(nextLine);
        return new org.eclipse.jface.text.Region(offset, endOffset - offset);
    }

    private void updateFocusLine(int line) {
        if (this.fFocusLine != line) {
            this.onFocusLineChanged(this.fFocusLine, line);
        }
    }

    private void onFocusLineChanged(int previousLine, int nextLine) {
        if (DEBUG) {
            System.out.println("line: " + previousLine + " > " + nextLine);
        }
        this.fFocusLine = nextLine;
        ChangeRegion region = this.getChangeRegion(nextLine);
        this.updateFocusRegion(region);
    }

    private void updateFocusRegion(ChangeRegion region) {
        if (region != this.fFocusRegion) {
            this.onFocusRegionChanged(this.fFocusRegion, region);
        }
    }

    private void onFocusRegionChanged(ChangeRegion previousRegion, ChangeRegion nextRegion) {
        Revision revision;
        if (DEBUG) {
            System.out.println("region: " + previousRegion + " > " + nextRegion);
        }
        this.fFocusRegion = nextRegion;
        Revision revision2 = revision = nextRegion == null ? null : nextRegion.getRevision();
        if (this.fFocusRevision != revision) {
            this.onFocusRevisionChanged(this.fFocusRevision, revision);
        }
    }

    private void onFocusRevisionChanged(Revision previousRevision, Revision nextRevision) {
        if (DEBUG) {
            System.out.println("revision: " + previousRevision + " > " + nextRevision);
        }
        this.fFocusRevision = nextRevision;
        this.uninstallWheelHandler();
        this.showOverviewAnnotations(this.fFocusRevision);
        this.redraw();
    }

    private void uninstallWheelHandler() {
        this.fControl.removeListener(37, (Listener)this.fMouseHandler);
        this.fWheelHandlerInstalled = false;
    }

    private void installWheelHandler() {
        if (this.fFocusRevision != null && !this.fWheelHandlerInstalled) {
            this.fControl.addListener(37, (Listener)this.fMouseHandler);
            this.fWheelHandlerInstalled = true;
        }
    }

    private void onHover() {
        this.installWheelHandler();
    }

    private void onEnter() {
        this.fIsOverviewShowing = true;
    }

    private void onExit() {
        this.fIsOverviewShowing = false;
    }

    private void handleMouseWheel(Event event) {
        ILineRange nextWidgetRange;
        int documentHoverLine;
        block12: {
            ILineRange widgetRange;
            ILineRange range;
            Iterator regions;
            ChangeRegion region;
            Iterator it;
            boolean up = event.count > 0;
            documentHoverLine = this.fFocusLine;
            nextWidgetRange = null;
            ILineRange last = null;
            if (up) {
                it = this.fFocusRevision.getRegions().iterator();
                while (it.hasNext()) {
                    region = (ChangeRegion)it.next();
                    regions = region.getAdjustedRanges().iterator();
                    while (regions.hasNext()) {
                        range = (ILineRange)regions.next();
                        widgetRange = this.modelLinesToWidgetLines(range);
                        if (RevisionPainter.contains(range, documentHoverLine)) {
                            nextWidgetRange = last;
                            break block12;
                        }
                        if (widgetRange == null) continue;
                        last = widgetRange;
                    }
                }
            } else {
                it = this.fFocusRevision.getRegions().listIterator(this.fFocusRevision.getRegions().size());
                while (it.hasPrevious()) {
                    region = (ChangeRegion)it.previous();
                    regions = region.getAdjustedRanges().listIterator(region.getAdjustedRanges().size());
                    while (regions.hasPrevious()) {
                        range = (ILineRange)regions.previous();
                        widgetRange = this.modelLinesToWidgetLines(range);
                        if (RevisionPainter.contains(range, documentHoverLine)) {
                            nextWidgetRange = last;
                            break block12;
                        }
                        if (widgetRange == null) continue;
                        last = widgetRange;
                    }
                }
            }
        }
        if (nextWidgetRange == null) {
            return;
        }
        int widgetCurrentFocusLine = this.modelLinesToWidgetLines(new LineRange(documentHoverLine, 1)).getStartLine();
        int widgetNextFocusLine = nextWidgetRange.getStartLine();
        int newTopPixel = this.fWidget.getTopPixel() + JFaceTextUtil.computeLineHeight(this.fWidget, widgetCurrentFocusLine, widgetNextFocusLine, widgetNextFocusLine - widgetCurrentFocusLine);
        this.fWidget.setTopPixel(newTopPixel);
        if (newTopPixel < 0) {
            Point cursorLocation = this.fWidget.getDisplay().getCursorLocation();
            cursorLocation.y += newTopPixel;
            this.fWidget.getDisplay().setCursorLocation(cursorLocation);
        } else {
            int topPixel = this.fWidget.getTopPixel();
            if (topPixel < newTopPixel) {
                Point cursorLocation = this.fWidget.getDisplay().getCursorLocation();
                cursorLocation.y += newTopPixel - topPixel;
                this.fWidget.getDisplay().setCursorLocation(cursorLocation);
            }
        }
        this.updateFocusLine(this.toDocumentLineNumber(this.fWidget.toControl((Point)this.fWidget.getDisplay().getCursorLocation()).y));
        this.immediateUpdate();
    }

    private final void postRedraw() {
        Display d;
        if (this.isConnected() && !this.fControl.isDisposed() && (d = this.fControl.getDisplay()) != null) {
            d.asyncExec(new Runnable(){

                public void run() {
                    RevisionPainter.this.redraw();
                }
            });
        }
    }

    private int toDocumentLineNumber(int y) {
        return this.fParentRuler.toDocumentLineNumber(y);
    }

    private void redraw() {
        this.fColumn.redraw();
    }

    private void immediateUpdate() {
        this.fParentRuler.immediateUpdate();
    }

    private int getWidth() {
        return this.fColumn.getWidth();
    }

    private Color getBackground() {
        if (this.fBackground == null) {
            return this.fWidget.getDisplay().getSystemColor(25);
        }
        return this.fBackground;
    }

    public void setHover(IAnnotationHover hover) {
    }

    public boolean hasHover(int activeLine) {
        return this.fViewer instanceof ISourceViewer && this.fHover.getHoverLineRange((ISourceViewer)this.fViewer, activeLine) != null;
    }

    private static final class RevisionAnnotation
    extends Annotation {
        public RevisionAnnotation(String text) {
            super("org.eclipse.ui.workbench.texteditor.revisionAnnotation", false, text);
        }
    }

    private final class ColorTool {
        private static final float AVERAGE_INTENSITY = 0.6f;
        private static final float MAX_SHADING = 0.8f;
        private static final float MIN_SHADING = 0.3f;
        private static final float FOCUS_COLOR_SHADING = 0.9f;
        private List fRevisions;
        private final Map fColors = new HashMap();
        private final Map fFocusColors = new HashMap();

        ColorTool() {
        }

        public void setInfo(RevisionInformation info) {
            this.fRevisions = null;
            this.fColors.clear();
            this.fFocusColors.clear();
            if (info == null) {
                return;
            }
            ArrayList<Long> revisions = new ArrayList<Long>();
            Iterator it = info.getRevisions().iterator();
            while (it.hasNext()) {
                Revision revision = (Revision)it.next();
                revisions.add(new Long(this.computeAge(revision)));
            }
            Collections.sort(revisions);
            this.fRevisions = revisions;
        }

        private RGB adaptColorToAge(Revision revision, RGB rgb, boolean focus) {
            long age = this.computeAge(revision);
            int size = this.fRevisions.size();
            float relativeAge = size == 1 ? 0.5f : (float)this.fRevisions.indexOf(new Long(age)) / (float)(size - 1);
            return this.getShadedColor(rgb, 1.0f - relativeAge, focus);
        }

        private RGB getShadedColor(RGB color, float scale, boolean focus) {
            Assert.isLegal(((double)scale >= 0.0 ? 1 : 0) != 0);
            Assert.isLegal(((double)scale <= 1.0 ? 1 : 0) != 0);
            RGB background = RevisionPainter.this.getBackground().getRGB();
            if (focus && (scale -= 0.9f) < 0.0f) {
                background = new RGB(255 - background.red, 255 - background.green, 255 - background.blue);
                scale = -scale;
            }
            color = this.normalizeColor(color);
            scale = 0.5f * scale + 0.3f;
            return this.interpolate(color, background, scale);
        }

        private RGB normalizeColor(RGB color) {
            float[] hsi = this.toHSI(color);
            float psychoFactor = 0.6f - this.grayLevel(color);
            float weight = 0.4f;
            hsi[2] = Math.max(0.0f, Math.min(1.0f, hsi[2] + psychoFactor * weight));
            color = this.fromHSI(hsi);
            return color;
        }

        private float grayLevel(RGB rgb) {
            if (rgb.red == rgb.green && rgb.green == rgb.blue) {
                return rgb.red;
            }
            return Math.min(1.0f, (0.2126f * (float)rgb.red + 0.7152f * (float)rgb.green + 0.0722f * (float)rgb.blue + 0.5f) / 255.0f);
        }

        private float[] toHSI(RGB color) {
            float r = (float)color.red / 255.0f;
            float g = (float)color.green / 255.0f;
            float b = (float)color.blue / 255.0f;
            float max = Math.max(Math.max(r, g), b);
            float min = Math.min(Math.min(r, g), b);
            float delta = max - min;
            float maxPlusMin = max + min;
            float intensity = maxPlusMin / 2.0f;
            float saturation = (double)intensity < 0.5 ? delta / maxPlusMin : delta / (2.0f - maxPlusMin);
            float hue = 0.0f;
            if (delta != 0.0f) {
                hue = r == max ? (g - b) / delta : (g == max ? 2.0f + (b - r) / delta : 4.0f + (r - g) / delta);
                if ((hue *= 60.0f) < 0.0f) {
                    hue += 360.0f;
                }
            }
            return new float[]{hue, saturation, intensity};
        }

        private RGB fromHSI(float[] hsi) {
            float r;
            float g;
            float b;
            float hue = hsi[0];
            float saturation = hsi[1];
            float intensity = hsi[2];
            if (saturation == 0.0f) {
                g = b = intensity;
                r = b;
            } else {
                float temp2 = intensity < 0.5f ? intensity * (1.0f + saturation) : intensity + saturation - intensity * saturation;
                float temp1 = 2.0f * intensity - temp2;
                if (hue == 360.0f) {
                    hue = 0.0f;
                }
                r = this.hue2RGB(temp1, temp2, (hue /= 360.0f) + 0.33333334f);
                g = this.hue2RGB(temp1, temp2, hue);
                b = this.hue2RGB(temp1, temp2, hue - 0.33333334f);
            }
            int red = (int)((double)(r * 255.0f) + 0.5);
            int green = (int)((double)(g * 255.0f) + 0.5);
            int blue = (int)((double)(b * 255.0f) + 0.5);
            return new RGB(red, green, blue);
        }

        float hue2RGB(float t1, float t2, float hue) {
            if (hue < 0.0f) {
                hue += 1.0f;
            }
            if (hue > 1.0f) {
                hue -= 1.0f;
            }
            if (6.0f * hue < 1.0f) {
                return t1 + (t2 - t1) * 6.0f * hue;
            }
            if (2.0f * hue < 1.0f) {
                return t2;
            }
            if (3.0f * hue < 2.0f) {
                return t1 + (t2 - t1) * (0.6666667f - hue) * 6.0f;
            }
            return t1;
        }

        private RGB interpolate(RGB fg, RGB bg, float scale) {
            return new RGB((int)((1.0f - scale) * (float)fg.red + scale * (float)bg.red), (int)((1.0f - scale) * (float)fg.green + scale * (float)bg.green), (int)((1.0f - scale) * (float)fg.blue + scale * (float)bg.blue));
        }

        private long computeAge(Revision revision) {
            return revision.getDate().getTime();
        }

        public RGB getColor(Revision revision, boolean focus) {
            Map map = focus ? this.fFocusColors : this.fColors;
            RGB color = (RGB)map.get(revision);
            if (color == null) {
                color = this.adaptColorToAge(revision, revision.getColor(), focus);
                map.put(revision, color);
            }
            return color;
        }
    }

    private class MouseHandler
    implements MouseMoveListener,
    MouseTrackListener,
    Listener {
        MouseHandler() {
        }

        public void mouseUp(MouseEvent event) {
        }

        public void handleEvent(Event event) {
            Assert.isTrue((event.type == 37 ? 1 : 0) != 0);
            RevisionPainter.this.handleMouseWheel(event);
        }

        public void mouseEnter(MouseEvent e) {
            RevisionPainter.this.onEnter();
            RevisionPainter.this.updateFocusLine(RevisionPainter.this.toDocumentLineNumber(e.y));
        }

        public void mouseExit(MouseEvent e) {
            RevisionPainter.this.updateFocusLine(-1);
            RevisionPainter.this.onExit();
        }

        public void mouseHover(MouseEvent e) {
            RevisionPainter.this.onHover();
        }

        public void mouseMove(MouseEvent e) {
            RevisionPainter.this.updateFocusLine(RevisionPainter.this.toDocumentLineNumber(e.y));
        }
    }

    private class AnnotationListener
    implements IAnnotationModelListener {
        AnnotationListener() {
        }

        public void modelChanged(IAnnotationModel model) {
            RevisionPainter.this.fChangeRegions = null;
            RevisionPainter.this.postRedraw();
        }
    }

    private final class RevisionHover
    implements IAnnotationHover,
    IAnnotationHoverExtension,
    IAnnotationHoverExtension2 {
        RevisionHover() {
        }

        public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
            Object info = this.getHoverInfo(sourceViewer, this.getHoverLineRange(sourceViewer, lineNumber), 0);
            return info == null ? null : info.toString();
        }

        public IInformationControlCreator getHoverControlCreator() {
            return null;
        }

        public boolean canHandleMouseCursor() {
            return false;
        }

        public boolean canHandleMouseWheel() {
            return true;
        }

        public Object getHoverInfo(ISourceViewer sourceViewer, ILineRange lineRange, int visibleNumberOfLines) {
            ChangeRegion region = RevisionPainter.this.getChangeRegion(lineRange.getStartLine());
            return region == null ? null : region.getRevision().getHoverInfo();
        }

        public ILineRange getHoverLineRange(ISourceViewer viewer, int lineNumber) {
            ChangeRegion region = RevisionPainter.this.getChangeRegion(lineNumber);
            return region == null ? null : new LineRange(lineNumber, 1);
        }
    }
}

