/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.hyperlink;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class HyperlinkManager
implements Listener,
KeyListener,
MouseListener,
MouseMoveListener,
FocusListener {
    public static final DETECTION_STRATEGY FIRST = new DETECTION_STRATEGY("first");
    public static final DETECTION_STRATEGY ALL = new DETECTION_STRATEGY("all");
    public static final DETECTION_STRATEGY LONGEST_REGION_ALL = new DETECTION_STRATEGY("all with same longest region");
    public static final DETECTION_STRATEGY LONGEST_REGION_FIRST = new DETECTION_STRATEGY("first with longest region");
    private ITextViewer fTextViewer;
    private boolean fActive;
    private int fHyperlinkStateMask;
    private IHyperlink[] fActiveHyperlinks;
    private IHyperlinkDetector[] fHyperlinkDetectors;
    private IHyperlinkPresenter fHyperlinkPresenter;
    private final DETECTION_STRATEGY fDetectionStrategy;

    public HyperlinkManager(DETECTION_STRATEGY detectionStrategy) {
        Assert.isNotNull((Object)detectionStrategy);
        this.fDetectionStrategy = detectionStrategy;
    }

    public void install(ITextViewer textViewer, IHyperlinkPresenter hyperlinkPresenter, IHyperlinkDetector[] hyperlinkDetectors, int eventStateMask) {
        Assert.isNotNull((Object)textViewer);
        Assert.isNotNull((Object)hyperlinkPresenter);
        this.fTextViewer = textViewer;
        this.fHyperlinkPresenter = hyperlinkPresenter;
        Assert.isLegal((!this.fHyperlinkPresenter.canShowMultipleHyperlinks() && (this.fDetectionStrategy == FIRST || this.fDetectionStrategy == LONGEST_REGION_FIRST) ? 1 : 0) != 0);
        this.setHyperlinkDetectors(hyperlinkDetectors);
        this.setHyperlinkStateMask(eventStateMask);
        StyledText text = this.fTextViewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        text.getDisplay().addFilter(2, (Listener)this);
        text.addKeyListener((KeyListener)this);
        text.addMouseListener((MouseListener)this);
        text.addMouseMoveListener((MouseMoveListener)this);
        text.addFocusListener((FocusListener)this);
        this.fHyperlinkPresenter.install(this.fTextViewer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setHyperlinkDetectors(IHyperlinkDetector[] hyperlinkDetectors) {
        Assert.isTrue((hyperlinkDetectors != null && hyperlinkDetectors.length > 0 ? 1 : 0) != 0);
        if (this.fHyperlinkDetectors == null) {
            this.fHyperlinkDetectors = hyperlinkDetectors;
            return;
        }
        IHyperlinkDetector[] iHyperlinkDetectorArray = this.fHyperlinkDetectors;
        synchronized (this.fHyperlinkDetectors) {
            this.fHyperlinkDetectors = hyperlinkDetectors;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setHyperlinkStateMask(int eventStateMask) {
        this.fHyperlinkStateMask = eventStateMask;
    }

    public void uninstall() {
        this.deactivate();
        StyledText text = this.fTextViewer.getTextWidget();
        if (text != null && !text.isDisposed()) {
            text.removeKeyListener((KeyListener)this);
            text.getDisplay().removeFilter(2, (Listener)this);
            text.removeMouseListener((MouseListener)this);
            text.removeMouseMoveListener((MouseMoveListener)this);
            text.removeFocusListener((FocusListener)this);
        }
        this.fHyperlinkPresenter.uninstall();
        this.fHyperlinkPresenter = null;
        this.fTextViewer = null;
        this.fHyperlinkDetectors = null;
    }

    protected void deactivate() {
        this.fHyperlinkPresenter.hideHyperlinks();
        this.fActive = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IHyperlink[] findHyperlinks() {
        int offset = this.getCurrentTextOffset();
        if (offset == -1) {
            return null;
        }
        boolean canShowMultipleHyperlinks = this.fHyperlinkPresenter.canShowMultipleHyperlinks();
        Region region = new Region(offset, 0);
        ArrayList<IHyperlink> allHyperlinks = new ArrayList<IHyperlink>(this.fHyperlinkDetectors.length * 2);
        IHyperlinkDetector[] iHyperlinkDetectorArray = this.fHyperlinkDetectors;
        synchronized (this.fHyperlinkDetectors) {
            int i = 0;
            int length = this.fHyperlinkDetectors.length;
            while (i < length) {
                IHyperlink[] hyperlinks;
                IHyperlinkDetector detector = this.fHyperlinkDetectors[i];
                if (detector != null && (hyperlinks = detector.detectHyperlinks(this.fTextViewer, (IRegion)region, canShowMultipleHyperlinks)) != null) {
                    Assert.isLegal((hyperlinks.length > 0 ? 1 : 0) != 0);
                    if (this.fDetectionStrategy == FIRST) {
                        if (hyperlinks.length == 1) {
                            // ** MonitorExit[var5_5] (shouldn't be in output)
                            return hyperlinks;
                        }
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return new IHyperlink[]{hyperlinks[0]};
                    }
                    allHyperlinks.addAll(Arrays.asList(hyperlinks));
                }
                ++i;
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            if (allHyperlinks.isEmpty()) {
                return null;
            }
            if (this.fDetectionStrategy != ALL) {
                int maxLength = this.computeLongestHyperlinkLength(allHyperlinks);
                Iterator iter = new ArrayList(allHyperlinks).iterator();
                while (iter.hasNext()) {
                    IHyperlink hyperlink = (IHyperlink)iter.next();
                    if (hyperlink.getHyperlinkRegion().getLength() >= maxLength) continue;
                    allHyperlinks.remove(hyperlink);
                }
            }
            if (this.fDetectionStrategy == LONGEST_REGION_FIRST) {
                return new IHyperlink[]{(IHyperlink)allHyperlinks.get(0)};
            }
            return allHyperlinks.toArray(new IHyperlink[allHyperlinks.size()]);
        }
    }

    protected int computeLongestHyperlinkLength(List hyperlinks) {
        Assert.isLegal((hyperlinks != null && !hyperlinks.isEmpty() ? 1 : 0) != 0);
        Iterator iter = hyperlinks.iterator();
        int length = Integer.MIN_VALUE;
        while (iter.hasNext()) {
            IRegion region = ((IHyperlink)iter.next()).getHyperlinkRegion();
            if (region.getLength() < length) continue;
            length = region.getLength();
        }
        return length;
    }

    protected int getCurrentTextOffset() {
        try {
            StyledText text = this.fTextViewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return -1;
            }
            Display display = text.getDisplay();
            Point absolutePosition = display.getCursorLocation();
            Point relativePosition = text.toControl(absolutePosition);
            int widgetOffset = text.getOffsetAtLocation(relativePosition);
            if (this.fTextViewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 extension = (ITextViewerExtension5)((Object)this.fTextViewer);
                return extension.widgetOffset2ModelOffset(widgetOffset);
            }
            return widgetOffset + this.fTextViewer.getVisibleRegion().getOffset();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return -1;
        }
    }

    public void keyPressed(KeyEvent event) {
        if (this.fActive) {
            this.deactivate();
            return;
        }
        if (event.keyCode != this.fHyperlinkStateMask) {
            this.deactivate();
            return;
        }
        this.fActive = true;
    }

    public void keyReleased(KeyEvent event) {
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent event) {
        if (!this.fActive) {
            return;
        }
        if (event.stateMask != this.fHyperlinkStateMask) {
            this.deactivate();
            return;
        }
        if (event.button != 1) {
            this.deactivate();
            return;
        }
    }

    public void mouseUp(MouseEvent e) {
        if (!this.fActive) {
            this.fActiveHyperlinks = null;
            return;
        }
        if (e.button != 1) {
            this.fActiveHyperlinks = null;
        }
        this.deactivate();
        if (this.fActiveHyperlinks != null) {
            this.fActiveHyperlinks[0].open();
        }
    }

    public void mouseMove(MouseEvent event) {
        if (event.stateMask != this.fHyperlinkStateMask) {
            if (this.fActive) {
                this.deactivate();
            }
            return;
        }
        this.fActive = true;
        StyledText text = this.fTextViewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            this.deactivate();
            return;
        }
        if ((event.stateMask & 0x80000) != 0 && text.getSelectionCount() != 0) {
            this.deactivate();
            return;
        }
        this.fActiveHyperlinks = this.findHyperlinks();
        if (this.fActiveHyperlinks == null || this.fActiveHyperlinks.length == 0) {
            this.fHyperlinkPresenter.hideHyperlinks();
            return;
        }
        this.fHyperlinkPresenter.showHyperlinks(this.fActiveHyperlinks);
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent event) {
        this.deactivate();
    }

    public void handleEvent(Event event) {
        this.deactivate();
    }

    public static final class DETECTION_STRATEGY {
        String fName;

        private DETECTION_STRATEGY(String name) {
            this.fName = name;
        }

        public String toString() {
            return this.fName;
        }
    }
}

