/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.mapping;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.IProgressMonitor;

public class SimpleResourceMapping
extends ResourceMapping {
    public static final String MODEL_PROVIDER = "org.eclipse.core.resources.modelProvider";
    private final IResource resource;
    private ResourceTraversal[] traversals;

    public SimpleResourceMapping(IResource resource) {
        this.resource = resource;
    }

    public boolean contains(ResourceMapping mapping) {
        Object object;
        if (mapping.getModelProviderId().equals(this.getModelProviderId()) && (object = mapping.getModelObject()) instanceof IResource) {
            IResource other = (IResource)object;
            return this.resource.getFullPath().isPrefixOf(other.getFullPath());
        }
        return false;
    }

    public Object getModelObject() {
        return this.resource;
    }

    public String getModelProviderId() {
        return MODEL_PROVIDER;
    }

    public IProject[] getProjects() {
        if (this.resource.getType() == 8) {
            return ((IWorkspaceRoot)this.resource).getProjects();
        }
        return new IProject[]{this.resource.getProject()};
    }

    public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) {
        if (this.traversals == null) {
            this.traversals = new ResourceTraversal[]{new ResourceTraversal(new IResource[]{this.resource}, 2, 0)};
        }
        return this.traversals;
    }
}

