/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.DefaultASTVisitor;

class ASTRecoveryPropagator
extends DefaultASTVisitor {
    private IProblem[] problems;

    ASTRecoveryPropagator(IProblem[] problems) {
        this.problems = problems;
    }

    protected boolean visitNode(ASTNode node) {
        return this.checkAndTagAsMalformed(node);
    }

    private boolean checkAndTagAsMalformed(ASTNode node) {
        boolean tagWithErrors = false;
        int i = 0;
        int max = this.problems.length;
        while (i < max) {
            block5: {
                IProblem problem = this.problems[i];
                switch (problem.getID()) {
                    case 0x600000CC: 
                    case 1610612941: 
                    case 1610612945: 
                    case 1610612946: 
                    case 0x600000E6: 
                    case 1610612967: 
                    case 1610612968: 
                    case 1610612969: 
                    case 1610612970: 
                    case 1610612971: 
                    case 1610612972: 
                    case 1610612973: 
                    case 0x600000EE: 
                    case 1610612975: 
                    case 0x600000F0: 
                    case 1610612977: 
                    case 1610612978: 
                    case 1610612986: 
                    case 1610612987: 
                    case 1610612988: 
                    case 1610612989: 
                    case 1610612990: 
                    case 0x600000FF: 
                    case 0x60000100: 
                    case 0x60000101: 
                    case 1610612994: 
                    case 1610612995: 
                    case 1610612996: 
                    case 0x60000106: {
                        break;
                    }
                    default: {
                        break block5;
                    }
                }
                int problemStart = problem.getSourceStart();
                int problemEnd = problem.getSourceEnd();
                int start = node.getStartPosition();
                int end = start + node.getLength();
                if (start <= problemStart && problemStart <= end || start <= problemEnd && problemEnd <= end) {
                    node.setFlags(node.getFlags() | 8);
                    tagWithErrors = true;
                }
            }
            ++i;
        }
        return tagWithErrors;
    }
}

