/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BindingResolver;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.IResolvedAnnotation;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ResolvedAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.SearchableEnvironment;

class PackageBinding
implements IPackageBinding {
    private static final String[] NO_NAME_COMPONENTS = new String[0];
    private static final String UNNAMED = "";
    private static final char PACKAGE_NAME_SEPARATOR = '.';
    private org.eclipse.jdt.internal.compiler.lookup.PackageBinding binding;
    private String name;
    private BindingResolver resolver;
    private String[] components;

    PackageBinding(org.eclipse.jdt.internal.compiler.lookup.PackageBinding binding, BindingResolver resolver) {
        this.binding = binding;
        this.resolver = resolver;
    }

    public IResolvedAnnotation[] getAnnotations() {
        try {
            INameEnvironment nameEnvironment = this.binding.environment.nameEnvironment;
            if (!(nameEnvironment instanceof SearchableEnvironment)) {
                return ResolvedAnnotation.NoAnnotations;
            }
            NameLookup nameLookup = ((SearchableEnvironment)nameEnvironment).nameLookup;
            if (nameLookup == null) {
                return ResolvedAnnotation.NoAnnotations;
            }
            String pkgName = this.getName();
            IPackageFragment[] pkgs = nameLookup.findPackageFragments(pkgName, false);
            if (pkgs == null) {
                return ResolvedAnnotation.NoAnnotations;
            }
            int i = 0;
            int len = pkgs.length;
            while (i < len) {
                int fragType = pkgs[i].getKind();
                switch (fragType) {
                    case 1: {
                        String unitName = "package-info.java";
                        ICompilationUnit unit = pkgs[i].getCompilationUnit(unitName);
                        if (unit == null) break;
                        ASTParser p = ASTParser.newParser(3);
                        p.setSource(unit);
                        p.setResolveBindings(true);
                        p.setUnitName(unitName);
                        p.setFocalPosition(0);
                        p.setKind(8);
                        CompilationUnit domUnit = (CompilationUnit)p.createAST(null);
                        PackageDeclaration pkgDecl = domUnit.getPackage();
                        if (pkgDecl == null) break;
                        List annos = pkgDecl.annotations();
                        if (annos == null || annos.isEmpty()) {
                            return ResolvedAnnotation.NoAnnotations;
                        }
                        IResolvedAnnotation[] result = new IResolvedAnnotation[annos.size()];
                        int index = 0;
                        Iterator it = annos.iterator();
                        while (it.hasNext()) {
                            result[index] = ((Annotation)it.next()).resolveAnnotation();
                            if (result[index] == null) {
                                return ResolvedAnnotation.NoAnnotations;
                            }
                            ++index;
                        }
                        return result;
                    }
                    case 2: {
                        NameEnvironmentAnswer answer = nameEnvironment.findType(TypeConstants.PACKAGE_INFO_NAME, this.binding.compoundName);
                        if (answer == null || !answer.isBinaryType()) break;
                        IBinaryType type = answer.getBinaryType();
                        IBinaryAnnotation[] binaryAnnotations = type.getAnnotations();
                        AnnotationBinding[] binaryInstances = BinaryTypeBinding.createAnnotations(binaryAnnotations, this.binding.environment);
                        AnnotationBinding[] allInstances = AnnotationBinding.addStandardAnnotations(binaryInstances, type.getTagBits(), this.binding.environment);
                        int total = allInstances.length;
                        IResolvedAnnotation[] domInstances = new ResolvedAnnotation[total];
                        int a = 0;
                        while (a < total) {
                            domInstances[a] = this.resolver.getAnnotationInstance(allInstances[a]);
                            if (domInstances[a] == null) {
                                return ResolvedAnnotation.NoAnnotations;
                            }
                            ++a;
                        }
                        return domInstances;
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            return ResolvedAnnotation.NoAnnotations;
        }
        return ResolvedAnnotation.NoAnnotations;
    }

    public String getName() {
        if (this.name == null) {
            this.computeNameAndComponents();
        }
        return this.name;
    }

    public boolean isUnnamed() {
        return this.getName().equals(UNNAMED);
    }

    public String[] getNameComponents() {
        if (this.components == null) {
            this.computeNameAndComponents();
        }
        return this.components;
    }

    public int getKind() {
        return 1;
    }

    public int getModifiers() {
        return -1;
    }

    public boolean isDeprecated() {
        return false;
    }

    public boolean isSynthetic() {
        return false;
    }

    public IJavaElement getJavaElement() {
        INameEnvironment nameEnvironment = this.binding.environment.nameEnvironment;
        if (!(nameEnvironment instanceof SearchableEnvironment)) {
            return null;
        }
        NameLookup nameLookup = ((SearchableEnvironment)nameEnvironment).nameLookup;
        if (nameLookup == null) {
            return null;
        }
        IPackageFragment[] pkgs = nameLookup.findPackageFragments(this.getName(), false);
        if (pkgs == null) {
            return null;
        }
        return pkgs[0];
    }

    public String getKey() {
        return new String(this.binding.computeUniqueKey());
    }

    public boolean isEqualTo(IBinding other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof PackageBinding)) {
            return false;
        }
        org.eclipse.jdt.internal.compiler.lookup.PackageBinding packageBinding2 = ((PackageBinding)other).binding;
        return CharOperation.equals(this.binding.compoundName, packageBinding2.compoundName);
    }

    private void computeNameAndComponents() {
        char[][] compoundName = this.binding.compoundName;
        if (compoundName == CharOperation.NO_CHAR_CHAR || compoundName == null) {
            this.name = UNNAMED;
            this.components = NO_NAME_COMPONENTS;
        } else {
            int length = compoundName.length;
            this.components = new String[length];
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < length - 1) {
                this.components[i] = new String(compoundName[i]);
                buffer.append(compoundName[i]).append('.');
                ++i;
            }
            this.components[length - 1] = new String(compoundName[length - 1]);
            buffer.append(compoundName[length - 1]);
            this.name = buffer.toString();
        }
    }

    public String toString() {
        return this.binding.toString();
    }
}

