/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import org.eclipse.jdt.core.dom.BindingResolver;
import org.eclipse.jdt.core.dom.IResolvedAnnotation;
import org.eclipse.jdt.core.dom.IResolvedMemberValuePair;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ResolvedDefaultValuePair;
import org.eclipse.jdt.core.dom.ResolvedMemberValuePair;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ElementValuePair;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;

class ResolvedAnnotation
implements IResolvedAnnotation {
    static final ResolvedAnnotation[] NoAnnotations = new ResolvedAnnotation[0];
    private AnnotationBinding internalAnnotation;
    private BindingResolver bindingResolver;

    ResolvedAnnotation(AnnotationBinding annotation, BindingResolver resolver) {
        if (annotation == null) {
            throw new IllegalStateException();
        }
        this.internalAnnotation = annotation;
        this.bindingResolver = resolver;
    }

    public ITypeBinding getAnnotationType() {
        ITypeBinding binding = this.bindingResolver.getTypeBinding(this.internalAnnotation.getAnnotationType());
        if (binding == null || !binding.isAnnotation()) {
            return null;
        }
        return binding;
    }

    public IResolvedMemberValuePair[] getDeclaredMemberValuePairs() {
        ElementValuePair[] internalPairs = this.internalAnnotation.getElementValuePairs();
        int length = internalPairs.length;
        IResolvedMemberValuePair[] pairs = length == 0 ? ResolvedMemberValuePair.NoPair : new ResolvedMemberValuePair[length];
        int i = 0;
        while (i < length) {
            pairs[i] = new ResolvedMemberValuePair(internalPairs[i], this.bindingResolver);
            ++i;
        }
        return pairs;
    }

    public IResolvedMemberValuePair[] getAllMemberValuePairs() {
        int methodLength;
        IResolvedMemberValuePair[] pairs = this.getDeclaredMemberValuePairs();
        ReferenceBinding typeBinding = this.internalAnnotation.getAnnotationType();
        if (typeBinding == null) {
            return pairs;
        }
        MethodBinding[] methods = typeBinding.methods();
        int n = methodLength = methods == null ? 0 : methods.length;
        if (methodLength == 0) {
            return pairs;
        }
        int declaredLength = pairs.length;
        if (declaredLength == methodLength) {
            return pairs;
        }
        HashtableOfObject table = new HashtableOfObject(declaredLength);
        int i = 0;
        while (i < declaredLength) {
            table.put(((ResolvedMemberValuePair)pairs[i]).internalName(), pairs[i]);
            ++i;
        }
        IResolvedMemberValuePair[] allPairs = new IResolvedMemberValuePair[methodLength];
        int i2 = 0;
        while (i2 < methodLength) {
            Object pair = table.get(methods[i2].selector);
            allPairs[i2] = pair == null ? new ResolvedDefaultValuePair(methods[i2], this.bindingResolver) : (IResolvedMemberValuePair)pair;
            ++i2;
        }
        return allPairs;
    }

    public String toString() {
        ITypeBinding type = this.getAnnotationType();
        StringBuffer buffer = new StringBuffer();
        buffer.append('@');
        if (type != null) {
            buffer.append(type.getName());
        }
        buffer.append('(');
        IResolvedMemberValuePair[] pairs = this.getDeclaredMemberValuePairs();
        int i = 0;
        int len = pairs.length;
        while (i < len) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(pairs[i].toString());
            ++i;
        }
        buffer.append(')');
        return buffer.toString();
    }
}

